/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.MHelper;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGlowingSphere
extends SimpleAnimatedParticle {
    private int ticks;
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected ParticleGlowingSphere(ClientLevel world, double x, double y, double z, SpriteSet sprites, double r, double g, double b) {
        super(world, x, y, z, sprites, 0.0f);
        this.setSprite(sprites.get(this.random));
        this.lifetime = MHelper.randRange((int)150, (int)300, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.05f, (float)0.15f, (RandomSource)this.random);
        this.setFadeColor(15916745);
        this.setSpriteFromAge(sprites);
        this.preVX = this.random.nextGaussian() * 0.02;
        this.preVY = this.random.nextGaussian() * 0.02;
        this.preVZ = this.random.nextGaussian() * 0.02;
        this.nextVX = this.random.nextGaussian() * 0.02;
        this.nextVY = this.random.nextGaussian() * 0.02;
        this.nextVZ = this.random.nextGaussian() * 0.02;
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks > 30) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.random.nextGaussian() * 0.02;
            this.nextVY = this.random.nextGaussian() * 0.02;
            this.nextVZ = this.random.nextGaussian() * 0.02;
            this.ticks = 0;
        }
        double delta = (double)this.ticks / 30.0;
        this.xd = Mth.lerp((double)delta, (double)this.preVX, (double)this.nextVX);
        this.yd = Mth.lerp((double)delta, (double)this.preVY, (double)this.nextVY);
        this.zd = Mth.lerp((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactoryGlowingSphere
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactoryGlowingSphere(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new ParticleGlowingSphere(world, x, y, z, this.sprites, 1.0, 1.0, 1.0);
        }
    }
}

