/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;

@OnlyIn(value=Dist.CLIENT)
public class ParticleTenaneaPetal
extends TextureSheetParticle {
    private static BlockColor provider;
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected ParticleTenaneaPetal(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet sprites) {
        super(world, x, y, z, r, g, b);
        this.pickSprite(sprites);
        if (provider == null) {
            CustomColorProvider block = (CustomColorProvider)EndBlocks.TENANEA_FLOWERS;
            provider = block.getProvider();
        }
        int color = provider.getColor(null, null, new BlockPos((int)x, (int)y, (int)z), 0);
        this.rCol = (float)(color >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(color >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(color & 0xFF) / 255.0f;
        this.lifetime = MHelper.randRange((int)120, (int)200, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.05f, (float)0.15f, (RandomSource)this.random);
        this.setAlpha(0.0f);
        this.preVX = 0.0;
        this.preVY = 0.0;
        this.preVZ = 0.0;
        this.nextVX = this.random.nextGaussian() * 0.02;
        this.nextVY = -this.random.nextDouble() * 0.02 - 0.02;
        this.nextVZ = this.random.nextGaussian() * 0.02;
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public void tick() {
        int ticks = this.age & 0x3F;
        if (ticks == 0) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.random.nextGaussian() * 0.02;
            this.nextVY = -this.random.nextDouble() * 0.02 - 0.02;
            this.nextVZ = this.random.nextGaussian() * 0.02;
        }
        double delta = (double)ticks / 63.0;
        if (this.age <= 40) {
            this.setAlpha((float)this.age / 40.0f);
        } else if (this.age >= this.lifetime - 40) {
            this.setAlpha((float)(this.lifetime - this.age) / 40.0f);
        }
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd = Mth.lerp((double)delta, (double)this.preVX, (double)this.nextVX);
        this.yd = Mth.lerp((double)delta, (double)this.preVY, (double)this.nextVY);
        this.zd = Mth.lerp((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactoryTenaneaPetal
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactoryTenaneaPetal(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new ParticleTenaneaPetal(world, x, y, z, 1.0, 1.0, 1.0, this.sprites);
        }
    }
}

