/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.rituals;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.blocks.RunedFlavolite;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.network.RitualUpdate;
import org.betterx.betterend.portal.PortalBuilder;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.Nullable;

public class EternalRitual {
    private static final Set<Point> PEDESTAL_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(-4, -5), new Point(-4, 5), new Point(-6, 0), new Point(4, -5), new Point(4, 5), new Point(6, 0)});
    private static final Block PEDESTAL = EndBlocks.ETERNAL_PEDESTAL;
    public static final BooleanProperty ACTIVE = BlockProperties.ACTIVE;
    private Level world;
    private Direction.Axis axis;
    private ResourceLocation targetWorldId;
    private BlockPos center;
    private BlockPos exit;
    private boolean active = false;
    private boolean willActivate = false;

    public EternalRitual(Level world) {
        this.world = world;
    }

    public EternalRitual(Level world, BlockPos initial) {
        this(world);
        this.configure(initial);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public Level getWorld() {
        return this.world;
    }

    @Nullable
    public ResourceLocation getTargetWorldId() {
        return this.targetWorldId;
    }

    private boolean isInvalid() {
        return this.world == null || this.world.isClientSide() || this.center == null || this.axis == null;
    }

    public void checkStructure(Player player) {
        Direction moveY;
        Direction moveX;
        if (this.isInvalid()) {
            return;
        }
        if (Direction.Axis.X == this.axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        boolean valid = this.checkFrame(this.world, this.center.below());
        Item item = null;
        for (Point pos : PEDESTAL_POSITIONS) {
            EternalPedestalEntity pedestal;
            BlockPos.MutableBlockPos checkPos = this.center.mutable();
            checkPos.move(moveX, pos.x).move(moveY, pos.y);
            if (!(valid &= this.isActive((BlockPos)checkPos)) || (pedestal = (EternalPedestalEntity)this.world.getBlockEntity((BlockPos)checkPos)) == null) continue;
            Item pItem = pedestal.getItem(0).getItem();
            if (item == null) {
                item = pItem;
                continue;
            }
            if (item.equals(pItem)) continue;
            valid = false;
        }
        if (valid && item != null) {
            this.activatePortal(player, item);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                BECriteria.PORTAL_ON.trigger(sp);
            }
        }
    }

    public void updateActiveStateOnPedestals() {
        if (this.world == null) {
            return;
        }
        EternalRitual.updateActiveStateOnPedestals(this.center, this.axis, this.active, this.willActivate, this.world, this);
        Level level = this.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new RitualUpdate(this).sendToClient(serverLevel);
        }
    }

    public static void updateActiveStateOnPedestals(BlockPos center, Direction.Axis axis, boolean active, boolean willActivate, Level world, EternalRitual fallback) {
        Direction moveY;
        Direction moveX;
        if (Direction.Axis.X == axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        for (Point pos : PEDESTAL_POSITIONS) {
            BlockPos.MutableBlockPos checkPos = center.mutable();
            checkPos.move(moveX, pos.x).move(moveY, pos.y);
            BlockEntity blockEntity = world.getBlockEntity((BlockPos)checkPos);
            if (!(blockEntity instanceof EternalPedestalEntity)) continue;
            EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
            if (pedestal.hasRitual()) {
                if (fallback == null) {
                    fallback = pedestal.getRitual();
                }
                pedestal.getRitual().active = active;
                pedestal.getRitual().willActivate = willActivate;
                continue;
            }
            if (fallback == null) {
                fallback = new EternalRitual(world);
                fallback.center = center;
                fallback.axis = axis;
                fallback.willActivate = willActivate;
                fallback.active = active;
            }
            pedestal.linkRitual(fallback);
        }
    }

    private boolean checkFrame(Level world, BlockPos framePos) {
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        boolean valid = true;
        for (Point point : PortalBuilder.FRAME_POSITIONS) {
            BlockPos.MutableBlockPos pos = framePos.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
            BlockState state = world.getBlockState((BlockPos)pos);
            valid &= state.getBlock() instanceof RunedFlavolite;
            pos = framePos.mutable().move(moveDir, -point.x).move(Direction.UP, point.y);
            state = world.getBlockState((BlockPos)pos);
            valid &= state.getBlock() instanceof RunedFlavolite;
        }
        return valid;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean willActivate() {
        return this.willActivate;
    }

    private void activatePortal(Player player, Item keyItem) {
        if (this.active) {
            return;
        }
        this.willActivate = true;
        this.updateActiveStateOnPedestals();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)keyItem);
        int portalId = EndPortals.getPortalIdByItem(itemId);
        Level targetWorld = this.getTargetWorld(portalId);
        ResourceLocation worldId = targetWorld.dimension().location();
        try {
            if (this.exit == null) {
                this.initPortal(player, worldId, portalId);
            } else {
                if (!worldId.equals((Object)this.targetWorldId)) {
                    this.initPortal(player, worldId, portalId);
                } else if (!this.checkFrame(targetWorld, this.exit.below())) {
                    Direction.Axis portalAxis = Direction.Axis.X == this.axis ? Direction.Axis.Z : Direction.Axis.X;
                    PortalBuilder.generatePortal(targetWorld, this.exit, portalAxis, portalId);
                }
                this.activatePortal(targetWorld, this.exit, portalId);
            }
            this.activatePortal(this.world, this.center, portalId);
            Level level = this.world;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.doEffects(serverLevel, this.center);
            }
            this.willActivate = false;
            this.active = true;
            this.updateActiveStateOnPedestals();
        }
        catch (Exception ex) {
            BetterEnd.LOGGER.error("Create End portals error.", ex);
            this.removePortal(targetWorld, this.exit);
            this.removePortal(this.world, this.center);
            this.willActivate = false;
            this.active = false;
            this.updateActiveStateOnPedestals();
        }
    }

    private void initPortal(Player player, ResourceLocation worldId, int portalId) {
        this.targetWorldId = worldId;
        Level level = this.world;
        if (level instanceof ServerLevel) {
            WorldBorder worldBorder;
            ServerLevel sourceWorld = (ServerLevel)level;
            ServerLevel targetLevel = (ServerLevel)this.getTargetWorld(portalId);
            PortalBuilder builder = new PortalBuilder(this.world, targetLevel);
            Optional<PortalBuilder.FoundPortalRect> foundRectangle = builder.findPortalAround(this.center, worldBorder = targetLevel.getWorldBorder());
            if (foundRectangle.isEmpty()) {
                Optional<BlockPos> centerPos = builder.createPortal(PortalBuilder.getStartingPos((Level)sourceWorld, (Level)targetLevel, (Entity)player, worldBorder), this.axis, portalId);
                centerPos.ifPresent(blockPos -> {
                    this.exit = blockPos;
                });
            }
        }
    }

    private void doEffects(ServerLevel serverWorld, BlockPos center) {
        Direction moveY;
        Direction moveX;
        if (Direction.Axis.X == this.axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        for (Point pos : PEDESTAL_POSITIONS) {
            BlockPos.MutableBlockPos p = center.mutable();
            p.move(moveX, pos.x).move(moveY, pos.y);
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)p.getX() + 0.5, (double)p.getY() + 1.5, (double)p.getZ() + 0.5, 20, 0.0, 0.0, 0.0, 1.0);
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (double)p.getX() + 0.5, (double)p.getY() + 1.5, (double)p.getZ() + 0.5, 20, 0.0, 0.0, 0.0, 0.3);
        }
        serverWorld.playSound(null, center, SoundEvents.END_PORTAL_SPAWN, SoundSource.NEUTRAL, 16.0f, 1.0f);
    }

    private void activatePortal(Level world, BlockPos center, int portalId) {
        BlockPos framePos = center.below();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        BlockState frame = (BlockState)PortalBuilder.FRAME.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
        PortalBuilder.FRAME_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = framePos.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
            BlockState state = world.getBlockState((BlockPos)pos);
            if (state.hasProperty((Property)ACTIVE) && !((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                world.setBlockAndUpdate((BlockPos)pos, frame);
            }
            if ((state = world.getBlockState((BlockPos)(pos = framePos.mutable().move(moveDir, -point.x).move(Direction.UP, point.y)))).hasProperty((Property)ACTIVE) && !((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                world.setBlockAndUpdate((BlockPos)pos, frame);
            }
        });
        Direction.Axis portalAxis = Direction.Axis.X == this.axis ? Direction.Axis.Z : Direction.Axis.X;
        BlockState portal = (BlockState)((BlockState)PortalBuilder.PORTAL.defaultBlockState().setValue((Property)EndPortalBlock.AXIS, (Comparable)portalAxis)).setValue((Property)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        BlockParticleOption effect = new BlockParticleOption(ParticleTypes.BLOCK, portal);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            PortalBuilder.PORTAL_POSITIONS.forEach(arg_0 -> EternalRitual.lambda$activatePortal$2(center, moveDir, world, portal, serverWorld, (ParticleOptions)effect, arg_0));
        }
    }

    public void disablePortal(int state) {
        if (!this.active || this.isInvalid()) {
            return;
        }
        if (!this.world.isClientSide()) {
            this.removePortal(this.getTargetWorld(state), this.exit);
        }
        this.removePortal(this.world, this.center);
    }

    private void removePortal(Level world, BlockPos center) {
        if (world == null || center == null) {
            return;
        }
        BlockPos framePos = center.below();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        PortalBuilder.FRAME_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = framePos.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
            BlockState state = world.getBlockState((BlockPos)pos);
            if (state.is(PortalBuilder.FRAME) && ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                world.setBlockAndUpdate((BlockPos)pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
            if ((state = world.getBlockState((BlockPos)(pos = framePos.mutable().move(moveDir, -point.x).move(Direction.UP, point.y)))).is(PortalBuilder.FRAME) && ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
                world.setBlockAndUpdate((BlockPos)pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        });
        PortalBuilder.PORTAL_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = center.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
            if (world.getBlockState((BlockPos)pos).is(PortalBuilder.PORTAL)) {
                world.removeBlock((BlockPos)pos, false);
            }
            if (world.getBlockState((BlockPos)(pos = center.mutable().move(moveDir, -point.x).move(Direction.UP, point.y))).is(PortalBuilder.PORTAL)) {
                world.removeBlock((BlockPos)pos, false);
            }
        });
        this.active = false;
        this.updateActiveStateOnPedestals();
    }

    private Level getTargetWorld(int state) {
        if (this.world.dimension() == Level.END) {
            return EndPortals.getWorld(this.world.getServer(), state);
        }
        return Objects.requireNonNull(this.world.getServer()).getLevel(Level.END);
    }

    public void configure(BlockPos initial) {
        BlockPos checkPos = initial.east(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = initial.east(6);
            return;
        }
        checkPos = initial.west(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = initial.west(6);
            return;
        }
        checkPos = initial.south(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = initial.south(6);
            return;
        }
        checkPos = initial.north(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = initial.north(6);
            return;
        }
        checkPos = initial.north(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = this.hasPedestal(checkPos = checkPos.east(8)) ? initial.north(5).east(4) : initial.north(5).west(4);
            return;
        }
        checkPos = initial.south(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = this.hasPedestal(checkPos = checkPos.east(8)) ? initial.south(5).east(4) : initial.south(5).west(4);
            return;
        }
        checkPos = initial.east(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = this.hasPedestal(checkPos = checkPos.south(8)) ? initial.east(5).south(4) : initial.east(5).north(4);
            return;
        }
        checkPos = initial.west(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = this.hasPedestal(checkPos = checkPos.south(8)) ? initial.west(5).south(4) : initial.west(5).north(4);
        }
    }

    private boolean hasPedestal(BlockPos pos) {
        return this.world.getBlockState(pos).is(PEDESTAL);
    }

    private boolean isActive(BlockPos pos) {
        BlockState state = this.world.getBlockState(pos);
        if (state.is(PEDESTAL)) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)this.world.getBlockEntity(pos);
            if (pedestal != null) {
                if (!pedestal.hasRitual()) {
                    pedestal.linkRitual(this);
                } else {
                    EternalRitual ritual = pedestal.getRitual();
                    if (!ritual.equals(this)) {
                        pedestal.linkRitual(this);
                    }
                }
            }
            return (Boolean)state.getValue((Property)ACTIVE);
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
        tag.putString("axis", this.axis.getName());
        tag.putBoolean("active", this.active);
        if (this.targetWorldId != null) {
            tag.putString("key_item", this.targetWorldId.toString());
        }
        if (this.exit != null) {
            tag.put("exit", NbtUtils.writeBlockPos((BlockPos)this.exit));
        }
        return tag;
    }

    public void fromTag(CompoundTag tag) {
        this.axis = Direction.Axis.byName((String)tag.getString("axis"));
        this.center = NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO);
        this.active = tag.getBoolean("active");
        if (tag.contains("exit")) {
            this.exit = NbtUtils.readBlockPos((CompoundTag)tag, (String)"exit").orElse(BlockPos.ZERO);
        }
        if (tag.contains("key_item")) {
            this.targetWorldId = ResourceLocation.parse((String)tag.getString("key_item"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EternalRitual ritual = (EternalRitual)o;
        return this.world.equals(ritual.world) && Objects.equals(this.center, ritual.center) && Objects.equals(this.exit, ritual.exit);
    }

    public static EternalRitual findRitualForActivePortal(Level world, BlockPos startPos) {
        BlockState state = world.getBlockState(startPos);
        if (EternalRitual.isActivePortalBlock(state)) {
            BlockEntity blockEntity;
            Direction direction;
            Direction direction2 = direction = state.getValue((Property)NetherPortalBlock.AXIS) == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
            while (world.getBlockState(startPos.below()).is(EndBlocks.END_PORTAL_BLOCK)) {
                startPos = startPos.below();
            }
            if (world.getBlockState(startPos.relative(direction, -1)).is(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.relative(direction, 1);
            } else if (world.getBlockState(startPos.relative(direction, 1)).is(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.relative(direction, -1);
            }
            if (!world.getBlockState(startPos.below()).is(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.below();
            }
            if (world.getBlockState(startPos.relative(direction, -1)).is(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.relative(direction, 1);
            } else if (world.getBlockState(startPos.relative(direction, 1)).is(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.relative(direction, -1);
            }
            startPos = startPos.relative(direction.getClockWise(), 6);
            state = world.getBlockState(startPos);
            if (state.is(EndBlocks.ETERNAL_PEDESTAL) && (blockEntity = world.getBlockEntity(startPos)) instanceof EternalPedestalEntity) {
                EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
                return pedestal.getRitual();
            }
            return null;
        }
        return null;
    }

    private static boolean isActivePortalBlock(BlockState state) {
        return state.is(EndBlocks.END_PORTAL_BLOCK) && state.hasProperty((Property)NetherPortalBlock.AXIS);
    }

    private static /* synthetic */ void lambda$activatePortal$2(BlockPos center, Direction moveDir, Level world, BlockState portal, ServerLevel serverWorld, ParticleOptions effect, Point point) {
        BlockPos.MutableBlockPos pos = center.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
        if (!world.getBlockState((BlockPos)pos).is(PortalBuilder.PORTAL)) {
            world.setBlockAndUpdate((BlockPos)pos, portal);
            serverWorld.sendParticles(effect, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
        if (!world.getBlockState((BlockPos)(pos = center.mutable().move(moveDir, -point.x).move(Direction.UP, point.y))).is(PortalBuilder.PORTAL)) {
            world.setBlockAndUpdate((BlockPos)pos, portal);
            serverWorld.sendParticles(effect, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
    }
}

