/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.blocks.BaseDoublePlantBlock;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.blocks.StalactiteBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.BlueVineBlock;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.registry.EndBlocks;

public class BlockFixer {
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private static final BlockState WATER = Blocks.WATER.defaultBlockState();

    public static void fixBlocks(LevelAccessor level, BlockPos start, BlockPos end) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
        ResourceLocation dimKey = registry.getKey((Object)level.dimensionType());
        if (dimKey != null && "world_blender".equals(dimKey.getNamespace())) {
            return;
        }
        Set doubleCheck = Sets.newConcurrentHashSet();
        int dx = end.getX() - start.getX() + 1;
        int dz = end.getZ() - start.getZ() + 1;
        int count = dx * dz;
        int minY = Math.max(start.getY(), level.getMinBuildHeight());
        int maxY = Math.min(end.getY(), level.getMaxBuildHeight());
        IntStream.range(0, count).forEach(index -> {
            BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
            POS.setX(index % dx + start.getX());
            POS.setZ(index / dx + start.getZ());
            block2: for (int y = minY; y <= maxY; ++y) {
                POS.setY(y);
                BlockState state = level.getBlockState((BlockPos)POS);
                if (state.getBlock() instanceof FurBlock) {
                    doubleCheck.add(POS.immutable());
                    continue;
                }
                if (!state.getFluidState().isEmpty()) {
                    if (!state.canSurvive((LevelReader)level, (BlockPos)POS)) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, WATER);
                        POS.setY(POS.getY() - 1);
                        state = level.getBlockState((BlockPos)POS);
                        while (!state.canSurvive((LevelReader)level, (BlockPos)POS)) {
                            state = state.getFluidState().isEmpty() ? AIR : WATER;
                            BlockFixer.setWithoutUpdate(level, (BlockPos)POS, state);
                            POS.setY(POS.getY() - 1);
                            state = level.getBlockState((BlockPos)POS);
                        }
                    }
                    POS.setY(y - 1);
                    if (level.isEmptyBlock((BlockPos)POS)) {
                        POS.setY(y);
                        while (!level.getFluidState((BlockPos)POS).isEmpty()) {
                            BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                            POS.setY(POS.getY() + 1);
                        }
                        continue;
                    }
                    for (Direction dir : BlocksHelper.HORIZONTAL) {
                        if (!level.isEmptyBlock(POS.relative(dir))) continue;
                        try {
                            level.scheduleTick((BlockPos)POS, state.getFluidState().getType(), 0);
                        }
                        catch (Exception exception) {}
                        continue block2;
                    }
                    continue;
                }
                if (state.is(EndBlocks.SMARAGDANT_CRYSTAL) || state.is(EndBlocks.BUDDING_SMARAGDANT_CRYSTAL)) {
                    POS.setY(POS.getY() - 1);
                    if (!level.isEmptyBlock((BlockPos)POS)) continue;
                    POS.setY(POS.getY() + 1);
                    while (state.is(EndBlocks.SMARAGDANT_CRYSTAL) || state.is(EndBlocks.BUDDING_SMARAGDANT_CRYSTAL)) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.setY(POS.getY() + 1);
                        state = level.getBlockState((BlockPos)POS);
                    }
                    continue;
                }
                if (state.getBlock() instanceof StalactiteBlock) {
                    if (state.canSurvive((LevelReader)level, (BlockPos)POS)) continue;
                    if (level.getBlockState(POS.above()).getBlock() instanceof StalactiteBlock) {
                        while (state.getBlock() instanceof StalactiteBlock) {
                            BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                            POS.setY(POS.getY() + 1);
                            state = level.getBlockState((BlockPos)POS);
                        }
                        continue;
                    }
                    while (state.getBlock() instanceof StalactiteBlock) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.setY(POS.getY() - 1);
                        state = level.getBlockState((BlockPos)POS);
                    }
                    continue;
                }
                if (state.is(EndBlocks.CAVE_PUMPKIN)) {
                    if (level.getBlockState(POS.above()).is(EndBlocks.CAVE_PUMPKIN_SEED)) continue;
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                    continue;
                }
                if (state.canSurvive((LevelReader)level, (BlockPos)POS)) continue;
                if (state.is(Blocks.CHORUS_PLANT)) {
                    HashSet ends = Sets.newHashSet();
                    HashSet add = Sets.newHashSet();
                    ends.add(POS.immutable());
                    for (int i = 0; i < 64 && !ends.isEmpty(); ++i) {
                        ends.forEach(pos -> {
                            BlockFixer.setWithoutUpdate(level, pos, AIR);
                            for (Direction dir : BlocksHelper.HORIZONTAL) {
                                BlockPos p = pos.relative(dir);
                                BlockState st = level.getBlockState(p);
                                if (!st.is(Blocks.CHORUS_PLANT) && !st.is(Blocks.CHORUS_FLOWER) || st.canSurvive((LevelReader)level, p)) continue;
                                add.add(p);
                            }
                            BlockPos p = pos.above();
                            BlockState st = level.getBlockState(p);
                            if ((st.is(Blocks.CHORUS_PLANT) || st.is(Blocks.CHORUS_FLOWER)) && !st.canSurvive((LevelReader)level, p)) {
                                add.add(p);
                            }
                        });
                        ends.clear();
                        ends.addAll(add);
                        add.clear();
                    }
                    continue;
                }
                if (state.getBlock() instanceof BaseVineBlock) {
                    while (level.getBlockState((BlockPos)POS).getBlock() instanceof BaseVineBlock) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.setY(POS.getY() - 1);
                    }
                    continue;
                }
                if (state.getBlock() instanceof FallingBlock) {
                    BlockState falling = state;
                    POS.setY(POS.getY() - 1);
                    state = level.getBlockState((BlockPos)POS);
                    int ray = BlocksHelper.downRayRep((LevelAccessor)level, (BlockPos)POS.immutable(), (int)64);
                    if (ray > 32) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, Blocks.END_STONE.defaultBlockState());
                        if (!level.getRandom().nextBoolean()) continue;
                        POS.setY(POS.getY() - 1);
                        state = level.getBlockState((BlockPos)POS);
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, Blocks.END_STONE.defaultBlockState());
                        continue;
                    }
                    POS.setY(y);
                    BlockState replacement = AIR;
                    for (Direction dir : BlocksHelper.HORIZONTAL) {
                        state = level.getBlockState(POS.relative(dir));
                        if (state.getFluidState().isEmpty()) continue;
                        replacement = state;
                        break;
                    }
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, replacement);
                    POS.setY(y - ray);
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, falling);
                    continue;
                }
                if (state.getBlock() instanceof BlueVineBlock) {
                    while (state.is(EndBlocks.BLUE_VINE) || state.is(EndBlocks.BLUE_VINE_LANTERN) || state.is(EndBlocks.BLUE_VINE_FUR)) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.setY(POS.getY() + 1);
                        state = level.getBlockState((BlockPos)POS);
                    }
                }
                if (state.getBlock() instanceof BaseDoublePlantBlock) {
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                    POS.setY(POS.getY() + 1);
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                    continue;
                }
                BlockFixer.setWithoutUpdate(level, (BlockPos)POS, BlockFixer.getAirOrFluid(state));
            }
        });
        doubleCheck.forEach(pos -> {
            if (!level.getBlockState(pos).canSurvive((LevelReader)level, pos)) {
                BlockFixer.setWithoutUpdate(level, pos, AIR);
            }
        });
    }

    private static BlockState getAirOrFluid(BlockState state) {
        return state.getFluidState().isEmpty() ? AIR : state.getFluidState().createLegacyBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        LevelAccessor levelAccessor = world;
        synchronized (levelAccessor) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        }
    }
}

