/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.util;

import java.io.IOException;
import java.io.InputStream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.BetterEnd;

public class EndStructureHelper {
    private EndStructureHelper() {
    }

    public static StructureTemplate readStructure(ResourceLocation resource) {
        if (!"betterend".equals(resource.getNamespace())) {
            return StructureHelper.readStructure((ResourceLocation)resource);
        }
        return EndStructureHelper.readStructureFromBetterEnd(resource);
    }

    public static StructureTemplate readStructure(String path) {
        InputStream stream = BetterEnd.class.getResourceAsStream(path);
        if (stream != null) {
            return EndStructureHelper.readStructureFromStream(path, stream);
        }
        return StructureHelper.readStructure((String)path);
    }

    private static StructureTemplate readStructureFromBetterEnd(ResourceLocation resource) {
        String path = "/data/" + resource.getNamespace() + "/structure/" + resource.getPath() + ".nbt";
        InputStream stream = BetterEnd.class.getResourceAsStream(path);
        if (stream == null) {
            return StructureHelper.readStructure((ResourceLocation)resource);
        }
        return EndStructureHelper.readStructureFromStream(path, stream);
    }

    private static StructureTemplate readStructureFromStream(String path, InputStream stream) {
        StructureTemplate structureTemplate;
        block8: {
            InputStream input = stream;
            try {
                CompoundTag tag = NbtIo.readCompressed((InputStream)input, (NbtAccounter)NbtAccounter.unlimitedHeap());
                StructureTemplate template = new StructureTemplate();
                template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), tag);
                structureTemplate = template;
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read structure " + path, e);
                }
            }
            input.close();
        }
        return structureTemplate;
    }
}

