/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.datafixers.util.Function13;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.betterend.world.features.terrain.caves.CaveChunkPopulatorFeatureConfig;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.feature.api.placed.PlacedFeatureKey;
import org.betterx.wover.feature.api.placed.PlacedFeatureManager;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndCaveBiome
extends EndBiome {
    private static final Codec<WeightedList<ResourceKey<ConfiguredFeature<?, ?>>>> FEATURE_KEY_LIST_CODEC = WeightedList.listCodec((Codec)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE), (String)"configured_features", (String)"configured_feature");
    public static final MapCodec<EndCaveBiome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(EndCaveBiome::new);
    public static final MapCodec<EndCaveBiome> NETWORK_CODEC = EndCaveBiome.simpleCaveBiomeNetworkCodec(EndCaveBiome::new);
    public static final KeyDispatchDataCodec<EndCaveBiome> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    public static final KeyDispatchDataCodec<EndCaveBiome> NETWORK_KEY_CODEC = KeyDispatchDataCodec.of(NETWORK_CODEC);
    private final WeightedList<Holder<? extends ConfiguredFeature<?, ?>>> floorFeatures = new WeightedList();
    private final WeightedList<Holder<? extends ConfiguredFeature<?, ?>>> ceilFeatures = new WeightedList();
    private final WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> floorFeatureKeys = new WeightedList();
    private final WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> ceilFeatureKeys = new WeightedList();
    private boolean featuresResolved = false;

    public static <T extends EndCaveBiome> MapCodec<T> simpleCaveBiomeCodec(Function13<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, ResourceKey<Biome>, ResourceKey<Biome>, Boolean, SurfaceMaterialProvider, WeightedList<Holder<ConfiguredFeature<?, ?>>>, WeightedList<Holder<ConfiguredFeature<?, ?>>>, T> factory) {
        return EndCaveBiome.codec((RecordCodecBuilder)Codec.BOOL.fieldOf("has_caves").orElse((Object)true).forGetter(EndBiome::hasCaves), (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)new EndBiome.DefaultSurfaceMaterialProvider()).forGetter(o -> o.surfMatProv), (RecordCodecBuilder)WeightedList.listCodec((Codec)ConfiguredFeature.CODEC, (String)"configured_features", (String)"configured_feature").fieldOf("floor_features").forGetter(o -> o.floorFeatures), (RecordCodecBuilder)WeightedList.listCodec((Codec)ConfiguredFeature.CODEC, (String)"configured_features", (String)"configured_feature").fieldOf("ceil_features").forGetter(o -> o.ceilFeatures), factory);
    }

    public static <T extends EndCaveBiome> MapCodec<T> simpleCaveBiomeNetworkCodec(Function13<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, ResourceKey<Biome>, ResourceKey<Biome>, Boolean, SurfaceMaterialProvider, WeightedList<Holder<ConfiguredFeature<?, ?>>>, WeightedList<Holder<ConfiguredFeature<?, ?>>>, T> factory) {
        return EndCaveBiome.codec((RecordCodecBuilder)Codec.BOOL.fieldOf("has_caves").orElse((Object)true).forGetter(EndBiome::hasCaves), (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)new EndBiome.DefaultSurfaceMaterialProvider()).forGetter(o -> o.surfMatProv), (RecordCodecBuilder)FEATURE_KEY_LIST_CODEC.optionalFieldOf("floor_features", (Object)new WeightedList()).forGetter(o -> o.getFloorFeatureKeysForCodec()), (RecordCodecBuilder)FEATURE_KEY_LIST_CODEC.optionalFieldOf("ceil_features", (Object)new WeightedList()).forGetter(o -> o.getCeilFeatureKeysForCodec()), (fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCaves, surface, floorKeys, ceilKeys) -> {
            EndCaveBiome biomeData = (EndCaveBiome)((Object)((Object)factory.apply(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCaves, surface, (Object)new WeightedList(), (Object)new WeightedList())));
            biomeData.setFeatureKeys((WeightedList<ResourceKey<ConfiguredFeature<?, ?>>>)floorKeys, (WeightedList<ResourceKey<ConfiguredFeature<?, ?>>>)ceilKeys);
            return biomeData;
        });
    }

    @Override
    public KeyDispatchDataCodec<? extends WoverBiomeData> codec() {
        return KEY_CODEC;
    }

    public KeyDispatchDataCodec<? extends WoverBiomeData> networkCodec() {
        return NETWORK_KEY_CODEC;
    }

    protected EndCaveBiome(float fogDensity, @NotNull ResourceKey<Biome> biome, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<Biome> edge, @Nullable ResourceKey<Biome> parent, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<Holder<ConfiguredFeature<?, ?>>> floorFeatures, WeightedList<Holder<ConfiguredFeature<?, ?>>> ceilFeatures) {
        super(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCaves, surface);
        this.floorFeatures.addAll(floorFeatures);
        this.ceilFeatures.addAll(ceilFeatures);
        this.floorFeatureKeys.addAll(EndCaveBiome.toKeyList(floorFeatures));
        this.ceilFeatureKeys.addAll(EndCaveBiome.toKeyList(ceilFeatures));
    }

    public void addFloorFeature(Holder<? extends ConfiguredFeature<?, ?>> feature, float weight) {
        this.floorFeatures.add(feature, weight);
        feature.unwrapKey().ifPresent(key -> this.floorFeatureKeys.add(EndCaveBiome.castFeatureKey(key), weight));
    }

    public void addCeilFeature(Holder<? extends ConfiguredFeature<?, ?>> feature, float weight) {
        this.ceilFeatures.add(feature, weight);
        feature.unwrapKey().ifPresent(key -> this.ceilFeatureKeys.add(EndCaveBiome.castFeatureKey(key), weight));
    }

    public Holder<? extends ConfiguredFeature<?, ?>> getFloorFeature(RandomSource random) {
        this.resolveFeatureKeys();
        return this.floorFeatures.isEmpty() ? null : (Holder)this.floorFeatures.get(random);
    }

    public Holder<? extends ConfiguredFeature<?, ?>> getCeilFeature(RandomSource random) {
        this.resolveFeatureKeys();
        return this.ceilFeatures.isEmpty() ? null : (Holder)this.ceilFeatures.get(random);
    }

    protected void setFeatureKeys(WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> floorKeys, WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> ceilKeys) {
        if (floorKeys != null && !floorKeys.isEmpty()) {
            this.floorFeatureKeys.addAll(floorKeys);
        }
        if (ceilKeys != null && !ceilKeys.isEmpty()) {
            this.ceilFeatureKeys.addAll(ceilKeys);
        }
    }

    private WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> getFloorFeatureKeysForCodec() {
        if (this.floorFeatureKeys.isEmpty() && !this.floorFeatures.isEmpty()) {
            this.floorFeatureKeys.addAll(EndCaveBiome.toKeyList(this.floorFeatures));
        }
        return this.floorFeatureKeys;
    }

    private WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> getCeilFeatureKeysForCodec() {
        if (this.ceilFeatureKeys.isEmpty() && !this.ceilFeatures.isEmpty()) {
            this.ceilFeatureKeys.addAll(EndCaveBiome.toKeyList(this.ceilFeatures));
        }
        return this.ceilFeatureKeys;
    }

    private void resolveFeatureKeys() {
        if (this.featuresResolved) {
            return;
        }
        if (!this.floorFeatures.isEmpty() || !this.ceilFeatures.isEmpty()) {
            this.featuresResolved = true;
            return;
        }
        if (this.floorFeatureKeys.isEmpty() && this.ceilFeatureKeys.isEmpty()) {
            this.featuresResolved = true;
            return;
        }
        RegistryAccess access = WorldState.registryAccess();
        if (access == null) {
            access = WorldState.allStageRegistryAccess();
        }
        if (access == null) {
            return;
        }
        Registry registry = access.registry(Registries.CONFIGURED_FEATURE).orElse(null);
        if (registry == null) {
            return;
        }
        EndCaveBiome.addFeaturesFromKeys(registry, this.floorFeatureKeys, this.floorFeatures);
        EndCaveBiome.addFeaturesFromKeys(registry, this.ceilFeatureKeys, this.ceilFeatures);
        this.featuresResolved = true;
    }

    private static void addFeaturesFromKeys(Registry<ConfiguredFeature<?, ?>> registry, WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> keys, WeightedList<Holder<? extends ConfiguredFeature<?, ?>>> target) {
        for (int i = 0; i < keys.size(); ++i) {
            ResourceKey key = (ResourceKey)keys.get(i);
            float weight = keys.getWeight(i);
            registry.getHolder(key).ifPresent(holder -> target.add(holder, weight));
        }
    }

    private static WeightedList<ResourceKey<ConfiguredFeature<?, ?>>> toKeyList(WeightedList<? extends Holder<? extends ConfiguredFeature<?, ?>>> holders) {
        WeightedList keys = new WeightedList();
        if (holders == null || holders.isEmpty()) {
            return keys;
        }
        for (int i = 0; i < holders.size(); ++i) {
            Holder holder = (Holder)holders.get(i);
            ResourceKey key = holder.unwrapKey().orElse(null);
            if (key == null) continue;
            keys.add(EndCaveBiome.castFeatureKey(key), holders.getWeight(i));
        }
        return keys;
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> castFeatureKey(ResourceKey<? extends ConfiguredFeature<?, ?>> key) {
        return key;
    }

    public float getFloorDensity() {
        return 0.0f;
    }

    public float getCeilDensity() {
        return 0.0f;
    }

    public BlockState getCeil(BlockPos pos) {
        return null;
    }

    public BlockState getWall(BlockPos pos) {
        return null;
    }

    public static abstract class Config<C extends Config<?>>
    extends EndBiome.Config {
        public final PlacedFeatureKey populatorFeature;
        public final CaveChunkPopulatorFeatureConfig populatorConfig;

        protected Config(EndBiomeKey<C, ?> key) {
            this.populatorFeature = (PlacedFeatureKey)PlacedFeatureManager.createKey((ResourceLocation)BetterEnd.C.mk(key.key.location().getPath() + "_cave_populator")).setDecoration(GenerationStep.Decoration.UNDERGROUND_DECORATION);
            this.populatorConfig = new CaveChunkPopulatorFeatureConfig(key.dataKey.location());
        }

        @Override
        public void addCustomBuildData(EndBiomeBuilder builder) {
            ((EndBiomeBuilder)((EndBiomeBuilder)builder.feature((BasePlacedFeatureKey)this.populatorFeature)).music(EndSounds.MUSIC_CAVES)).loop(EndSounds.AMBIENT_CAVES);
        }

        @Override
        public boolean hasCaves() {
            return false;
        }

        @Override
        public boolean hasReturnGateway() {
            return false;
        }

        @Override
        @NotNull
        public EndBiome instantiateBiome(float fogDensity, BiomeKey<?> key, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<Biome> edge, @Nullable ResourceKey<Biome> parent, boolean hasCave, SurfaceMaterialProvider surface) {
            return new EndCaveBiome(fogDensity, (ResourceKey<Biome>)key.key, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCave, surface, new WeightedList(), new WeightedList());
        }
    }
}

