/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndLotusLeafBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.ScatterFeatureConfig;
import org.betterx.wover.block.api.BlockProperties;

public class EndLotusLeafFeature
extends ScatterFeature<ScatterFeatureConfig> {
    public EndLotusLeafFeature() {
        super(ScatterFeatureConfig.CODEC);
    }

    @Override
    public void generate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        if (this.canGenerate(world, blockPos)) {
            this.generateLeaf(world, blockPos);
        }
    }

    @Override
    protected int getChance() {
        return 15;
    }

    @Override
    protected BlockPos getCenterGround(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return DefaultFeature.getPosOnSurface((WorldGenLevel)world, (BlockPos)pos);
    }

    private void generateLeaf(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockState leaf = EndBlocks.END_LOTUS_LEAF.defaultBlockState();
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)leaf.setValue(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
        for (Direction move : BlocksHelper.HORIZONTAL) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.set((Vec3i)pos).move(move), (BlockState)((BlockState)((BlockState)leaf.setValue(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)move)).setValue(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
        }
        for (int i = 0; i < 4; ++i) {
            Direction d1 = BlocksHelper.HORIZONTAL[i];
            Direction d2 = BlocksHelper.HORIZONTAL[i + 1 & 3];
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.set((Vec3i)pos).move(d1).move(d2), (BlockState)((BlockState)((BlockState)leaf.setValue(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)d1)).setValue(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean canGenerate(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        p.setY(pos.getY());
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            p.setX(pos.getX() + x);
            for (int z = -1; z < 2; ++z) {
                p.setZ(pos.getZ() + z);
                if (!world.isEmptyBlock((BlockPos)p) || !world.getBlockState(p.below()).is(Blocks.WATER)) continue;
                ++count;
            }
        }
        return count == 9;
    }

    @Override
    public boolean canGenerate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        return world.isEmptyBlock(blockPos) && world.getBlockState(blockPos.below()).is(Blocks.WATER);
    }
}

