/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.GlobalState;
import org.betterx.wover.block.api.BlockProperties;

public class SilkMothNestFeature
extends DefaultFeature {
    private boolean canGenerate(WorldGenLevel world, BlockPos pos) {
        Direction[] directionArray;
        int n;
        int n2;
        BlockState state = world.getBlockState(pos.above());
        if ((state.is(BlockTags.LEAVES) || state.is(BlockTags.LOGS)) && ((state = world.getBlockState(pos)).isAir() || state.is(EndBlocks.TENANEA_OUTER_LEAVES)) && world.isEmptyBlock(pos.below()) && (n2 = 0) < (n = (directionArray = BlocksHelper.HORIZONTAL).length)) {
            Direction dir = directionArray[n2];
            return !world.getBlockState(pos.below().relative(dir)).blocksMotion();
        }
        return false;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        RandomSource random = featureConfig.random();
        BlockPos center = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        int maxY = world.getHeight(Heightmap.Types.WORLD_SURFACE, center.getX(), center.getZ());
        int minY = BlocksHelper.upRay((LevelAccessor)world, (BlockPos)new BlockPos(center.getX(), 0, center.getZ()), (int)maxY);
        POS.set((Vec3i)center);
        for (int y = maxY; y > minY; --y) {
            POS.setY(y);
            if (!this.canGenerate(world, (BlockPos)POS)) continue;
            Direction dir = BlocksHelper.randomHorizontal((RandomSource)random);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)((BlockState)((BlockState)EndBlocks.SILK_MOTH_NEST.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir)).setValue((Property)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false))));
            POS.setY(y - 1);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)((BlockState)EndBlocks.SILK_MOTH_NEST.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir)));
            return true;
        }
        return false;
    }
}

