/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.features.terrain.caves.CaveChunkPopulatorFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class CaveChunkPopulatorFeature
extends Feature<CaveChunkPopulatorFeatureConfig> {
    public CaveChunkPopulatorFeature() {
        super(CaveChunkPopulatorFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<CaveChunkPopulatorFeatureConfig> featureConfig) {
        CaveChunkPopulatorFeatureConfig cfg = (CaveChunkPopulatorFeatureConfig)featureConfig.config();
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        ChunkGenerator chunkGenerator = featureConfig.chunkGenerator();
        HashSet floorPositions = Sets.newHashSet();
        HashSet ceilPositions = Sets.newHashSet();
        int sx = pos.getX() >> 4 << 4;
        int sz = pos.getZ() >> 4 << 4;
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        this.fillSets(sx, sz, world.getChunk(pos), floorPositions, ceilPositions, min, max);
        EndCaveBiome biome = cfg.getCaveBiome();
        if (biome == null) {
            return false;
        }
        BlockState surfaceBlock = Blocks.END_STONE.defaultBlockState();
        this.placeFloor(world, chunkGenerator, biome, floorPositions, random, surfaceBlock);
        this.placeCeil(world, chunkGenerator, biome, ceilPositions, random);
        BlockFixer.fixBlocks((LevelAccessor)world, (BlockPos)min, (BlockPos)max);
        return true;
    }

    protected void fillSets(int sx, int sz, ChunkAccess chunk, Set<BlockPos> floorPositions, Set<BlockPos> ceilPositions, BlockPos.MutableBlockPos min, BlockPos.MutableBlockPos max) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mut2 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mut3 = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            mut.setX(x);
            mut2.setX(x);
            for (int z = 0; z < 16; ++z) {
                mut.setZ(z);
                mut2.setZ(z);
                mut2.setY(0);
                for (int y = 1; y < chunk.getMaxBuildHeight(); ++y) {
                    mut.setY(y);
                    BlockState top = chunk.getBlockState((BlockPos)mut);
                    BlockState bottom = chunk.getBlockState((BlockPos)mut2);
                    if (top.isAir() && (bottom.is(CommonBlockTags.END_STONES) || bottom.is(Blocks.STONE))) {
                        mut3.set((Vec3i)mut2).move(sx, 0, sz);
                        floorPositions.add(mut3.immutable());
                        this.updateMin((BlockPos)mut3, min);
                        this.updateMax((BlockPos)mut3, max);
                    } else if (bottom.isAir() && (top.is(CommonBlockTags.END_STONES) || top.is(Blocks.STONE))) {
                        mut3.set((Vec3i)mut).move(sx, 0, sz);
                        ceilPositions.add(mut3.immutable());
                        this.updateMin((BlockPos)mut3, min);
                        this.updateMax((BlockPos)mut3, max);
                    }
                    mut2.setY(y);
                }
            }
        }
    }

    private void updateMin(BlockPos pos, BlockPos.MutableBlockPos min) {
        if (pos.getX() < min.getX()) {
            min.setX(pos.getX());
        }
        if (pos.getY() < min.getY()) {
            min.setY(pos.getY());
        }
        if (pos.getZ() < min.getZ()) {
            min.setZ(pos.getZ());
        }
    }

    private void updateMax(BlockPos pos, BlockPos.MutableBlockPos max) {
        if (pos.getX() > max.getX()) {
            max.setX(pos.getX());
        }
        if (pos.getY() > max.getY()) {
            max.setY(pos.getY());
        }
        if (pos.getZ() > max.getZ()) {
            max.setZ(pos.getZ());
        }
    }

    protected void placeFloor(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> floorPositions, RandomSource random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            ConfiguredFeature feature;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)surfaceBlock);
            if (density > 0.0f && random.nextFloat() <= density && (feature = (ConfiguredFeature)biome.getFloorFeature(random).value()) != null) {
                feature.place(world, generator, random, pos.above());
            }
        });
    }

    protected void placeCeil(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> ceilPositions, RandomSource random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            ConfiguredFeature feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = (ConfiguredFeature)biome.getCeilFeature(random).value()) != null) {
                feature.place(world, generator, random, pos.below());
            }
        });
    }
}

