/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.joml.Vector3f;

public class GiganticAmaranitaFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(BlockTags.NYLIUM)) {
            return false;
        }
        float size = MHelper.randRange((int)5, (int)10, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)5);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.7f, (float)0.0f, (float)0.7f);
        if (!SplineHelper.canGenerate((List)spline, (BlockPos)pos, (WorldGenLevel)world, this.replaceFunc())) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)AIR);
        float radius = size * 0.17f;
        SDF function = SplineHelper.buildSDF((List)spline, (float)radius, (float)0.2f, bpos -> EndBlocks.AMARANITA_STEM.defaultBlockState());
        Vector3f capPos = (Vector3f)spline.get(spline.size() - 1);
        this.makeHead(world, pos.offset((int)(capPos.x() + 0.5f), (int)(capPos.y() + 1.5f), (int)(capPos.z() + 0.5f)), Mth.floor((float)(size / 1.6f)));
        function.setReplaceFunction(this.replaceFunc());
        function.addPostProcess(this.postProcessFunc());
        function.fillRecursiveIgnore((ServerLevelAccessor)world, pos, this.ignoreFunc());
        for (int i = 0; i < 3; ++i) {
            List copy = SplineHelper.copySpline((List)spline);
            SplineHelper.offsetParts((List)copy, (RandomSource)random, (float)0.2f, (float)0.0f, (float)0.2f);
            SplineHelper.fillSplineForce((List)copy, (WorldGenLevel)world, (BlockState)EndBlocks.AMARANITA_HYPHAE.defaultBlockState(), (BlockPos)pos, this.replaceFunc());
        }
        return true;
    }

    private void makeHead(WorldGenLevel world, BlockPos pos, int radius) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        if (radius < 2) {
            for (int i = -1; i < 2; ++i) {
                mut.set((Vec3i)pos).move(Direction.NORTH, 2).move(Direction.EAST, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.SOUTH, 2).move(Direction.EAST, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.EAST, 2).move(Direction.NORTH, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.WEST, 2).move(Direction.NORTH, i);
                if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
            }
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    mut.set((Vec3i)pos).move(x, 0, z);
                    if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_LANTERN);
                    mut.move(Direction.DOWN);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_LANTERN);
                    mut.move(Direction.DOWN);
                    if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)((BlockState)EndBlocks.AMARANITA_FUR.defaultBlockState().setValue((Property)BaseAttachedBlock.FACING, (Comparable)Direction.DOWN)));
                }
            }
            int h = radius + 1;
            for (int y = 0; y < h; ++y) {
                mut.setY(pos.getY() + y + 1);
                for (int x = -1; x < 2; ++x) {
                    mut.setX(pos.getX() + x);
                    for (int z = -1; z < 2; ++z) {
                        mut.setZ(pos.getZ() + z);
                        if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                    }
                }
            }
            mut.setY(pos.getY() + h + 1);
            for (int x = -1; x < 2; ++x) {
                mut.setX(pos.getX() + x);
                for (int z = -1; z < 2; ++z) {
                    mut.setZ(pos.getZ() + z);
                    if (x != 0 && z != 0 || !world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                }
            }
        } else if (radius < 4) {
            pos = pos.offset(-1, 0, -1);
            for (int i = -2; i < 2; ++i) {
                mut.set((Vec3i)pos).move(Direction.NORTH, 2).move(Direction.WEST, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.SOUTH, 3).move(Direction.WEST, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.EAST, 3).move(Direction.NORTH, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.WEST, 2).move(Direction.NORTH, i);
                if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
            }
            for (int x = -1; x < 3; ++x) {
                for (int z = -1; z < 3; ++z) {
                    mut.set((Vec3i)pos).move(x, 0, z);
                    if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_LANTERN);
                    mut.move(Direction.DOWN);
                    if (x >> 1 == 0 || z >> 1 == 0) {
                        Direction.Axis axis;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_LANTERN);
                        Direction.Axis axis2 = axis = x < 0 || x > 1 ? Direction.Axis.X : Direction.Axis.Z;
                        int distance = axis == Direction.Axis.X ? (x < 0 ? -1 : 1) : (z < 0 ? -1 : 1);
                        BlockPos offseted = mut.relative(axis, distance);
                        if (world.getBlockState(offseted).canBeReplaced()) {
                            Direction dir = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)(distance < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)offseted, (BlockState)((BlockState)EndBlocks.AMARANITA_FUR.defaultBlockState().setValue((Property)BaseAttachedBlock.FACING, (Comparable)dir)));
                        }
                        mut.move(Direction.DOWN);
                    }
                    if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)((BlockState)EndBlocks.AMARANITA_FUR.defaultBlockState().setValue((Property)BaseAttachedBlock.FACING, (Comparable)Direction.DOWN)));
                }
            }
            int h = radius - 1;
            for (int y = 0; y < h; ++y) {
                mut.setY(pos.getY() + y + 1);
                for (int x = -1; x < 3; ++x) {
                    mut.setX(pos.getX() + x);
                    for (int z = -1; z < 3; ++z) {
                        mut.setZ(pos.getZ() + z);
                        if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                    }
                }
            }
            mut.setY(pos.getY() + h + 1);
            for (int x = -1; x < 3; ++x) {
                mut.setX(pos.getX() + x);
                for (int z = -1; z < 3; ++z) {
                    mut.setZ(pos.getZ() + z);
                    if (x >> 1 != 0 && z >> 1 != 0 || !world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                }
            }
        } else {
            int i;
            for (i = -2; i < 3; ++i) {
                mut.set((Vec3i)pos).move(Direction.NORTH, 3).move(Direction.EAST, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.UP);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.NORTH);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.SOUTH, 3).move(Direction.EAST, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.UP);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.SOUTH);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.EAST, 3).move(Direction.NORTH, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.UP);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.EAST);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.set((Vec3i)pos).move(Direction.WEST, 3).move(Direction.NORTH, i);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.UP);
                if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
                }
                mut.move(Direction.WEST);
                if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
            }
            for (i = 0; i < 4; ++i) {
                mut.set((Vec3i)pos).move(Direction.UP).move(BlocksHelper.HORIZONTAL[i], 3).move(BlocksHelper.HORIZONTAL[i + 1 & 3], 3);
                if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_HYMENOPHORE);
            }
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    mut.set((Vec3i)pos).move(x, 0, z);
                    if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_LANTERN);
                    mut.move(Direction.DOWN);
                    if (x / 2 == 0 || z / 2 == 0) {
                        Direction.Axis axis;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_LANTERN);
                        Direction.Axis axis3 = axis = x < 0 || x > 1 ? Direction.Axis.X : Direction.Axis.Z;
                        int distance = axis == Direction.Axis.X ? (x < 0 ? -1 : 1) : (z < 0 ? -1 : 1);
                        BlockPos offseted = mut.relative(axis, distance);
                        if (world.getBlockState(offseted).canBeReplaced()) {
                            Direction dir = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)(distance < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)offseted, (BlockState)((BlockState)EndBlocks.AMARANITA_FUR.defaultBlockState().setValue((Property)BaseAttachedBlock.FACING, (Comparable)dir)));
                        }
                        mut.move(Direction.DOWN);
                    }
                    if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)((BlockState)EndBlocks.AMARANITA_FUR.defaultBlockState().setValue((Property)BaseAttachedBlock.FACING, (Comparable)Direction.DOWN)));
                }
            }
            for (int y = 0; y < 3; ++y) {
                mut.setY(pos.getY() + y + 1);
                for (int x = -2; x < 3; ++x) {
                    mut.setX(pos.getX() + x);
                    for (int z = -2; z < 3; ++z) {
                        mut.setZ(pos.getZ() + z);
                        if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                    }
                }
            }
            int h = radius + 1;
            for (int y = 4; y < h; ++y) {
                mut.setY(pos.getY() + y);
                for (int x = -2; x < 3; ++x) {
                    mut.setX(pos.getX() + x);
                    for (int z = -2; z < 3; ++z) {
                        mut.setZ(pos.getZ() + z);
                        if (y < 6) {
                            if (x / 2 != 0 && z / 2 != 0 || !world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                            continue;
                        }
                        if (x != 0 && z != 0 || Math.abs(x) >= 2 || Math.abs(z) >= 2 || !world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.AMARANITA_CAP);
                    }
                }
            }
        }
    }

    private Function<BlockState, Boolean> replaceFunc() {
        return BlocksHelper::replaceableOrPlant;
    }

    private Function<BlockState, Boolean> ignoreFunc() {
        return EndBlocks.DRAGON_TREE::isTreeLog;
    }

    private Function<PosInfo, BlockState> postProcessFunc() {
        return info -> {
            if (!info.getStateUp().is(EndBlocks.AMARANITA_STEM) || !info.getStateDown().is(EndBlocks.AMARANITA_STEM)) {
                return EndBlocks.AMARANITA_HYPHAE.defaultBlockState();
            }
            return info.getState();
        };
    }
}

