/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.joml.Vector3f;

public class PythadendronTreeFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (world.getBlockState(pos.below()).getBlock() != EndBlocks.CHORUS_NYLIUM) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)AIR);
        float size = MHelper.randRange((int)10, (int)20, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)4);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.7f, (float)0.0f, (float)0.7f);
        Vector3f last = (Vector3f)spline.get(spline.size() - 1);
        int depth = MHelper.floor((double)((size - 10.0f) * 3.0f / 10.0f + 1.0f));
        float bsize = (10.0f - (size - 10.0f)) / 10.0f + 1.5f;
        this.branch(last.x(), last.y(), last.z(), size * bsize, MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (RandomSource)random), random, depth, world, pos);
        SDF function = SplineHelper.buildSDF((List)spline, (float)1.7f, (float)1.1f, bpos -> EndBlocks.PYTHADENDRON.getBark().defaultBlockState());
        function.setReplaceFunction(PythadendronTreeFeature.replaceFunc());
        function.addPostProcess(PythadendronTreeFeature.postProcessFunc());
        function.fillRecursive((ServerLevelAccessor)world, pos);
        return true;
    }

    private void branch(float x, float y, float z, float size, float angle, RandomSource random, int depth, WorldGenLevel world, BlockPos pos) {
        if (depth == 0) {
            return;
        }
        float dx = (float)Math.cos(angle) * size * 0.15f;
        float dz = (float)Math.sin(angle) * size * 0.15f;
        float x1 = x + dx;
        float z1 = z + dz;
        float x2 = x - dx;
        float z2 = z - dz;
        List spline = SplineHelper.makeSpline((float)x, (float)y, (float)z, (float)x1, (float)y, (float)z1, (int)5);
        SplineHelper.powerOffset((List)spline, (float)(size * MHelper.randRange((float)1.0f, (float)2.0f, (RandomSource)random)), (float)4.0f);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.3f, (float)0.0f, (float)0.3f);
        Vector3f pos1 = (Vector3f)spline.get(spline.size() - 1);
        boolean s1 = SplineHelper.fillSpline((List)spline, (WorldGenLevel)world, (BlockState)EndBlocks.PYTHADENDRON.getBark().defaultBlockState(), (BlockPos)pos, PythadendronTreeFeature.replaceFunc());
        spline = SplineHelper.makeSpline((float)x, (float)y, (float)z, (float)x2, (float)y, (float)z2, (int)5);
        SplineHelper.powerOffset((List)spline, (float)(size * MHelper.randRange((float)1.0f, (float)2.0f, (RandomSource)random)), (float)4.0f);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.3f, (float)0.0f, (float)0.3f);
        Vector3f pos2 = (Vector3f)spline.get(spline.size() - 1);
        boolean s2 = SplineHelper.fillSpline((List)spline, (WorldGenLevel)world, (BlockState)EndBlocks.PYTHADENDRON.getBark().defaultBlockState(), (BlockPos)pos, PythadendronTreeFeature.replaceFunc());
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextInt());
        if (depth < 3) {
            if (s1) {
                this.leavesBall(world, pos.offset((int)pos1.x(), (int)pos1.y(), (int)pos1.z()), random, noise);
            }
            if (s2) {
                this.leavesBall(world, pos.offset((int)pos2.x(), (int)pos2.y(), (int)pos2.z()), random, noise);
            }
        }
        float size1 = size * MHelper.randRange((float)0.75f, (float)0.95f, (RandomSource)random);
        float size2 = size * MHelper.randRange((float)0.75f, (float)0.95f, (RandomSource)random);
        float angle1 = angle + 1.5707964f + MHelper.randRange((float)-0.1f, (float)0.1f, (RandomSource)random);
        float angle2 = angle + 1.5707964f + MHelper.randRange((float)-0.1f, (float)0.1f, (RandomSource)random);
        if (s1) {
            this.branch(pos1.x(), pos1.y(), pos1.z(), size1, angle1, random, depth - 1, world, pos);
        }
        if (s2) {
            this.branch(pos2.x(), pos2.y(), pos2.z(), size2, angle2, random, depth - 1, world, pos);
        }
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, RandomSource random, OpenSimplexNoise noise) {
        float radius = MHelper.randRange((float)4.5f, (float)6.5f, (RandomSource)random);
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.PYTHADENDRON_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(6)));
        sphere = new SDFScale3D().setScale(1.0f, 0.6f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource((SDF)sphere));
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        sphere.addPostProcess(info -> {
            if (random.nextInt(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.isAir()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.PYTHADENDRON.getBark().defaultBlockState());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.setX(x + info.getPos().getX());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.setZ(z + info.getPos().getZ());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.setY(y + info.getPos().getY());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.getBlock() instanceof LeavesBlock) || d >= (distance = ((Integer)state.getValue((Property)LeavesBlock.DISTANCE)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, PythadendronTreeFeature.ignoreFunc());
    }

    private static Function<BlockState, Boolean> replaceFunc() {
        return state -> {
            if (state.getBlock() == EndBlocks.PYTHADENDRON_LEAVES) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((BlockState)state);
        };
    }

    private static Function<BlockState, Boolean> ignoreFunc() {
        return EndBlocks.PYTHADENDRON::isTreeLog;
    }

    private static Function<PosInfo, BlockState> postProcessFunc() {
        return info -> {
            if (EndBlocks.PYTHADENDRON.isTreeLog(info.getStateUp()) && EndBlocks.PYTHADENDRON.isTreeLog(info.getStateDown())) {
                return EndBlocks.PYTHADENDRON.getLog().defaultBlockState();
            }
            return info.getState();
        };
    }
}

