/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.generator;

import com.google.gson.JsonObject;
import net.minecraft.util.Mth;

public class LayerOptions {
    public final float distance;
    public final float scale;
    private final float rawCoverage;
    public final float coverage;
    public final float averageHeight;
    public final float heightVariation;
    public final float minY;
    public final float maxY;
    public final long centerDist;
    public final boolean hasCentralIsland;

    public LayerOptions(float distance, float scale, float averageHeight, float heightVariation, boolean hasCentral) {
        this.distance = distance;
        this.scale = scale;
        this.averageHeight = averageHeight;
        this.heightVariation = heightVariation;
        this.rawCoverage = 0.5f;
        this.coverage = this.clampCoverage(0.5f);
        this.hasCentralIsland = hasCentral;
        this.minY = this.averageHeight - this.heightVariation;
        this.maxY = this.averageHeight + this.heightVariation;
        this.centerDist = Mth.floor((float)(1000.0f / this.distance));
    }

    public LayerOptions(JsonObject config) {
        this.distance = this.clampDistance(config.get("distance").getAsFloat());
        this.scale = this.clampScale(config.get("scale").getAsFloat());
        this.averageHeight = this.clampAverageHeight(config.get("average_height").getAsFloat());
        this.heightVariation = this.clampVariation(config.get("height_variation").getAsFloat());
        this.rawCoverage = config.get("coverage").getAsFloat();
        this.coverage = this.clampCoverage(this.rawCoverage);
        this.hasCentralIsland = config.get("contains_central_island").getAsBoolean();
        this.minY = this.averageHeight - this.heightVariation;
        this.maxY = this.averageHeight + this.heightVariation;
        this.centerDist = Mth.floor((float)(1000.0f / this.distance));
    }

    private float clampDistance(float value) {
        return Mth.clamp((float)value, (float)1.0f, (float)8192.0f);
    }

    private float clampScale(float value) {
        return Mth.clamp((float)value, (float)0.1f, (float)1024.0f);
    }

    private float clampCoverage(float value) {
        return 0.9999f - Mth.clamp((float)value, (float)0.0f, (float)1.0f) * 2.0f;
    }

    private float clampAverageHeight(float value) {
        return Mth.clamp((float)value, (float)0.0f, (float)1.0f);
    }

    private float clampVariation(float value) {
        return Mth.clamp((float)value, (float)0.0f, (float)1.0f);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("distance", (Number)Float.valueOf(this.clampDistance(this.distance)));
        obj.addProperty("scale", (Number)Float.valueOf(this.clampScale(this.scale)));
        obj.addProperty("average_height", (Number)Float.valueOf(this.clampAverageHeight(this.averageHeight)));
        obj.addProperty("height_variation", (Number)Float.valueOf(this.clampVariation(this.heightVariation)));
        obj.addProperty("coverage", (Number)Float.valueOf(this.rawCoverage));
        obj.addProperty("contains_central_island", Boolean.valueOf(this.hasCentralIsland));
        return obj;
    }
}

