/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.FluidState;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.structures.piece.BasePiece;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class LakePiece
extends BasePiece {
    private static final BlockState ENDSTONE = Blocks.END_STONE.defaultBlockState();
    private static final BlockState WATER = Blocks.WATER.defaultBlockState();
    private final Map<Integer, Byte> heightmap = Maps.newHashMap();
    private OpenSimplexNoise noise;
    private BlockPos center;
    private float radius;
    private float aspect;
    private float depth;
    private int seed;
    private ResourceKey<Biome> biomeID;

    public LakePiece(BlockPos center, float radius, float depth, RandomSource random, Holder<Biome> biome) {
        super(EndStructures.LAKE_PIECE, random.nextInt(), null);
        this.center = center;
        this.radius = radius;
        this.depth = depth;
        this.seed = random.nextInt();
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = radius / depth;
        this.biomeID = biome.unwrapKey().orElse(null);
        this.makeBoundingBox();
    }

    public LakePiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.LAKE_PIECE, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
        tag.putFloat("radius", this.radius);
        tag.putFloat("depth", this.depth);
        tag.putInt("seed", this.seed);
        tag.putString("biome", this.biomeID.location().toString());
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.center = NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO);
        this.radius = tag.getFloat("radius");
        this.depth = tag.getFloat("depth");
        this.seed = tag.getInt("seed");
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = this.radius / this.depth;
        this.biomeID = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tag.getString("biome")));
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int minY = this.boundingBox.minY();
        int maxY = this.boundingBox.maxY();
        int sx = SectionPos.sectionToBlockCoord((int)chunkPos.x);
        int sz = SectionPos.sectionToBlockCoord((int)chunkPos.z);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        for (int x = 0; x < 16; ++x) {
            mut.setX(x);
            int wx = x | sx;
            double nx = (double)wx * 0.1;
            int x2 = wx - this.center.getX();
            for (int z = 0; z < 16; ++z) {
                mut.setZ(z);
                int wz = z | sz;
                double nz = (double)wz * 0.1;
                int z2 = wz - this.center.getZ();
                float clamp = this.getHeightClamp(world, 8, wx, wz);
                if ((double)clamp < 0.01) continue;
                double n = this.noise.eval(nx, nz) * 1.5 + 1.5;
                double x3 = MHelper.sqr((double)((double)x2 + this.noise.eval(nx, nz, 100.0) * 10.0));
                double z3 = MHelper.sqr((double)((double)z2 + this.noise.eval(nx, nz, -100.0) * 10.0));
                for (int y = maxY; y >= minY; --y) {
                    BlockPos worldPos;
                    BlockState state;
                    mut.setY((int)((double)y + n));
                    double y2 = MHelper.sqr((float)((float)(y - this.center.getY()) * this.aspect));
                    double r2 = this.radius * clamp;
                    double r3 = r2 + 8.0;
                    r2 *= r2;
                    r3 = r3 * r3 + 100.0;
                    double dist = x3 + y2 + z3;
                    if (dist < r2) {
                        state = chunk.getBlockState((BlockPos)mut);
                        if (!state.is(CommonBlockTags.END_STONES) && !state.isAir()) continue;
                        state = mut.getY() < this.center.getY() ? WATER : CAVE_AIR;
                        chunk.setBlockState((BlockPos)mut, state, false);
                        continue;
                    }
                    if (!(dist <= r3) || mut.getY() >= this.center.getY() || (state = chunk.getBlockState((BlockPos)mut)).isCollisionShapeFullBlock((BlockGetter)world, worldPos = mut.offset(sx, 0, sz)) || state.isRedstoneConductor((BlockGetter)world, worldPos)) continue;
                    state = chunk.getBlockState(mut.above(3));
                    BlockState stateAbove = chunk.getBlockState(mut.above());
                    state = stateAbove.isAir() && state.isAir() ? (random.nextInt(10) == 0 ? ENDSTONE : EndBiome.findTopMaterial(world, worldPos)) : (stateAbove.isAir() ? (random.nextBoolean() ? ENDSTONE : EndBiome.findTopMaterial(world, worldPos)) : (state.getFluidState().isEmpty() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.defaultBlockState()));
                    chunk.setBlockState((BlockPos)mut, state, false);
                }
            }
        }
        this.fixWater(world, chunk, mut, random, sx, sz);
    }

    private void fixWater(WorldGenLevel world, ChunkAccess chunk, BlockPos.MutableBlockPos mut, RandomSource random, int sx, int sz) {
        int minY = this.boundingBox.minY();
        int maxY = this.boundingBox.maxY();
        for (int x = 0; x < 16; ++x) {
            mut.setX(x);
            for (int z = 0; z < 16; ++z) {
                mut.setZ(z);
                block2: for (int y = minY; y <= maxY; ++y) {
                    mut.setY(y);
                    FluidState state = chunk.getFluidState((BlockPos)mut);
                    if (!state.isEmpty()) {
                        mut.setY(y - 1);
                        if (chunk.getBlockState((BlockPos)mut).isAir()) {
                            mut.setY(y + 1);
                            BlockState bState = chunk.getBlockState((BlockPos)mut);
                            bState = bState.isAir() ? (random.nextBoolean() ? ENDSTONE : EndBiome.findTopMaterial(world, mut.offset(sx, 0, sz))) : (bState.getFluidState().isEmpty() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.defaultBlockState());
                            mut.setY(y);
                            this.makeEndstonePillar(chunk, mut, bState);
                            continue;
                        }
                        if (x > 1 && x < 15 && z > 1 && z < 15) {
                            mut.setY(y);
                            for (Direction dir : BlocksHelper.HORIZONTAL) {
                                BlockPos wPos = mut.offset(dir.getStepX(), 0, dir.getStepZ());
                                if (!chunk.getBlockState(wPos).isAir()) continue;
                                mut.setY(y + 1);
                                BlockState bState = chunk.getBlockState((BlockPos)mut);
                                bState = bState.isAir() ? (random.nextBoolean() ? ENDSTONE : EndBiome.findTopMaterial(world, mut.offset(sx, 0, sz))) : (bState.getFluidState().isEmpty() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.defaultBlockState());
                                mut.setY(y);
                                this.makeEndstonePillar(chunk, mut, bState);
                                continue block2;
                            }
                            continue;
                        }
                        if (!chunk.getBlockState((BlockPos)mut.move(Direction.UP)).isAir()) continue;
                        chunk.markPosForPostprocessing(mut.move(Direction.DOWN).immutable());
                        continue;
                    }
                    if (!chunk.getBlockState((BlockPos)mut).isRandomlyTicking()) continue;
                    chunk.markPosForPostprocessing(mut.immutable());
                }
            }
        }
    }

    private void makeEndstonePillar(ChunkAccess chunk, BlockPos.MutableBlockPos mut, BlockState terrain) {
        chunk.setBlockState((BlockPos)mut, terrain, false);
        mut.setY(mut.getY() - 1);
        while (!chunk.getFluidState((BlockPos)mut).isEmpty()) {
            chunk.setBlockState((BlockPos)mut, ENDSTONE, false);
            mut.setY(mut.getY() - 1);
        }
    }

    private int getHeight(WorldGenLevel world, BlockPos pos) {
        int p = (pos.getX() & 0x7FF) << 11 | pos.getZ() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, (byte)-128).byteValue();
        if (h > -128) {
            return h;
        }
        if (!world.getBiome(pos).is(this.biomeID)) {
            this.heightmap.put(p, (byte)0);
            return 0;
        }
        h = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
        h = (h = Mth.abs((int)(h - this.center.getY()))) < 8 ? 1 : 0;
        this.heightmap.put(p, (byte)h);
        return h;
    }

    private float getHeightClamp(WorldGenLevel world, int radius, int posX, int posZ) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int r2 = radius * radius;
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.setX(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.setZ(posZ + z);
                int z2 = z * z;
                if (x2 + z2 >= r2) continue;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return Mth.clamp((float)(height /= max), (float)0.0f, (float)1.0f);
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.getX() - this.radius - 8.0f));
        int minY = MHelper.floor((double)((float)this.center.getY() - this.depth - 8.0f));
        int minZ = MHelper.floor((double)((float)this.center.getZ() - this.radius - 8.0f));
        int maxX = MHelper.floor((double)((float)this.center.getX() + this.radius + 8.0f));
        int maxY = MHelper.floor((double)((float)this.center.getY() + this.depth));
        int maxZ = MHelper.floor((double)((float)this.center.getZ() + this.radius + 8.0f));
        this.boundingBox = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

