/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.TrailColor;
import com.example.TrailMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public final class TrailConfig {
    private static final Gson modid$gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String modid$fileName = "TrailMod.json";
    public int ttlSeconds = 10;
    public String color = "WHITE";
    public String mode = "STATIC";
    public String gradientEndColor = "WHITE";
    public boolean enabled = true;
    public int keyCode = 86;
    public int lineWidth = 2;
    public int lineOpacity = 100;
    public boolean arrowsEnabled = true;
    public int arrowSpacingBlocks = 2;
    public int arrowSize = 1;
    public boolean pauseOnSneak = true;
    public boolean eraseOnRetrace = false;
    public boolean otherPlayersEnabled = false;
    public int otherPlayersRangeBlocks = 524;
    public int otherPlayersKeyCode = 66;
    public int otherPlayersPointCap = 30000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TrailConfig load() {
        TrailConfig config = new TrailConfig();
        Path path = TrailConfig.modid$getPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return config;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            TrailConfig loaded = (TrailConfig)modid$gson.fromJson((Reader)reader, TrailConfig.class);
            if (loaded == null) return config;
            loaded.validate();
            TrailConfig trailConfig = loaded;
            return trailConfig;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config;
    }

    public void save() {
        Path path = TrailConfig.modid$getPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                modid$gson.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validate() {
        if (this.ttlSeconds < 1) {
            this.ttlSeconds = 1;
        }
        if (this.ttlSeconds > 10800) {
            this.ttlSeconds = 10800;
        }
        if (this.color == null) {
            this.color = "WHITE";
        }
        if (TrailColor.fromName(this.color) == null) {
            this.color = "WHITE";
        }
        if (this.mode == null || TrailMode.fromName(this.mode) == null) {
            this.mode = "STATIC";
        }
        if (this.gradientEndColor == null) {
            this.gradientEndColor = "WHITE";
        }
        if (TrailColor.fromName(this.gradientEndColor) == null) {
            this.gradientEndColor = "WHITE";
        }
        if (this.lineWidth < 1) {
            this.lineWidth = 1;
        }
        if (this.lineWidth > 10) {
            this.lineWidth = 10;
        }
        if (this.lineOpacity < 0) {
            this.lineOpacity = 0;
        }
        if (this.lineOpacity > 100) {
            this.lineOpacity = 100;
        }
        if (this.arrowSpacingBlocks < 1) {
            this.arrowSpacingBlocks = 1;
        }
        if (this.arrowSpacingBlocks > 40) {
            this.arrowSpacingBlocks = 40;
        }
        if (this.arrowSize < 1) {
            this.arrowSize = 1;
        }
        if (this.arrowSize > 10) {
            this.arrowSize = 10;
        }
        if (this.otherPlayersRangeBlocks < 0) {
            this.otherPlayersRangeBlocks = 0;
        }
        if (this.otherPlayersRangeBlocks > 4096) {
            this.otherPlayersRangeBlocks = 4096;
        }
        if (this.otherPlayersPointCap < 1000) {
            this.otherPlayersPointCap = 1000;
        }
        if (this.otherPlayersPointCap > 200000) {
            this.otherPlayersPointCap = 200000;
        }
    }

    public long ttlMs() {
        return (long)this.ttlSeconds * 1000L;
    }

    public TrailColor trailColor() {
        TrailColor c = TrailColor.fromName(this.color);
        return c == null ? TrailColor.WHITE : c;
    }

    public TrailColor gradientEndTrailColor() {
        TrailColor c = TrailColor.fromName(this.gradientEndColor);
        return c == null ? TrailColor.WHITE : c;
    }

    public TrailMode trailMode() {
        TrailMode m = TrailMode.fromName(this.mode);
        return m == null ? TrailMode.STATIC : m;
    }

    private static Path modid$getPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(modid$fileName);
    }
}

