/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.TrailColor;
import com.example.TrailConfig;
import com.example.TrailController;
import com.example.TrailMode;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
final class TrailController {
    private static final double modid$trailMinPointDistance = 0.15;
    private static final long modid$doublePressThresholdMs = 250L;
    private static final double modid$eraseOnRetraceRadiusSqr = 0.5625;
    private static final long modid$eraseOnRetraceMinAgeMs = 500L;
    private static final int modid$maxPruneRemovalsPerTick = 200;
    private static final int modid$maxEraseRemovalsPerTick = 400;
    private final ArrayDeque<TrailPoint> modid$trailPoints = new ArrayDeque();
    private class_243 modid$lastTrailPos;
    private double modid$cumulativeDistance;
    private boolean modid$wasTogglePressed;
    private boolean modid$paused;
    private long modid$lastHotkeyPressMs;
    private boolean modid$pendingSinglePress;
    private long modid$trailPointTtlMs = 10000L;
    private boolean modid$enabled = true;
    private TrailColor modid$color = TrailColor.WHITE;
    private TrailMode modid$mode = TrailMode.STATIC;
    private TrailColor modid$gradientEndColor = TrailColor.WHITE;
    private int modid$lineWidth = 2;
    private int modid$lineOpacity = 100;
    private boolean modid$arrowsEnabled = true;
    private int modid$arrowSpacingBlocks = 3;
    private int modid$arrowSize = 4;
    private boolean modid$pauseOnSneak = true;
    private boolean modid$eraseOnRetrace = false;
    private int modid$pendingCutTargetSize = -1;
    private boolean modid$pendingCutInsertBreak;
    private boolean modid$otherPlayersEnabled;
    private int modid$otherPlayersRangeBlocks;
    private int modid$otherPlayersKeyCode;
    private int modid$otherPlayersPointCap;
    private boolean modid$wasOtherPlayersTogglePressed;
    private long modid$lastOtherPlayersHotkeyPressMs;
    private boolean modid$pendingOtherPlayersSinglePress;
    private long modid$lastOtherPlayersWarnMs;
    private final Map<UUID, modid.OtherPlayerTrail> modid$otherPlayerTrails = new HashMap<UUID, modid.OtherPlayerTrail>();

    TrailController() {
    }

    void applyConfig(TrailConfig config) {
        config.validate();
        this.modid$trailPointTtlMs = config.ttlMs();
        this.modid$color = config.trailColor();
        this.modid$mode = config.trailMode();
        this.modid$gradientEndColor = config.gradientEndTrailColor();
        this.modid$enabled = config.enabled;
        this.modid$lineWidth = config.lineWidth;
        this.modid$lineOpacity = config.lineOpacity;
        this.modid$arrowsEnabled = config.arrowsEnabled;
        this.modid$arrowSpacingBlocks = config.arrowSpacingBlocks;
        this.modid$arrowSize = config.arrowSize;
        this.modid$pauseOnSneak = config.pauseOnSneak;
        this.modid$eraseOnRetrace = config.eraseOnRetrace;
        this.modid$otherPlayersEnabled = config.otherPlayersEnabled;
        this.modid$otherPlayersRangeBlocks = config.otherPlayersRangeBlocks;
        this.modid$otherPlayersKeyCode = config.otherPlayersKeyCode;
        this.modid$otherPlayersPointCap = config.otherPlayersPointCap;
    }

    void tick(class_310 client, TrailConfig config) {
        if (client.field_1724 == null) {
            this.modid$wasTogglePressed = false;
            this.modid$lastHotkeyPressMs = 0L;
            this.modid$pendingSinglePress = false;
            this.modid$trailPoints.clear();
            this.modid$lastTrailPos = null;
            this.modid$pendingCutTargetSize = -1;
            this.modid$pendingCutInsertBreak = false;
            this.modid$wasOtherPlayersTogglePressed = false;
            this.modid$lastOtherPlayersHotkeyPressMs = 0L;
            this.modid$pendingOtherPlayersSinglePress = false;
            this.modid$otherPlayerTrails.clear();
            return;
        }
        class_1041 window = client.method_22683();
        long nowMs = System.currentTimeMillis();
        boolean togglePressed = class_3675.method_15987((class_1041)window, (int)config.keyCode);
        if (togglePressed && !this.modid$wasTogglePressed) {
            if (this.modid$lastHotkeyPressMs > 0L && nowMs - this.modid$lastHotkeyPressMs <= 250L) {
                this.modid$pendingSinglePress = false;
                this.clearTrail();
                this.modid$paused = false;
                this.modid$lastHotkeyPressMs = 0L;
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Trail cleared"));
            } else {
                this.modid$lastHotkeyPressMs = nowMs;
                this.modid$pendingSinglePress = true;
            }
        }
        if (this.modid$pendingSinglePress && this.modid$lastHotkeyPressMs > 0L && nowMs - this.modid$lastHotkeyPressMs > 250L) {
            this.modid$pendingSinglePress = false;
            this.modid$paused = !this.modid$paused;
            this.modid$lastHotkeyPressMs = 0L;
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)(this.modid$paused ? "Trail paused" : "Trail resumed")));
        }
        this.modid$wasTogglePressed = togglePressed;
        boolean otherPressed = class_3675.method_15987((class_1041)window, (int)this.modid$otherPlayersKeyCode);
        if (otherPressed && !this.modid$wasOtherPlayersTogglePressed) {
            if (this.modid$lastOtherPlayersHotkeyPressMs > 0L && nowMs - this.modid$lastOtherPlayersHotkeyPressMs <= 250L) {
                this.modid$pendingOtherPlayersSinglePress = false;
                this.modid$otherPlayerTrails.clear();
                this.modid$lastOtherPlayersHotkeyPressMs = 0L;
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Other-player trails cleared"));
            } else {
                this.modid$lastOtherPlayersHotkeyPressMs = nowMs;
                this.modid$pendingOtherPlayersSinglePress = true;
            }
        }
        if (this.modid$pendingOtherPlayersSinglePress && this.modid$lastOtherPlayersHotkeyPressMs > 0L && nowMs - this.modid$lastOtherPlayersHotkeyPressMs > 250L) {
            this.modid$pendingOtherPlayersSinglePress = false;
            this.modid$otherPlayersEnabled = !this.modid$otherPlayersEnabled;
            this.modid$lastOtherPlayersHotkeyPressMs = 0L;
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)(this.modid$otherPlayersEnabled ? "Other-player trails enabled" : "Other-player trails disabled")));
        }
        this.modid$wasOtherPlayersTogglePressed = otherPressed;
        if (!this.modid$enabled) {
            return;
        }
        this.pruneTrail(nowMs);
        if (this.modid$paused) {
            return;
        }
        class_243 current = client.field_1724.method_73189();
        if (this.modid$pendingCutTargetSize >= 0) {
            for (int removed = 0; this.modid$trailPoints.size() > this.modid$pendingCutTargetSize && removed < 400; ++removed) {
                this.modid$trailPoints.removeLast();
            }
            if (this.modid$trailPoints.size() <= this.modid$pendingCutTargetSize) {
                this.modid$pendingCutTargetSize = -1;
                if (this.modid$pendingCutInsertBreak) {
                    TrailPoint last = this.modid$trailPoints.peekLast();
                    if (last == null || !last.breakPoint) {
                        this.modid$trailPoints.addLast(new TrailPoint(current, nowMs, 0.0, true));
                    }
                    this.modid$pendingCutInsertBreak = false;
                }
                this.modid$lastTrailPos = null;
                this.modid$cumulativeDistance = 0.0;
            }
        }
        if (this.modid$eraseOnRetrace && !this.modid$trailPoints.isEmpty()) {
            int idx = 0;
            int bestIndex = -1;
            double bestDistSqr = Double.MAX_VALUE;
            for (TrailPoint p : this.modid$trailPoints) {
                if (p.breakPoint) {
                    ++idx;
                    continue;
                }
                if (nowMs - p.timeMs < 500L) {
                    ++idx;
                    continue;
                }
                double d = p.pos.method_1025(current);
                if (d <= 0.5625 && d < bestDistSqr) {
                    bestDistSqr = d;
                    bestIndex = idx;
                }
                ++idx;
            }
            if (bestIndex >= 0) {
                int targetSize = bestIndex + 1;
                if (this.modid$trailPoints.size() > targetSize) {
                    this.modid$pendingCutTargetSize = targetSize;
                    this.modid$pendingCutInsertBreak = true;
                }
            }
        }
        if (this.modid$pauseOnSneak && client.field_1724.method_5715()) {
            return;
        }
        if (this.modid$lastTrailPos == null || current.method_1022(this.modid$lastTrailPos) >= 0.15) {
            if (this.modid$lastTrailPos != null) {
                this.modid$cumulativeDistance += current.method_1022(this.modid$lastTrailPos);
            }
            this.modid$trailPoints.addLast(new TrailPoint(current.method_1031(0.0, 0.05, 0.0), nowMs, this.modid$cumulativeDistance));
            this.modid$lastTrailPos = current;
        }
        this.modid$tickOtherPlayers(client, nowMs);
    }

    private void modid$tickOtherPlayers(class_310 client, long nowMs) {
        if (!this.modid$otherPlayersEnabled) {
            return;
        }
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        int range = this.modid$otherPlayersRangeBlocks;
        double rangeSqr = (double)range * (double)range;
        class_243 self = client.field_1724.method_73189();
        int totalPoints = 0;
        for (modid.OtherPlayerTrail t : this.modid$otherPlayerTrails.values()) {
            totalPoints += t.points.size();
        }
        int warnThreshold = (int)((double)this.modid$otherPlayersPointCap * 0.66);
        if (totalPoints > warnThreshold && nowMs - this.modid$lastOtherPlayersWarnMs > 10000L) {
            this.modid$lastOtherPlayersWarnMs = nowMs;
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Other-player trails are getting large and may cause lag. Consider clearing them (double press hotkey) or lowering TTL/range."));
        }
        if (totalPoints > this.modid$otherPlayersPointCap) {
            this.modid$otherPlayerTrails.clear();
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Other-player trails cleared to prevent lag (point cap reached)"));
            return;
        }
        HashMap<UUID, Boolean> seen = new HashMap<UUID, Boolean>();
        for (class_1657 p : client.field_1687.method_18456()) {
            if (p == client.field_1724) continue;
            class_243 pos = p.method_73189();
            if (range > 0 && pos.method_1025(self) > rangeSqr) continue;
            UUID uuid = p.method_5667();
            seen.put(uuid, Boolean.TRUE);
            modid.OtherPlayerTrail trail = this.modid$otherPlayerTrails.computeIfAbsent(uuid, modid.OtherPlayerTrail::new);
            int[] rgb = TrailController.modid$getPlayerColorRgb(p);
            trail.r = rgb[0];
            trail.g = rgb[1];
            trail.b = rgb[2];
            this.modid$pruneOtherTrail(trail, nowMs);
            if (trail.lastPos != null && !(pos.method_1022(trail.lastPos) >= 0.15)) continue;
            if (trail.lastPos != null) {
                trail.cumulativeDistance += pos.method_1022(trail.lastPos);
            }
            trail.points.addLast(new TrailPoint(pos.method_1031(0.0, 0.05, 0.0), nowMs, trail.cumulativeDistance));
            trail.lastPos = pos;
        }
        this.modid$otherPlayerTrails.entrySet().removeIf(e -> !seen.containsKey(e.getKey()));
    }

    private void modid$pruneOtherTrail(modid.OtherPlayerTrail trail, long nowMs) {
        TrailPoint first;
        for (int removed = 0; !trail.points.isEmpty() && removed < 200 && (first = trail.points.peekFirst()) != null && nowMs - first.timeMs > this.modid$trailPointTtlMs; ++removed) {
            trail.points.removeFirst();
        }
        if (trail.points.isEmpty()) {
            trail.lastPos = null;
            trail.cumulativeDistance = 0.0;
        }
    }

    private static int[] modid$getPlayerColorRgb(class_1657 p) {
        if (p.method_5781() != null && p.method_5781().method_1202() != null) {
            class_124 fmt = p.method_5781().method_1202();
            switch (fmt) {
                case field_1074: {
                    return new int[]{0, 0, 0};
                }
                case field_1058: {
                    return new int[]{0, 0, 170};
                }
                case field_1077: {
                    return new int[]{0, 170, 0};
                }
                case field_1062: {
                    return new int[]{0, 170, 170};
                }
                case field_1079: {
                    return new int[]{170, 0, 0};
                }
                case field_1064: {
                    return new int[]{170, 0, 170};
                }
                case field_1065: {
                    return new int[]{255, 170, 0};
                }
                case field_1080: {
                    return new int[]{170, 170, 170};
                }
                case field_1063: {
                    return new int[]{85, 85, 85};
                }
                case field_1078: {
                    return new int[]{85, 85, 255};
                }
                case field_1060: {
                    return new int[]{85, 255, 85};
                }
                case field_1075: {
                    return new int[]{85, 255, 255};
                }
                case field_1061: {
                    return new int[]{255, 85, 85};
                }
                case field_1076: {
                    return new int[]{255, 85, 255};
                }
                case field_1054: {
                    return new int[]{255, 255, 85};
                }
            }
            return new int[]{255, 255, 255};
        }
        return new int[]{255, 255, 255};
    }

    private void pruneTrail(long nowMs) {
        TrailPoint first;
        for (int removed = 0; !this.modid$trailPoints.isEmpty() && removed < 200 && (first = this.modid$trailPoints.peekFirst()) != null && nowMs - first.timeMs > this.modid$trailPointTtlMs; ++removed) {
            this.modid$trailPoints.removeFirst();
        }
        if (this.modid$trailPoints.isEmpty()) {
            this.modid$lastTrailPos = null;
            this.modid$cumulativeDistance = 0.0;
        }
    }

    boolean isEnabled() {
        return this.modid$enabled;
    }

    int getLineWidth() {
        return this.modid$lineWidth;
    }

    int getLineOpacity() {
        return this.modid$lineOpacity;
    }

    TrailColor getColor() {
        return this.modid$color;
    }

    TrailMode getMode() {
        return this.modid$mode;
    }

    TrailColor getGradientEndColor() {
        return this.modid$gradientEndColor;
    }

    boolean arrowsEnabled() {
        return this.modid$arrowsEnabled;
    }

    int getArrowSpacingBlocks() {
        return this.modid$arrowSpacingBlocks;
    }

    int getArrowSize() {
        return this.modid$arrowSize;
    }

    int getTrailPointCount() {
        return this.modid$trailPoints.size();
    }

    Iterable<TrailPoint> getTrailPoints() {
        return this.modid$trailPoints;
    }

    void clearTrail() {
        this.modid$trailPoints.clear();
        this.modid$lastTrailPos = null;
        this.modid$cumulativeDistance = 0.0;
    }

    boolean otherPlayersEnabled() {
        return this.modid$otherPlayersEnabled;
    }

    Iterable<modid.OtherPlayerTrail> getOtherPlayerTrails() {
        return this.modid$otherPlayerTrails.values();
    }

    static float normalizeOrDefault(float dx, float dy, float dz, int axis) {
        float len = class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
        if (len <= 0.0f) {
            return axis == 1 ? 1.0f : 0.0f;
        }
        return axis == 0 ? dx / len : (axis == 1 ? dy / len : dz / len);
    }

    @Environment(value=EnvType.CLIENT)
    static final class TrailPoint {
        final class_243 pos;
        final long timeMs;
        final double dist;
        final boolean breakPoint;

        TrailPoint(class_243 pos, long timeMs, double dist) {
            this.pos = pos;
            this.timeMs = timeMs;
            this.dist = dist;
            this.breakPoint = false;
        }

        TrailPoint(class_243 pos, long timeMs, double dist, boolean breakPoint) {
            this.pos = pos;
            this.timeMs = timeMs;
            this.dist = dist;
            this.breakPoint = breakPoint;
        }
    }
}

