/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.TrailColor;
import com.example.TrailController;
import com.example.TrailMode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
final class TrailRenderer {
    TrailRenderer() {
    }

    private static int modid$lerpInt(int a, int b, float t) {
        return (int)class_3532.method_15363((float)((float)a + (float)(b - a) * t), (float)0.0f, (float)255.0f);
    }

    private static int modid$opacityToAlpha(int opacityPercent) {
        int clamped = class_3532.method_15340((int)opacityPercent, (int)0, (int)100);
        return (int)((float)clamped / 100.0f * 255.0f);
    }

    private static void modid$drawOtherTrail(WorldRenderContext context, TrailController.modid.OtherPlayerTrail trail, class_4588 vertexConsumer, float lineWidth, int alpha) {
        if (context.worldState() == null || context.worldState().field_63082 == null || context.worldState().field_63082.field_63078 == null) {
            return;
        }
        class_243 camPos = context.worldState().field_63082.field_63078;
        class_4587 poseStack = context.matrices();
        if (poseStack == null) {
            return;
        }
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f matrix = pose.method_23761();
        class_4587.class_4665 normal = pose;
        TrailController.TrailPoint prev = null;
        for (TrailController.TrailPoint p : trail.points) {
            if (p.breakPoint) {
                prev = null;
                continue;
            }
            if (prev != null) {
                float x2 = (float)(p.pos.field_1352 - camPos.field_1352);
                float x1 = (float)(prev.pos.field_1352 - camPos.field_1352);
                float dx = x2 - x1;
                float y2 = (float)(p.pos.field_1351 - camPos.field_1351);
                float y1 = (float)(prev.pos.field_1351 - camPos.field_1351);
                float dy = y2 - y1;
                float z2 = (float)(p.pos.field_1350 - camPos.field_1350);
                float z1 = (float)(prev.pos.field_1350 - camPos.field_1350);
                float dz = z2 - z1;
                float len = class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
                float nx = len > 0.0f ? dx / len : 0.0f;
                float ny = len > 0.0f ? dy / len : 1.0f;
                float nz = len > 0.0f ? dz / len : 0.0f;
                vertexConsumer.method_22918((Matrix4fc)matrix, x1, y1, z1).method_1336(trail.r, trail.g, trail.b, alpha).method_60831(normal, nx, ny, nz).method_75298(lineWidth);
                vertexConsumer.method_22918((Matrix4fc)matrix, x2, y2, z2).method_1336(trail.r, trail.g, trail.b, alpha).method_60831(normal, nx, ny, nz).method_75298(lineWidth);
            }
            prev = p;
        }
    }

    private static void modid$drawArrow(class_4588 vertexConsumer, class_4587.class_4665 pose, float tipX, float tipY, float tipZ, float dirX, float dirY, float dirZ, float lineWidth, float arrowLength, float arrowWidth, int r, int g, int b, int a) {
        float sideZ;
        float sideY;
        float baseX = tipX - dirX * arrowLength;
        float baseY = tipY - dirY * arrowLength;
        float baseZ = tipZ - dirZ * arrowLength;
        float upX = Math.abs(dirY) > 0.9f ? 1.0f : 0.0f;
        float upZ = 0.0f;
        float upY = Math.abs(dirY) > 0.9f ? 0.0f : 1.0f;
        float sideX = dirY * upZ - dirZ * upY;
        float sideLen = class_3532.method_15355((float)(sideX * sideX + (sideY = dirZ * upX - dirX * upZ) * sideY + (sideZ = dirX * upY - dirY * upX) * sideZ));
        if (sideLen <= 1.0E-4f) {
            return;
        }
        float leftX = baseX + (sideX /= sideLen) * arrowWidth;
        float leftY = baseY + (sideY /= sideLen) * arrowWidth;
        float leftZ = baseZ + (sideZ /= sideLen) * arrowWidth;
        float rightX = baseX - sideX * arrowWidth;
        float rightY = baseY - sideY * arrowWidth;
        float rightZ = baseZ - sideZ * arrowWidth;
        Matrix4f matrix = pose.method_23761();
        class_4587.class_4665 normal = pose;
        vertexConsumer.method_22918((Matrix4fc)matrix, tipX, tipY, tipZ).method_1336(r, g, b, a).method_60831(normal, dirX, dirY, dirZ).method_75298(lineWidth);
        vertexConsumer.method_22918((Matrix4fc)matrix, leftX, leftY, leftZ).method_1336(r, g, b, a).method_60831(normal, dirX, dirY, dirZ).method_75298(lineWidth);
        vertexConsumer.method_22918((Matrix4fc)matrix, tipX, tipY, tipZ).method_1336(r, g, b, a).method_60831(normal, dirX, dirY, dirZ).method_75298(lineWidth);
        vertexConsumer.method_22918((Matrix4fc)matrix, rightX, rightY, rightZ).method_1336(r, g, b, a).method_60831(normal, dirX, dirY, dirZ).method_75298(lineWidth);
    }

    private static void modid$drawTrail(WorldRenderContext context, TrailController controller, class_4588 vertexConsumer, float lineWidth) {
        if (context.worldState() == null || context.worldState().field_63082 == null || context.worldState().field_63082.field_63078 == null) {
            return;
        }
        class_243 camPos = context.worldState().field_63082.field_63078;
        class_4587 poseStack = context.matrices();
        if (poseStack == null) {
            return;
        }
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f matrix = pose.method_23761();
        class_4587.class_4665 normal = pose;
        TrailMode mode = controller.getMode();
        TrailColor startColor = controller.getColor();
        TrailColor endColor = controller.getGradientEndColor();
        int pointCount = controller.getTrailPointCount();
        int arrowSpacingBlocks = controller.getArrowSpacingBlocks();
        float arrowSpacing = arrowSpacingBlocks;
        int arrowSize = controller.getArrowSize();
        float baseArrowLength = 0.12f + (float)arrowSize * 0.04f;
        float baseArrowWidth = baseArrowLength * 0.5f;
        int alpha = TrailRenderer.modid$opacityToAlpha(controller.getLineOpacity());
        TrailController.TrailPoint prev = null;
        int idx = 0;
        for (TrailController.TrailPoint p : controller.getTrailPoints()) {
            if (p.breakPoint) {
                prev = null;
                ++idx;
                continue;
            }
            if (prev != null) {
                double dist1;
                double dist2;
                double distDelta;
                int b;
                int g;
                int r;
                float t;
                float f = t = pointCount <= 1 ? 0.0f : (float)idx / (float)(pointCount - 1);
                if (mode == TrailMode.GRADIENT) {
                    r = TrailRenderer.modid$lerpInt(startColor.r, endColor.r, t);
                    g = TrailRenderer.modid$lerpInt(startColor.g, endColor.g, t);
                    b = TrailRenderer.modid$lerpInt(startColor.b, endColor.b, t);
                } else if (mode == TrailMode.MOTION) {
                    double dy = p.pos.field_1351 - prev.pos.field_1351;
                    if (dy < -0.001) {
                        r = TrailColor.RED.r;
                        g = TrailColor.RED.g;
                        b = TrailColor.RED.b;
                    } else if (dy > 0.001) {
                        r = TrailColor.GREEN.r;
                        g = TrailColor.GREEN.g;
                        b = TrailColor.GREEN.b;
                    } else {
                        r = startColor.r;
                        g = startColor.g;
                        b = startColor.b;
                    }
                } else {
                    r = startColor.r;
                    g = startColor.g;
                    b = startColor.b;
                }
                float x1 = (float)(prev.pos.field_1352 - camPos.field_1352);
                float y1 = (float)(prev.pos.field_1351 - camPos.field_1351);
                float z1 = (float)(prev.pos.field_1350 - camPos.field_1350);
                float x2 = (float)(p.pos.field_1352 - camPos.field_1352);
                float y2 = (float)(p.pos.field_1351 - camPos.field_1351);
                float z2 = (float)(p.pos.field_1350 - camPos.field_1350);
                float dx = x2 - x1;
                float dy = y2 - y1;
                float dz = z2 - z1;
                float len = class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
                float nx = len > 0.0f ? dx / len : 0.0f;
                float ny = len > 0.0f ? dy / len : 1.0f;
                float nz = len > 0.0f ? dz / len : 0.0f;
                vertexConsumer.method_22918((Matrix4fc)matrix, x1, y1, z1).method_1336(r, g, b, alpha).method_60831(normal, nx, ny, nz).method_75298(lineWidth);
                vertexConsumer.method_22918((Matrix4fc)matrix, x2, y2, z2).method_1336(r, g, b, alpha).method_60831(normal, nx, ny, nz).method_75298(lineWidth);
                if (controller.arrowsEnabled() && len >= 0.2f && arrowSpacing > 0.0f && (distDelta = (dist2 = p.dist) - (dist1 = prev.dist)) > 1.0E-6) {
                    int startK = (int)Math.floor(dist1 / (double)arrowSpacing) + 1;
                    int endK = (int)Math.floor(dist2 / (double)arrowSpacing);
                    for (int k = startK; k <= endK; ++k) {
                        double targetDist = (double)k * (double)arrowSpacing;
                        double u = (targetDist - dist1) / distDelta;
                        if (u < 0.0 || u > 1.0) continue;
                        float tipX = x1 + (x2 - x1) * (float)u;
                        float tipY = y1 + (y2 - y1) * (float)u;
                        float tipZ = z1 + (z2 - z1) * (float)u;
                        float arrowLength = Math.min(baseArrowLength, arrowSpacing);
                        TrailRenderer.modid$drawArrow(vertexConsumer, pose, tipX, tipY, tipZ, nx, ny, nz, lineWidth, arrowLength, baseArrowWidth, r, g, b, alpha);
                    }
                }
            }
            prev = p;
            ++idx;
        }
    }

    void render(WorldRenderContext context, TrailController controller) {
        if (controller.getTrailPointCount() < 2) {
            return;
        }
        if (context.matrices() == null || context.consumers() == null) {
            return;
        }
        if (context.worldState() == null || context.worldState().field_63082 == null || context.worldState().field_63082.field_63078 == null) {
            return;
        }
        class_4587 poseStack = context.matrices();
        class_4597 consumers = context.consumers();
        class_1921 renderType = class_12249.method_76015();
        class_4588 vertexConsumer = consumers.method_73477(renderType);
        float lineWidth = controller.getLineWidth();
        TrailRenderer.modid$drawTrail(context, controller, vertexConsumer, lineWidth);
        if (controller.otherPlayersEnabled()) {
            int alpha = TrailRenderer.modid$opacityToAlpha(controller.getLineOpacity());
            for (TrailController.modid.OtherPlayerTrail trail : controller.getOtherPlayerTrails()) {
                if (trail.points.size() < 2) continue;
                class_4588 otherConsumer = consumers.method_73477(renderType);
                TrailRenderer.modid$drawOtherTrail(context, trail, otherConsumer, lineWidth, alpha);
            }
        }
    }
}

