/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.theplumteam.client.gui.CollectionSelectionScreen;
import com.theplumteam.client.gui.widget.CollectionEntry;
import com.theplumteam.figure.FigureCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;

public class CollectionListWidget
extends ObjectSelectionList<CollectionEntry> {
    private final CollectionSelectionScreen parentScreen;
    private int xPosition;

    public CollectionListWidget(CollectionSelectionScreen parentScreen, Minecraft mc, int width, int height, int y, int entryHeight) {
        super(mc, width, height, y, entryHeight);
        this.parentScreen = parentScreen;
        this.xPosition = 0;
    }

    public void setXPosition(int x) {
        this.xPosition = x;
        this.setX(x);
    }

    public void addCollectionEntry(FigureCollection collection) {
        this.addEntry((AbstractSelectionList.Entry)new CollectionEntry(this, collection));
    }

    public void clearAllEntries() {
        this.clearEntries();
    }

    public void onCollectionSelected(CollectionEntry entry) {
        this.parentScreen.onCollectionSelected(entry);
    }

    public void selectByCollectionId(String collectionId) {
        if (collectionId == null || collectionId.isEmpty()) {
            return;
        }
        for (CollectionEntry entry : this.children()) {
            if (!entry.getCollection().getId().equals(collectionId)) continue;
            this.setSelected((AbstractSelectionList.Entry)entry);
            this.ensureVisible((AbstractSelectionList.Entry)entry);
            break;
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
    }

    public int getRowWidth() {
        return this.width - 8;
    }

    public int getX() {
        return this.xPosition;
    }

    public int getRowLeft() {
        return this.xPosition + 4;
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollAmount(this.getScrollAmount() - scrollY * 15.0);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderSelection(GuiGraphics graphics, int top, int width, int height, int outerColor, int innerColor) {
    }
}

