/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.client.gui.FavoriteColorSelectionScreen;
import com.theplumteam.registry.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class ColorSelectionButton
extends Button {
    private final PopBlockColor color;
    private final FavoriteColorSelectionScreen parentScreen;
    private final ItemStack boxItem;
    private boolean isSelected = false;
    private float rotationX = 30.0f;
    private float rotationY = 45.0f;
    private float rotationZ = 0.0f;
    private float scale = 1.0f;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;

    public ColorSelectionButton(int x, int y, int size, PopBlockColor color, FavoriteColorSelectionScreen parentScreen) {
        super(x, y, size, size, (Component)Component.empty(), button -> {
            if (parentScreen != null) {
                parentScreen.setSelectedColor(color);
            }
        }, DEFAULT_NARRATION);
        this.color = color;
        this.parentScreen = parentScreen;
        this.boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.putBoolean("HideLogo", true);
        blockEntityTag.putString("Color", color.name());
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            blockEntityTag.putString("CollectionId", "world_players");
            blockEntityTag.putString("FigureId", mc.player.getUUID().toString());
            blockEntityTag.putBoolean("IsFigureExtracted", false);
            blockEntityTag.putDouble("FigureOffsetX", -0.53);
            blockEntityTag.putDouble("FigureOffsetY", 0.01);
            blockEntityTag.putDouble("FigureOffsetZ", -0.55);
            blockEntityTag.putDouble("FigureScale", 1.0);
        }
        this.boxItem.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public PopBlockColor getColor() {
        return this.color;
    }

    public void setTransforms(float rotX, float rotY, float rotZ, float scale, float offX, float offY, float offZ) {
        this.rotationX = rotX;
        this.rotationY = rotY;
        this.rotationZ = rotZ;
        this.scale = scale;
        this.offsetX = offX;
        this.offsetY = offY;
        this.offsetZ = offZ;
    }

    public void setShowFigure(boolean showFigure) {
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.putBoolean("HideLogo", true);
        blockEntityTag.putString("Color", this.color.name());
        if (showFigure) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                blockEntityTag.putString("CollectionId", "world_players");
                blockEntityTag.putString("FigureId", mc.player.getUUID().toString());
                blockEntityTag.putBoolean("IsFigureExtracted", false);
                blockEntityTag.putDouble("FigureOffsetX", -0.53);
                blockEntityTag.putDouble("FigureOffsetY", 0.01);
                blockEntityTag.putDouble("FigureOffsetZ", -0.55);
                blockEntityTag.putDouble("FigureScale", 1.0);
            }
        } else {
            blockEntityTag.putString("CollectionId", "");
            blockEntityTag.putString("FigureId", "");
        }
        this.boxItem.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int borderColor;
        int backgroundColor;
        Minecraft minecraft = Minecraft.getInstance();
        if (this.isSelected) {
            backgroundColor = -2130706433;
            borderColor = -1;
        } else if (this.isHoveredOrFocused()) {
            backgroundColor = 0x60FFFFFF;
            borderColor = -2130706433;
        } else {
            backgroundColor = 0x40FFFFFF;
            borderColor = 0x60FFFFFF;
        }
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, backgroundColor);
        if (this.isSelected) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 2, borderColor);
            graphics.fill(this.getX(), this.getY() + this.height - 2, this.getX() + this.width, this.getY() + this.height, borderColor);
            graphics.fill(this.getX(), this.getY() + 2, this.getX() + 2, this.getY() + this.height - 2, borderColor);
            graphics.fill(this.getX() + this.width - 2, this.getY() + 2, this.getX() + this.width, this.getY() + this.height - 2, borderColor);
        } else {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, borderColor);
            graphics.fill(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, borderColor);
            graphics.fill(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.height - 1, borderColor);
            graphics.fill(this.getX() + this.width - 1, this.getY() + 1, this.getX() + this.width, this.getY() + this.height - 1, borderColor);
        }
        int itemSize = (int)((float)this.width * 0.6f);
        int itemX = this.getX() + (this.width - itemSize) / 2;
        int itemY = this.getY() + (this.height - itemSize) / 2;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)itemX + (float)itemSize / 2.0f, (float)itemY + (float)itemSize / 2.0f, 100.0f);
        pose.translate(this.offsetX, this.offsetY, this.offsetZ);
        pose.mulPose(new Quaternionf().rotationXYZ((float)Math.toRadians(this.rotationX), (float)Math.toRadians(this.rotationY), (float)Math.toRadians(this.rotationZ)));
        float finalScale = (float)itemSize / 16.0f * this.scale;
        pose.scale(finalScale, finalScale, finalScale);
        pose.translate(-8.0f, -8.0f, 0.0f);
        graphics.renderItem(this.boxItem, 0, 0);
        pose.popPose();
    }
}

