/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.BlockPopsMod;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LinkButton
extends Button {
    private static final ResourceLocation WIDGETS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/widgets.png");
    private final ResourceLocation texture;
    private final int textureWidth;
    private final int textureHeight;

    public LinkButton(int x, int y, int width, int height, ResourceLocation texture, String url, Component tooltip) {
        super(x, y, width, height, (Component)Component.empty(), button -> {
            if (url != null) {
                LinkButton.openLink(url);
            }
        }, DEFAULT_NARRATION);
        this.texture = texture;
        this.textureWidth = 256;
        this.textureHeight = 256;
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int bgColor = this.isHoveredOrFocused() ? -2130706433 : 0x60FFFFFF;
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), bgColor);
        int borderColor = -2130706433;
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + 1, borderColor);
        graphics.fill(this.getX(), this.getY() + this.getHeight() - 1, this.getX() + this.getWidth(), this.getY() + this.getHeight(), borderColor);
        graphics.fill(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.getHeight() - 1, borderColor);
        graphics.fill(this.getX() + this.getWidth() - 1, this.getY() + 1, this.getX() + this.getWidth(), this.getY() + this.getHeight() - 1, borderColor);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int padding = 2;
        graphics.blit(this.texture, this.getX() + padding, this.getY() + padding, this.width - padding * 2, this.height - padding * 2, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void openLink(String url) {
        Util.getPlatform().openUri(url);
        BlockPopsMod.LOGGER.info("Opening link: {}", (Object)url);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }
}

