/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.model;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.model.GeoModel;

public class FigureModel
extends GeoModel<BoxBlockEntity> {
    private static final ResourceLocation FALLBACK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    private static final ResourceLocation POSE_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"animations/figure/figure_poses.animation.json");
    private static boolean checkedQuickSkin = false;
    private static boolean quickSkinAvailable = false;
    private static Method getSkinLocationMethod;
    private static Object skinServiceInstance;

    private static ResourceLocation resolveQuickSkinId(String skinId) {
        if (!checkedQuickSkin) {
            try {
                Class<?> serviceClass = Class.forName("com.quickskin.mod.client.services.SkinService");
                Method getInstanceMethod = serviceClass.getMethod("getInstance", new Class[0]);
                skinServiceInstance = getInstanceMethod.invoke(null, new Object[0]);
                getSkinLocationMethod = serviceClass.getMethod("getSkinLocation", UUID.class, String.class);
                quickSkinAvailable = true;
            }
            catch (Exception e) {
                quickSkinAvailable = false;
            }
            checkedQuickSkin = true;
        }
        if (quickSkinAvailable && skinServiceInstance != null && skinId != null) {
            try {
                return (ResourceLocation)getSkinLocationMethod.invoke(skinServiceInstance, null, skinId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static ResourceLocation getLiveQuickSkin(UUID uuid) {
        try {
            Class<?> serviceClass = Class.forName("com.quickskin.mod.client.services.PlayerAppearanceService");
            Method getInstanceMethod = serviceClass.getMethod("getInstance", new Class[0]);
            Object instance = getInstanceMethod.invoke(null, new Object[0]);
            Method getLocMethod = serviceClass.getMethod("getSkinLocation", UUID.class);
            return (ResourceLocation)getLocMethod.invoke(instance, uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceLocation getModelResource(BoxBlockEntity animatable) {
        FigureDefinition figure = animatable.getFigureDefinition();
        return figure != null ? figure.getModelPath() : null;
    }

    public ResourceLocation getTextureResource(BoxBlockEntity animatable) {
        int altListIndex;
        FigureDefinition figure = animatable.getFigureDefinition();
        if (figure == null) {
            return FALLBACK_TEXTURE;
        }
        int skinIndex = animatable.getAlternativeSkinIndex();
        if (skinIndex > 0 && figure.hasAlternatives() && (altListIndex = skinIndex - 1) < figure.getAlternatives().size()) {
            return figure.getAlternatives().get(altListIndex).texture();
        }
        if (figure.getType() == FigureType.PLAYER && figure.getPlayerUUID() != null) {
            PlayerInfo info;
            ResourceLocation liveQS;
            ResourceLocation loc;
            ResourceLocation loc2;
            String uniqueFigureId = animatable.getCollectionId() + ":" + animatable.getFigureId();
            String qsId = animatable.getQuickSkinId();
            if (qsId != null && !qsId.isEmpty() && (loc2 = FigureModel.resolveQuickSkinId(qsId)) != null) {
                return loc2;
            }
            String nbtSnapshot = animatable.getSkinSnapshot();
            if (nbtSnapshot != null && !nbtSnapshot.isEmpty()) {
                return this.getSkinLocationFromSnapshot(figure, nbtSnapshot);
            }
            String discoveryQuickSkin = ClientDiscoveryManager.getFigureQuickSkin(uniqueFigureId);
            if (discoveryQuickSkin != null && !discoveryQuickSkin.isEmpty() && (loc = FigureModel.resolveQuickSkinId(discoveryQuickSkin)) != null) {
                return loc;
            }
            String discoverySnapshot = ClientDiscoveryManager.getFigureSkin(uniqueFigureId);
            if (discoverySnapshot != null && !discoverySnapshot.isEmpty()) {
                return this.getSkinLocationFromSnapshot(figure, discoverySnapshot);
            }
            if (quickSkinAvailable && (liveQS = FigureModel.getLiveQuickSkin(figure.getPlayerUUID())) != null) {
                return liveQS;
            }
            if (Minecraft.getInstance().getConnection() != null && (info = Minecraft.getInstance().getConnection().getPlayerInfo(figure.getPlayerUUID())) != null) {
                return info.getSkin().texture();
            }
            return FALLBACK_TEXTURE;
        }
        return figure.getTexturePath() != null ? figure.getTexturePath() : FALLBACK_TEXTURE;
    }

    private ResourceLocation getSkinLocationFromSnapshot(FigureDefinition figure, String snapshot) {
        if (snapshot == null || snapshot.isEmpty()) {
            return FALLBACK_TEXTURE;
        }
        try {
            GameProfile profile = new GameProfile(figure.getPlayerUUID(), figure.getName());
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", snapshot));
            return Minecraft.getInstance().getSkinManager().getInsecureSkin(profile).texture();
        }
        catch (Exception e) {
            return FALLBACK_TEXTURE;
        }
    }

    public ResourceLocation getAnimationResource(BoxBlockEntity animatable) {
        return POSE_ANIMATION;
    }

    public RenderType getRenderType(BoxBlockEntity animatable, ResourceLocation texture) {
        ResourceLocation textureToUse = this.getTextureResource(animatable);
        if (textureToUse == null) {
            textureToUse = FALLBACK_TEXTURE;
        }
        return RenderType.entityCutoutNoCull((ResourceLocation)textureToUse);
    }
}

