/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.theplumteam.block.BoxBlock;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.renderer.BoxBlockRenderer;
import com.theplumteam.item.GeoBlockItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BoxBlockItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final BoxBlockRenderer renderer = new BoxBlockRenderer();
    private BoxBlockEntity renderEntity;

    public BoxBlockItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (item instanceof GeoBlockItem) {
            CustomData customData;
            GeoBlockItem geoBlockItem = (GeoBlockItem)item;
            BoxBlock boxBlock = geoBlockItem.getBoxBlock();
            if (this.renderEntity == null || !this.renderEntity.getBlockState().is((Block)boxBlock)) {
                this.renderEntity = new BoxBlockEntity(BlockPos.ZERO, boxBlock.defaultBlockState());
                this.renderEntity.setLevel((Level)Minecraft.getInstance().level);
            }
            if ((customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
                CompoundTag blockEntityTag = customData.copyTag();
                this.renderEntity.loadFromItemNbt(blockEntityTag);
            }
            poseStack.pushPose();
            if (displayContext == ItemDisplayContext.GUI) {
                poseStack.translate(0.5, 0.5, 0.5);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.translate(-0.5, -0.4375, -0.5);
            }
            if (displayContext == ItemDisplayContext.GROUND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(0.7f, 0.7f, 0.7f);
                poseStack.translate(-0.5, 0.5, -0.5);
            }
            if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(0.4f, 0.4f, 0.4f);
                poseStack.translate(-0.5, 1.0, -0.5);
            }
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            this.renderer.render(this.renderEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

