/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.theplumteam.block.FigureBlock;
import com.theplumteam.blockentity.FigureBlockEntity;
import com.theplumteam.client.renderer.FigureBlockRenderer;
import com.theplumteam.item.GeoBlockItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;

public class FigureBlockItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final FigureBlockRenderer renderer = new FigureBlockRenderer();
    private FigureBlockEntity renderEntity;

    public FigureBlockItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (item instanceof GeoBlockItem) {
            CustomData customData;
            GeoBlockItem geoBlockItem = (GeoBlockItem)item;
            Block block = geoBlockItem.getBlock();
            if (!(block instanceof FigureBlock)) {
                return;
            }
            FigureBlock figureBlock = (FigureBlock)block;
            if (this.renderEntity == null || !this.renderEntity.getBlockState().is((Block)figureBlock)) {
                this.renderEntity = new FigureBlockEntity(BlockPos.ZERO, figureBlock.defaultBlockState());
            }
            if ((customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
                CompoundTag blockEntityTag = customData.copyTag();
                this.renderEntity.loadFromItemNbt(blockEntityTag);
            }
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.5, 0.0, -0.5);
            if (displayContext == ItemDisplayContext.GUI) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(1.2f, 1.2f, 1.2f);
                poseStack.translate(-0.5, (double)0.0375f, -0.5);
            }
            if (displayContext == ItemDisplayContext.GROUND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(0.7f, 0.7f, 0.7f);
                poseStack.translate(-0.5, 0.5, -0.5);
            }
            if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(0.4f, 0.4f, 0.4f);
                poseStack.translate(-0.5, 1.0, -0.5);
            }
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            this.renderer.render(this.renderEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

