/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.theplumteam.blockentity.FigureBlockEntity;
import com.theplumteam.client.model.FigureBlockModel;
import com.theplumteam.util.SkinModelDetector;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class FigureBlockRenderer
extends GeoBlockRenderer<FigureBlockEntity> {
    public FigureBlockRenderer() {
        super((GeoModel)new FigureBlockModel());
    }

    public void preRender(PoseStack poseStack, FigureBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (BlockEntity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (animatable.hasFigure()) {
            ResourceLocation texture = this.getGeoModel().getTextureResource((GeoAnimatable)animatable);
            SkinModelDetector.SkinModel skinModel = SkinModelDetector.detectSkinModel(texture);
            boolean isSlim = skinModel == SkinModelDetector.SkinModel.SLIM;
            GeoBone rightArmSlim = model.getBone("RightArmSlim").orElse(null);
            GeoBone leftArmSlim = model.getBone("LeftArmSlim").orElse(null);
            GeoBone rightArmClassic = model.getBone("RightArmClassic").orElse(null);
            GeoBone leftArmClassic = model.getBone("LeftArmClassic").orElse(null);
            if (rightArmSlim != null) {
                rightArmSlim.setHidden(!isSlim);
            }
            if (leftArmSlim != null) {
                leftArmSlim.setHidden(!isSlim);
            }
            if (rightArmClassic != null) {
                rightArmClassic.setHidden(isSlim);
            }
            if (leftArmClassic != null) {
                leftArmClassic.setHidden(isSlim);
            }
        }
    }

    public void actuallyRender(PoseStack poseStack, FigureBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (!animatable.hasFigure()) {
            return;
        }
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }
}

