/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.theplumteam.network.OpenFavoriteColorScreenPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeFavoriteColorCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeFavoriteColorCommand.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"blockpops").then(Commands.literal((String)"changefavoritecolor").executes(ChangeFavoriteColorCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.getPlayerOrException();
            OpenFavoriteColorScreenPacket.sendToPlayer(player);
            source.sendSuccess(() -> Component.literal((String)"Opening favorite color selection..."), false);
            LOGGER.info("Player {} opened the favorite color selection screen", (Object)player.getName().getString());
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing changefavoritecolor command", (Throwable)e);
            return 0;
        }
    }
}

