/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.data;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class PlayerDiscovery
implements IPlayerDiscovery {
    private final Set<String> discoveredFigures = new HashSet<String>();
    private static final String NBT_KEY = "DiscoveredFigures";
    private int regularTokens = 0;
    private long nextRegularTokenTime = 0L;
    private long lastSpecialTokenResetTimestamp = 0L;
    private boolean usedTodaySpecialToken = false;
    private boolean hasChosenFavoriteColor = false;
    private String favoriteColor = null;
    private final Map<String, String> figureSkins = new HashMap<String, String>();
    private static final String NBT_FIGURE_SKINS_KEY = "FigureSkins";
    private final Map<String, String> figureQuickSkins = new HashMap<String, String>();
    private static final String NBT_FIGURE_QUICK_SKINS_KEY = "FigureQuickSkins";

    @Override
    public boolean isDiscovered(String figureId) {
        return this.discoveredFigures.contains(figureId);
    }

    @Override
    public void discover(String figureId) {
        this.discoveredFigures.add(figureId);
    }

    @Override
    public Set<String> getDiscoveredSet() {
        return Collections.unmodifiableSet(this.discoveredFigures);
    }

    @Override
    public void syncFrom(Set<String> discovered) {
        this.discoveredFigures.clear();
        this.discoveredFigures.addAll(discovered);
    }

    @Override
    public int getRegularTokens() {
        return this.regularTokens;
    }

    @Override
    public void setRegularTokens(int count) {
        this.regularTokens = count;
    }

    @Override
    public long getNextRegularTokenTime() {
        return this.nextRegularTokenTime;
    }

    @Override
    public void setNextRegularTokenTime(long worldTimeTicks) {
        this.nextRegularTokenTime = worldTimeTicks;
    }

    @Override
    public long getLastSpecialTokenResetTimestamp() {
        return this.lastSpecialTokenResetTimestamp;
    }

    @Override
    public void setLastSpecialTokenResetTimestamp(long timestamp) {
        this.lastSpecialTokenResetTimestamp = timestamp;
    }

    @Override
    public boolean hasUsedTodaySpecialToken() {
        return this.usedTodaySpecialToken;
    }

    @Override
    public void setUsedTodaySpecialToken(boolean used) {
        this.usedTodaySpecialToken = used;
    }

    @Override
    public boolean hasChosenFavoriteColor() {
        return this.hasChosenFavoriteColor;
    }

    @Override
    public void setHasChosenFavoriteColor(boolean hasChosen) {
        this.hasChosenFavoriteColor = hasChosen;
    }

    @Override
    @Nullable
    public PopBlockColor getFavoriteColor() {
        if (this.favoriteColor == null) {
            return null;
        }
        try {
            return PopBlockColor.valueOf(this.favoriteColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void setFavoriteColor(@Nullable PopBlockColor color) {
        this.favoriteColor = color != null ? color.name() : null;
    }

    @Override
    public void saveFigureSkin(String figureId, String skinUrl) {
        this.figureSkins.put(figureId, skinUrl);
    }

    @Override
    @Nullable
    public String getFigureSkin(String figureId) {
        return this.figureSkins.get(figureId);
    }

    @Override
    public Map<String, String> getAllFigureSkins() {
        return Collections.unmodifiableMap(this.figureSkins);
    }

    @Override
    public void saveFigureQuickSkin(String figureId, String quickSkinId) {
        this.figureQuickSkins.put(figureId, quickSkinId);
    }

    @Override
    @Nullable
    public String getFigureQuickSkin(String figureId) {
        return this.figureQuickSkins.get(figureId);
    }

    @Override
    public Map<String, String> getAllFigureQuickSkins() {
        return Collections.unmodifiableMap(this.figureQuickSkins);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (String figureId : this.discoveredFigures) {
            listTag.add((Object)StringTag.valueOf((String)figureId));
        }
        tag.put(NBT_KEY, (Tag)listTag);
        tag.putInt("RegularTokens", this.regularTokens);
        tag.putLong("NextRegularTokenTime", this.nextRegularTokenTime);
        tag.putLong("LastSpecialTokenResetTimestamp", this.lastSpecialTokenResetTimestamp);
        tag.putBoolean("UsedTodaySpecialToken", this.usedTodaySpecialToken);
        tag.putBoolean("HasChosenFavoriteColor", this.hasChosenFavoriteColor);
        if (this.favoriteColor != null) {
            tag.putString("FavoriteColor", this.favoriteColor);
        }
        if (!this.figureSkins.isEmpty()) {
            CompoundTag skinsTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.figureSkins.entrySet()) {
                skinsTag.putString(entry.getKey(), entry.getValue());
            }
            tag.put(NBT_FIGURE_SKINS_KEY, (Tag)skinsTag);
        }
        if (!this.figureQuickSkins.isEmpty()) {
            CompoundTag qsTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.figureQuickSkins.entrySet()) {
                qsTag.putString(entry.getKey(), entry.getValue());
            }
            tag.put(NBT_FIGURE_QUICK_SKINS_KEY, (Tag)qsTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.discoveredFigures.clear();
        if (tag.contains(NBT_KEY, 9)) {
            ListTag listTag = tag.getList(NBT_KEY, 8);
            for (int i = 0; i < listTag.size(); ++i) {
                this.discoveredFigures.add(listTag.getString(i));
            }
        }
        if (tag.contains("RegularTokens")) {
            this.regularTokens = tag.getInt("RegularTokens");
        }
        if (tag.contains("NextRegularTokenTime")) {
            this.nextRegularTokenTime = tag.getLong("NextRegularTokenTime");
        }
        if (tag.contains("LastSpecialTokenResetTimestamp")) {
            this.lastSpecialTokenResetTimestamp = tag.getLong("LastSpecialTokenResetTimestamp");
        }
        if (tag.contains("UsedTodaySpecialToken")) {
            this.usedTodaySpecialToken = tag.getBoolean("UsedTodaySpecialToken");
        }
        this.hasChosenFavoriteColor = tag.getBoolean("HasChosenFavoriteColor");
        this.favoriteColor = tag.contains("FavoriteColor", 8) ? tag.getString("FavoriteColor") : null;
        this.figureSkins.clear();
        if (tag.contains(NBT_FIGURE_SKINS_KEY, 10)) {
            CompoundTag skinsTag = tag.getCompound(NBT_FIGURE_SKINS_KEY);
            for (String key : skinsTag.getAllKeys()) {
                this.figureSkins.put(key, skinsTag.getString(key));
            }
        }
        this.figureQuickSkins.clear();
        if (tag.contains(NBT_FIGURE_QUICK_SKINS_KEY, 10)) {
            CompoundTag qsTag = tag.getCompound(NBT_FIGURE_QUICK_SKINS_KEY);
            for (String key : qsTag.getAllKeys()) {
                this.figureQuickSkins.put(key, qsTag.getString(key));
            }
        }
    }
}

