/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.figure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.figure.FigureType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FigureDefinition {
    private final String id;
    private final String name;
    private final ResourceLocation modelPath;
    private final ResourceLocation texturePath;
    private final ResourceLocation animationPath;
    private final FigureType type;
    private final UUID playerUUID;
    private final List<AlternativeSkin> alternatives;
    private final PopBlockColor favoriteColor;

    public FigureDefinition(String id, String name, ResourceLocation modelPath, ResourceLocation texturePath, ResourceLocation animationPath) {
        this(id, name, modelPath, texturePath, animationPath, Collections.emptyList());
    }

    public FigureDefinition(String id, String name, ResourceLocation modelPath, ResourceLocation texturePath, ResourceLocation animationPath, List<AlternativeSkin> alternatives) {
        this.id = id;
        this.name = name;
        this.modelPath = modelPath;
        this.texturePath = texturePath;
        this.animationPath = animationPath;
        this.type = FigureType.STATIC;
        this.playerUUID = null;
        this.alternatives = new ArrayList<AlternativeSkin>(alternatives);
        this.favoriteColor = null;
    }

    public FigureDefinition(String id, String name, ResourceLocation modelPath, ResourceLocation animationPath, UUID playerUUID, PopBlockColor favoriteColor) {
        this.id = id;
        this.name = name;
        this.modelPath = modelPath;
        this.texturePath = null;
        this.animationPath = animationPath;
        this.type = FigureType.PLAYER;
        this.playerUUID = playerUUID;
        this.alternatives = Collections.emptyList();
        this.favoriteColor = favoriteColor;
    }

    public static FigureDefinition fromJson(JsonObject json) {
        String type;
        String id = json.get("id").getAsString();
        String name = json.get("name").getAsString();
        ResourceLocation modelPath = ResourceLocation.tryParse((String)json.get("model").getAsString());
        ResourceLocation animationPath = ResourceLocation.tryParse((String)json.get("animation").getAsString());
        String string = type = json.has("type") ? json.get("type").getAsString() : "static";
        if ("player".equals(type)) {
            UUID playerUUID = json.has("player_uuid") ? UUID.fromString(json.get("player_uuid").getAsString()) : null;
            PopBlockColor favoriteColor = null;
            if (json.has("favorite_color")) {
                try {
                    favoriteColor = PopBlockColor.valueOf(json.get("favorite_color").getAsString().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    favoriteColor = PopBlockColor.ORIGINAL;
                }
            }
            return new FigureDefinition(id, name, modelPath, animationPath, playerUUID, favoriteColor);
        }
        ResourceLocation texturePath = ResourceLocation.tryParse((String)json.get("texture").getAsString());
        ArrayList<AlternativeSkin> alternatives = new ArrayList<AlternativeSkin>();
        if (json.has("alternatives")) {
            JsonArray alternativesArray = json.getAsJsonArray("alternatives");
            for (int i = 0; i < alternativesArray.size(); ++i) {
                JsonObject altJson = alternativesArray.get(i).getAsJsonObject();
                alternatives.add(AlternativeSkin.fromJson(altJson));
            }
        }
        return new FigureDefinition(id, name, modelPath, texturePath, animationPath, alternatives);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getModelPath() {
        return this.modelPath;
    }

    public ResourceLocation getTexturePath() {
        return this.texturePath;
    }

    public ResourceLocation getAnimationPath() {
        return this.animationPath;
    }

    public FigureType getType() {
        return this.type;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public List<AlternativeSkin> getAlternatives() {
        return Collections.unmodifiableList(this.alternatives);
    }

    public boolean hasAlternatives() {
        return !this.alternatives.isEmpty();
    }

    @Nullable
    public PopBlockColor getFavoriteColor() {
        return this.favoriteColor;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("name", this.name);
        json.addProperty("model", this.modelPath.toString());
        json.addProperty("animation", this.animationPath.toString());
        if (this.type == FigureType.PLAYER) {
            json.addProperty("type", "player");
            if (this.playerUUID != null) {
                json.addProperty("player_uuid", this.playerUUID.toString());
            }
            if (this.favoriteColor != null) {
                json.addProperty("favorite_color", this.favoriteColor.getSerializedName());
            }
        } else {
            json.addProperty("type", "static");
            if (this.texturePath != null) {
                json.addProperty("texture", this.texturePath.toString());
            }
            if (!this.alternatives.isEmpty()) {
                JsonArray alternativesArray = new JsonArray();
                for (AlternativeSkin alt : this.alternatives) {
                    JsonObject altJson = new JsonObject();
                    altJson.addProperty("name", alt.name());
                    altJson.addProperty("texture", alt.texture().toString());
                    alternativesArray.add((JsonElement)altJson);
                }
                json.add("alternatives", (JsonElement)alternativesArray);
            }
        }
        return json;
    }

    public String toString() {
        return "FigureDefinition{id='" + this.id + "', name='" + this.name + "', type=" + String.valueOf((Object)this.type) + "}";
    }

    public record AlternativeSkin(String name, ResourceLocation texture) {
        public static AlternativeSkin fromJson(JsonObject json) {
            String name = json.get("name").getAsString();
            ResourceLocation texture = ResourceLocation.tryParse((String)json.get("texture").getAsString());
            return new AlternativeSkin(name, texture);
        }
    }
}

