/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.blockentity.ClawMachineBlockEntity;
import com.theplumteam.network.ModNetworking;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClawMachineCollectionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClawMachineCollectionPacket.class);
    private final BlockPos pos;
    private final String collectionId;

    public ClawMachineCollectionPacket(BlockPos pos, String collectionId) {
        this.pos = pos;
        this.collectionId = collectionId;
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.collectionId);
        return buffer;
    }

    public static ClawMachineCollectionPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        String collectionId = buffer.readUtf();
        return new ClawMachineCollectionPacket(pos, collectionId);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ClawMachineCollectionPacket packet = ClawMachineCollectionPacket.decode(buf);
        LOGGER.info("Received ClawMachineCollectionPacket on server - Position: {}, Collection ID: {}", (Object)packet.pos, (Object)packet.collectionId);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                BlockEntity blockEntity = player.level().getBlockEntity(packet.pos);
                if (blockEntity instanceof ClawMachineBlockEntity) {
                    ClawMachineBlockEntity clawMachineBlockEntity = (ClawMachineBlockEntity)blockEntity;
                    LOGGER.info("Setting collection ID on ClawMachineBlockEntity");
                    clawMachineBlockEntity.setCollectionId(packet.collectionId);
                    player.level().sendBlockUpdated(packet.pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                    LOGGER.info("Collection ID updated successfully");
                } else {
                    LOGGER.warn("BlockEntity at {} is not a ClawMachineBlockEntity", (Object)packet.pos);
                }
            }
        });
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ModNetworking.CLAW_MACHINE_COLLECTION, (RegistryFriendlyByteBuf)this.encode());
    }
}

