/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.network.TokenType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import com.theplumteam.server.ServerTickHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropBoxPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropBoxPacket.class);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"drop_box");
    private final BlockPos pos;
    private final String collectionId;
    private final TokenType tokenType;

    public DropBoxPacket(BlockPos pos, String collectionId, TokenType tokenType) {
        this.pos = pos;
        this.collectionId = collectionId;
        this.tokenType = tokenType;
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.collectionId);
        buffer.writeEnum((Enum)this.tokenType);
        return buffer;
    }

    public static DropBoxPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        String collectionId = buffer.readUtf();
        TokenType tokenType = (TokenType)buffer.readEnum(TokenType.class);
        return new DropBoxPacket(pos, collectionId, tokenType);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        DropBoxPacket packet = DropBoxPacket.decode(buf);
        LOGGER.info("Received drop box packet on server - Position: {}, Collection ID: {}, Token Type: {}", new Object[]{packet.pos, packet.collectionId, packet.tokenType});
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                LOGGER.info("Player: {} - Processing {} token request", (Object)player.getName().getString(), (Object)packet.tokenType);
                if (player.getInventory().getFreeSlot() == -1) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cInventory is full! Cannot receive figure box."));
                    LOGGER.info("Player {} inventory is full, token not consumed", (Object)player.getName().getString());
                    return;
                }
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
                if (!DropBoxPacket.verifyAndConsumeToken(player, discovery, packet.tokenType)) {
                    LOGGER.warn("Player {} tried to use unavailable {} token", (Object)player.getName().getString(), (Object)packet.tokenType);
                    DropBoxPacket.syncTokenDataToClient(player, discovery);
                    return;
                }
                PlayerDataManager.markDirty((Player)player, discovery);
                DropBoxPacket.processBoxDrop(player, packet, discovery);
            }
        });
    }

    @Nullable
    private static GameProfile getFreshGameProfile(ServerPlayer player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            ProfileResult result = player.getServer().getSessionService().fetchProfile(figure.getPlayerUUID(), true);
            return result != null ? result.profile() : null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                Object skinIdObj = getSkinIdMethod.invoke(appearance, new Object[0]);
                if (skinIdObj != null) {
                    String skinId = (String)skinIdObj;
                    LOGGER.info("Found QuickSkin ID for {}: {}", (Object)playerId, (Object)skinId);
                    return skinId;
                }
            } else {
                LOGGER.debug("No QuickSkin appearance found for {}", (Object)playerId);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("QuickSkin server classes not found");
        }
        catch (Exception e) {
            LOGGER.warn("Error accessing QuickSkin server data: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static void processBoxDrop(ServerPlayer player, DropBoxPacket packet, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(packet.collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (!figures.isEmpty()) {
                FigureDefinition selectedFigure = DropBoxPacket.selectFigure(figures, packet.tokenType, discovery, packet.collectionId);
                ItemStack boxItem = null;
                if (packet.collectionId.equals("world_players")) {
                    PopBlockColor color = selectedFigure.getFavoriteColor();
                    if (color == null) {
                        color = PopBlockColor.ORIGINAL;
                    }
                    boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
                } else {
                    boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(packet.collectionId) ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(packet.collectionId).get()) : new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
                }
                if (boxItem != null) {
                    String oldQuickSkin;
                    String oldSnapshot;
                    String uniqueFigureId = packet.collectionId + ":" + selectedFigure.getId();
                    String skinSnapshot = null;
                    String quickSkinSnapshot = null;
                    if (selectedFigure.getType() == FigureType.PLAYER) {
                        String qsId;
                        GameProfile freshProfile = DropBoxPacket.getFreshGameProfile(player, selectedFigure);
                        if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                            skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).value();
                            discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                            LOGGER.info("Saved/updated fresh skin snapshot for {}.", (Object)uniqueFigureId);
                        }
                        if (selectedFigure.getPlayerUUID() != null && (qsId = DropBoxPacket.getQuickSkinIdFromServer(selectedFigure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                            quickSkinSnapshot = qsId;
                            discovery.saveFigureQuickSkin(uniqueFigureId, quickSkinSnapshot);
                            LOGGER.info("Captured & Saved Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
                        }
                    }
                    if (!discovery.isDiscovered(uniqueFigureId)) {
                        discovery.discover(uniqueFigureId);
                        UnlockFigurePacket.sendToPlayer(player, uniqueFigureId, selectedFigure.getName(), skinSnapshot, quickSkinSnapshot);
                        LOGGER.info("Player {} discovered new figure: {} ({})", new Object[]{player.getName().getString(), selectedFigure.getName(), uniqueFigureId});
                        player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        player.playNotifySound(SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.putString("FigureId", selectedFigure.getId());
                    blockEntityTag.putString("CollectionId", packet.collectionId);
                    if (packet.collectionId.equals("world_players")) {
                        PopBlockColor color = selectedFigure.getFavoriteColor();
                        if (color == null) {
                            color = PopBlockColor.ORIGINAL;
                        }
                        blockEntityTag.putString("Color", color.name());
                    }
                    if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
                        blockEntityTag.putString("SkinSnapshot", skinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
                        blockEntityTag.putString("SkinSnapshot", oldSnapshot);
                    }
                    if (quickSkinSnapshot != null) {
                        blockEntityTag.putString("QuickSkinId", quickSkinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldQuickSkin = discovery.getFigureQuickSkin(uniqueFigureId)) != null && !oldQuickSkin.isEmpty()) {
                        blockEntityTag.putString("QuickSkinId", oldQuickSkin);
                        LOGGER.info("Used cached QuickSkin ID from discovery for {}", (Object)uniqueFigureId);
                    }
                    blockEntityTag.putString("id", "blockpops:box_block");
                    boxItem.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
                    player.getInventory().add(boxItem);
                    PlayerDataManager.markDirty((Player)player, discovery);
                }
            }
        });
    }

    private static boolean verifyAndConsumeToken(ServerPlayer player, IPlayerDiscovery discovery, TokenType tokenType) {
        if (tokenType == TokenType.REGULAR) {
            if (discovery.getRegularTokens() > 0) {
                discovery.setRegularTokens(discovery.getRegularTokens() - 1);
                LOGGER.info("Player {} used a regular token. Remaining: {}", (Object)player.getName().getString(), (Object)discovery.getRegularTokens());
                DropBoxPacket.syncTokenDataToClient(player, discovery);
                return true;
            }
        } else if (tokenType == TokenType.GUARANTEED && !discovery.hasUsedTodaySpecialToken()) {
            discovery.setUsedTodaySpecialToken(true);
            LOGGER.info("Player {} used their guaranteed token", (Object)player.getName().getString());
            DropBoxPacket.syncTokenDataToClient(player, discovery);
            return true;
        }
        return false;
    }

    private static void syncTokenDataToClient(ServerPlayer player, IPlayerDiscovery discovery) {
        long gameTime = player.serverLevel().getGameTime();
        long nextRegularTime = discovery.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
    }

    private static FigureDefinition selectFigure(List<FigureDefinition> figures, TokenType tokenType, IPlayerDiscovery discovery, String collectionId) {
        Random random = new Random();
        if (tokenType == TokenType.GUARANTEED) {
            Set<String> discoveredSet = discovery.getDiscoveredSet();
            ArrayList<FigureDefinition> undiscoveredFigures = new ArrayList<FigureDefinition>();
            for (FigureDefinition figure : figures) {
                String figureId = collectionId + ":" + figure.getId();
                if (discoveredSet.contains(figureId)) continue;
                undiscoveredFigures.add(figure);
            }
            if (!undiscoveredFigures.isEmpty()) {
                FigureDefinition selected = (FigureDefinition)undiscoveredFigures.get(random.nextInt(undiscoveredFigures.size()));
                LOGGER.info("Guaranteed token logic: Selected undiscovered figure '{}'", (Object)selected.getId());
                return selected;
            }
            LOGGER.info("Guaranteed token logic: Collection complete, giving random duplicate");
            return figures.get(random.nextInt(figures.size()));
        }
        return figures.get(random.nextInt(figures.size()));
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ID, (RegistryFriendlyByteBuf)this.encode());
    }
}

