/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.PlayerCollectionHelper;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetFavoriteColorPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetFavoriteColorPacket.class);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"set_favorite_color");
    private final String colorName;

    public SetFavoriteColorPacket(String colorName) {
        this.colorName = colorName;
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeUtf(this.colorName);
        return buffer;
    }

    public static SetFavoriteColorPacket decode(FriendlyByteBuf buffer) {
        String colorName = buffer.readUtf();
        return new SetFavoriteColorPacket(colorName);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        SetFavoriteColorPacket packet = SetFavoriteColorPacket.decode(buf);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
                try {
                    PopBlockColor color = PopBlockColor.valueOf(packet.colorName.toUpperCase());
                    discovery.setFavoriteColor(color);
                    discovery.setHasChosenFavoriteColor(true);
                    PlayerDataManager.markDirty((Player)player, discovery);
                    LOGGER.info("Player {} chose favorite color: {}", (Object)player.getName().getString(), (Object)color.getSerializedName());
                    if (player.getServer() != null) {
                        PlayerCollectionHelper.regenerateAndSyncPlayerCollection(player.getServer());
                        LOGGER.info("Regenerated World Players collection after {} changed their favorite color", (Object)player.getName().getString());
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Player {} sent invalid color name: {}", (Object)player.getName().getString(), (Object)packet.colorName);
                }
            }
        });
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ID, (RegistryFriendlyByteBuf)this.encode());
    }
}

