/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import com.theplumteam.server.config.ServerConfig;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateGuaranteedResetHourPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateGuaranteedResetHourPacket.class);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"update_guaranteed_reset_hour");
    private final int resetHour;

    public UpdateGuaranteedResetHourPacket(int resetHour) {
        this.resetHour = resetHour;
    }

    public RegistryFriendlyByteBuf encode() {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buffer.writeInt(this.resetHour);
        return buffer;
    }

    public static UpdateGuaranteedResetHourPacket decode(FriendlyByteBuf buffer) {
        return new UpdateGuaranteedResetHourPacket(buffer.readInt());
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UpdateGuaranteedResetHourPacket packet = UpdateGuaranteedResetHourPacket.decode(buf);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (player.hasPermissions(2)) {
                    ServerConfig.getInstance().setGuaranteedTokenResetHour(packet.resetHour);
                    LOGGER.info("Player {} updated guaranteed token reset hour to {} UTC", (Object)player.getName().getString(), (Object)packet.resetHour);
                    UpdateGuaranteedResetHourPacket.syncTokenData(player);
                } else {
                    LOGGER.warn("Player {} tried to update reset hour without permission", (Object)player.getName().getString());
                }
            }
        });
    }

    private static void syncTokenData(ServerPlayer player) {
        IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
        long gameTime = player.serverLevel().getGameTime();
        long nextRegularTime = discovery.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ID, (RegistryFriendlyByteBuf)this.encode());
    }
}

