/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.CollectionListWidget;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import org.lwjgl.opengl.GL11;

public class CollectionEntry
extends class_4280.class_4281<CollectionEntry> {
    private final class_310 mc;
    private final FigureCollection collection;
    private final CollectionListWidget parent;
    private static final int PADDING = 4;
    private static final int TOP_PADDING = 12;
    private static final int LOGO_MAX_SIZE = 56;
    private static final int LINK_BUTTON_SIZE = 14;
    private int linkButtonX;
    private int linkButtonY;
    private boolean isLinkHovered;

    public CollectionEntry(CollectionListWidget parent, FigureCollection collection) {
        this.parent = parent;
        this.mc = class_310.method_1551();
        this.collection = collection;
    }

    public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        float scale = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getRenderScaleFactor() : 1.0f;
        int effectivePadding = (int)(4.0f * scale);
        int effectiveTopPadding = (int)(12.0f * scale);
        int effectiveLogoMaxSize = (int)(56.0f * scale);
        int effectiveLinkButtonSize = (int)(14.0f * scale);
        boolean isSelected = this.parent.method_25334() == this;
        int highlightPaddingH = (int)(4.0f * scale);
        int highlightPaddingV = (int)(2.0f * scale);
        int highlightLeft = x - highlightPaddingH;
        int highlightRight = x + entryWidth - 10;
        int highlightTop = y - highlightPaddingV;
        int highlightBottom = y + entryHeight + highlightPaddingV;
        if (isSelected) {
            graphics.method_25294(highlightLeft, highlightTop, highlightRight, highlightBottom, -2144301888);
            graphics.method_49601(highlightLeft, highlightTop, highlightRight - highlightLeft, highlightBottom - highlightTop, -12549889);
        } else if (isMouseOver) {
            graphics.method_25294(highlightLeft, highlightTop, highlightRight, highlightBottom, 0x30FFFFFF);
        }
        int logoContainerX = x + effectivePadding;
        int logoContainerWidth = effectiveLogoMaxSize;
        class_2960 logoTexture = this.collection.getLogoTexture();
        int textStartX = logoContainerX + logoContainerWidth + effectivePadding;
        if (logoTexture != null) {
            int logoHeight;
            int logoWidth;
            int maxSize;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)logoTexture);
            int textureId = RenderSystem.getShaderTexture((int)0);
            int[] width = new int[1];
            int[] height = new int[1];
            GL11.glBindTexture((int)3553, (int)textureId);
            GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4096, (int[])width);
            GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4097, (int[])height);
            int textureWidth = width[0] > 0 ? width[0] : 256;
            int textureHeight = height[0] > 0 ? height[0] : 256;
            float aspectRatio = (float)textureWidth / (float)textureHeight;
            int n = maxSize = "world_players".equals(this.collection.getId()) ? 40 : effectiveLogoMaxSize;
            if (aspectRatio > 1.0f) {
                logoWidth = maxSize;
                logoHeight = (int)((float)maxSize / aspectRatio);
            } else {
                logoHeight = maxSize;
                logoWidth = (int)((float)maxSize * aspectRatio);
            }
            int logoX = logoContainerX + (logoContainerWidth - logoWidth) / 2;
            int logoY = y + (entryHeight - logoHeight) / 2;
            graphics.method_25293(logoTexture, logoX, logoY, logoWidth, logoHeight, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        }
        int textX = textStartX;
        int textY = y + effectiveTopPadding;
        int textColor = isSelected ? 0xFFFFFF : 0xE0E0E0;
        graphics.method_51433(this.mc.field_1772, this.collection.getName(), textX, textY, textColor, false);
        int totalFigures = this.collection.getFigures().size();
        int discoveredCount = 0;
        for (FigureDefinition figure : this.collection.getFigures()) {
            String figureId = this.collection.getId() + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(figureId)) continue;
            ++discoveredCount;
        }
        String figureCount = discoveredCount + "/" + totalFigures + " figures";
        Objects.requireNonNull(this.mc.field_1772);
        int subTextY = textY + 9 + 2;
        int subTextColor = isSelected ? 0xAAAAAA : 0x808080;
        graphics.method_51433(this.mc.field_1772, figureCount, textX, subTextY, subTextColor, false);
        String author = this.collection.getAuthor();
        class_5250 authorText = "world_players".equals(this.collection.getId()) ? class_2561.method_43470((String)"Auto-generated skins").method_27692(class_124.field_1065) : (author.equals("Unknown") ? class_2561.method_43470((String)"Collection with multiple creators").method_27692(class_124.field_1065) : class_2561.method_43470((String)"Skin creator: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)author).method_27692(class_124.field_1065)));
        Objects.requireNonNull(this.mc.field_1772);
        int authorY = subTextY + 9 + 2;
        graphics.method_51439(this.mc.field_1772, (class_2561)authorText, textX, authorY, 0xFFFFFF, false);
        this.isLinkHovered = false;
        if (isMouseOver && this.collection.getAuthorUrl() != null && !this.collection.getAuthorUrl().isEmpty()) {
            int margin = 4;
            this.linkButtonX = highlightRight - effectiveLinkButtonSize - margin;
            this.linkButtonY = highlightTop + margin;
            boolean linkHovered = mouseX >= this.linkButtonX && mouseX < this.linkButtonX + effectiveLinkButtonSize && mouseY >= this.linkButtonY && mouseY < this.linkButtonY + effectiveLinkButtonSize;
            graphics.method_25294(this.linkButtonX, this.linkButtonY, this.linkButtonX + effectiveLinkButtonSize, this.linkButtonY + effectiveLinkButtonSize, linkHovered ? -4684277 : -1063686144);
            graphics.method_49601(this.linkButtonX, this.linkButtonY, effectiveLinkButtonSize, effectiveLinkButtonSize, linkHovered ? -2448096 : -4684277);
            String planetEmoji = "\ud83c\udf10";
            int emojiWidth = this.mc.field_1772.method_1727(planetEmoji);
            int emojiX = this.linkButtonX + (effectiveLinkButtonSize - emojiWidth) / 2;
            int emojiY = this.linkButtonY + (effectiveLinkButtonSize - 8) / 2;
            graphics.method_51433(this.mc.field_1772, planetEmoji, emojiX, emojiY, 0xFFFFFF, false);
            this.isLinkHovered = linkHovered;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isLinkHovered && this.collection.getAuthorUrl() != null && !this.collection.getAuthorUrl().isEmpty()) {
                try {
                    this.mc.field_1755.method_25430(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, this.collection.getAuthorUrl())));
                }
                catch (Exception e) {
                    System.err.println("Failed to open URL: " + this.collection.getAuthorUrl());
                }
                return true;
            }
            this.parent.method_25313((class_350.class_351)this);
            this.parent.onCollectionSelected(this);
            return true;
        }
        return false;
    }

    public class_2561 method_37006() {
        int totalFigures = this.collection.getFigures().size();
        int discoveredCount = 0;
        for (FigureDefinition figure : this.collection.getFigures()) {
            String figureId = this.collection.getId() + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(figureId)) continue;
            ++discoveredCount;
        }
        return class_2561.method_43470((String)(this.collection.getName() + " - " + discoveredCount + "/" + totalFigures + " figures"));
    }

    public FigureCollection getCollection() {
        return this.collection;
    }
}

