/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.TokenType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBoxCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetBoxCommand.class);
    private static final SuggestionProvider<class_2168> COLLECTION_SUGGESTIONS = (context, builder) -> {
        Set<String> collectionIds = CollectionRegistry.getCollectionIds();
        return class_2172.method_9264(collectionIds.stream().filter(id -> !id.equals("default")), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> TOKEN_TYPE_SUGGESTIONS = (context, builder) -> class_2172.method_9253((String[])new String[]{"regular", "guaranteed"}, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"blockpops").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getbox").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"collection_id", (ArgumentType)StringArgumentType.string()).suggests(COLLECTION_SUGGESTIONS).executes(context -> GetBoxCommand.executeCommand((CommandContext<class_2168>)context, TokenType.REGULAR))).then(class_2170.method_9244((String)"token_type", (ArgumentType)StringArgumentType.string()).suggests(TOKEN_TYPE_SUGGESTIONS).executes(context -> {
            String tokenTypeStr = StringArgumentType.getString((CommandContext)context, (String)"token_type");
            TokenType tokenType = GetBoxCommand.parseTokenType(tokenTypeStr);
            if (tokenType == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid token type. Use 'regular' or 'guaranteed'"));
                return 0;
            }
            return GetBoxCommand.executeCommand((CommandContext<class_2168>)context, tokenType);
        })))));
    }

    private static TokenType parseTokenType(String tokenTypeStr) {
        if (tokenTypeStr.equalsIgnoreCase("regular")) {
            return TokenType.REGULAR;
        }
        if (tokenTypeStr.equalsIgnoreCase("guaranteed")) {
            return TokenType.GUARANTEED;
        }
        return null;
    }

    private static int executeCommand(CommandContext<class_2168> context, TokenType tokenType) {
        String collectionId = StringArgumentType.getString(context, (String)"collection_id");
        class_2168 source = (class_2168)context.getSource();
        try {
            class_3222 player = source.method_9207();
            if (!CollectionRegistry.getCollection(collectionId).isPresent()) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Collection '" + collectionId + "' does not exist")));
                return 0;
            }
            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
            GetBoxCommand.processBoxDrop(player, collectionId, tokenType, discovery);
            PlayerDataManager.saveDiscovery((class_1657)player);
            source.method_9226(() -> class_2561.method_43470((String)("Gave box from collection '" + collectionId + "' using " + tokenType.name().toLowerCase() + " token logic")), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing getbox command", (Throwable)e);
            return 0;
        }
    }

    @Nullable
    private static GameProfile getFreshGameProfile(class_3222 player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            ProfileResult result = player.method_5682().method_3844().fetchProfile(figure.getPlayerUUID(), true);
            return result != null ? result.profile() : null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void processBoxDrop(class_3222 player, String collectionId, TokenType tokenType, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (!figures.isEmpty()) {
                FigureDefinition selectedFigure = GetBoxCommand.selectFigure(figures, tokenType, discovery, collectionId);
                class_1799 boxItem = null;
                if (collectionId.equals("world_players")) {
                    PopBlockColor color = selectedFigure.getFavoriteColor();
                    if (color == null) {
                        color = PopBlockColor.ORIGINAL;
                    }
                    boxItem = new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
                } else {
                    boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(collectionId) ? new class_1799((class_1935)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
                }
                if (boxItem != null) {
                    String oldSnapshot;
                    String uniqueFigureId = collectionId + ":" + selectedFigure.getId();
                    String skinSnapshot = null;
                    String quickSkinSnapshot = null;
                    if (selectedFigure.getType() == FigureType.PLAYER) {
                        String qsId;
                        GameProfile freshProfile = GetBoxCommand.getFreshGameProfile(player, selectedFigure);
                        if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                            skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).value();
                            discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                            LOGGER.info("Saved/updated fresh skin snapshot for {}.", (Object)uniqueFigureId);
                        }
                        if (selectedFigure.getPlayerUUID() != null && (qsId = GetBoxCommand.getQuickSkinIdFromServer(selectedFigure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                            quickSkinSnapshot = qsId;
                            discovery.saveFigureQuickSkin(uniqueFigureId, quickSkinSnapshot);
                            LOGGER.info("Captured & Saved Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
                        }
                    }
                    if (!discovery.isDiscovered(uniqueFigureId)) {
                        discovery.discover(uniqueFigureId);
                        UnlockFigurePacket.sendToPlayer(player, uniqueFigureId, selectedFigure.getName(), skinSnapshot, quickSkinSnapshot);
                    }
                    class_2487 blockEntityTag = new class_2487();
                    blockEntityTag.method_10582("FigureId", selectedFigure.getId());
                    blockEntityTag.method_10582("CollectionId", collectionId);
                    if (collectionId.equals("world_players")) {
                        PopBlockColor color = selectedFigure.getFavoriteColor();
                        if (color == null) {
                            color = PopBlockColor.ORIGINAL;
                        }
                        blockEntityTag.method_10582("Color", color.name());
                    }
                    if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
                        blockEntityTag.method_10582("SkinSnapshot", skinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
                        blockEntityTag.method_10582("SkinSnapshot", oldSnapshot);
                    }
                    if (quickSkinSnapshot != null) {
                        blockEntityTag.method_10582("QuickSkinId", quickSkinSnapshot);
                    }
                    blockEntityTag.method_10582("id", "blockpops:box_block");
                    boxItem.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)blockEntityTag));
                    class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318() + 1.0, player.method_23321(), boxItem);
                    itemEntity.method_18800(0.0, 0.2, 0.0);
                    player.method_37908().method_8649((class_1297)itemEntity);
                }
            }
        });
    }

    private static FigureDefinition selectFigure(List<FigureDefinition> figures, TokenType tokenType, IPlayerDiscovery discovery, String collectionId) {
        Random random = new Random();
        if (tokenType == TokenType.GUARANTEED) {
            Set<String> discoveredSet = discovery.getDiscoveredSet();
            ArrayList<FigureDefinition> undiscoveredFigures = new ArrayList<FigureDefinition>();
            for (FigureDefinition figure : figures) {
                String figureId = collectionId + ":" + figure.getId();
                if (discoveredSet.contains(figureId)) continue;
                undiscoveredFigures.add(figure);
            }
            if (!undiscoveredFigures.isEmpty()) {
                return (FigureDefinition)undiscoveredFigures.get(random.nextInt(undiscoveredFigures.size()));
            }
            return figures.get(random.nextInt(figures.size()));
        }
        return figures.get(random.nextInt(figures.size()));
    }
}

