/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.figure.fabric;

import com.mojang.authlib.GameProfile;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import com.theplumteam.server.config.ServerConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PlayerCollectionHelperImpl {
    private static final String COLLECTION_ID = "world_players";
    private static final String COLLECTION_NAME = "World Players";

    public static FigureCollection generate(MinecraftServer server) {
        try {
            File[] playerFiles;
            Path worldPath = server.method_27050(class_5218.field_24188);
            File playerdataDir = worldPath.resolve("playerdata").toFile();
            ArrayList<FigureDefinition> playerFigures = new ArrayList<FigureDefinition>();
            HashSet<UUID> processedPlayers = new HashSet<UUID>();
            class_3312 profileCache = server.method_3793();
            class_2960 defaultModel = class_2960.method_60655((String)"blockpops", (String)"geo/figure/box_figure_default.geo.json");
            class_2960 defaultAnimation = class_2960.method_60655((String)"blockpops", (String)"animations/figure/box_figure_default.animation.json");
            if (playerdataDir.exists() && playerdataDir.isDirectory() && (playerFiles = playerdataDir.listFiles((dir, name) -> name.endsWith(".dat"))) != null && playerFiles.length > 0) {
                for (File playerFile : playerFiles) {
                    try {
                        PopBlockColor defaultColor;
                        String filename = playerFile.getName();
                        String uuidString = filename.substring(0, filename.length() - 4);
                        UUID playerUUID = UUID.fromString(uuidString);
                        Object playerName = "Unknown Player";
                        if (profileCache != null) {
                            Optional profile = profileCache.method_14512(playerUUID);
                            playerName = profile.isPresent() ? ((GameProfile)profile.get()).getName() : "Player " + uuidString.substring(0, 8);
                        }
                        PopBlockColor favoriteColor = defaultColor = ServerConfig.getInstance().getDefaultPlayerColor();
                        class_3222 onlinePlayer = server.method_3760().method_14602(playerUUID);
                        if (onlinePlayer != null) {
                            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)onlinePlayer);
                            if (discovery.hasChosenFavoriteColor() && discovery.getFavoriteColor() != null) {
                                favoriteColor = discovery.getFavoriteColor();
                            }
                            BlockPopsMod.LOGGER.debug("Loaded favorite color from online player {}: {}", playerName, (Object)favoriteColor.method_15434());
                        } else {
                            try {
                                class_2487 discoveryTag;
                                class_2487 cardinalComponents;
                                class_2487 playerData;
                                File playerDataFile = new File(playerdataDir, uuidString + ".dat");
                                if (playerDataFile.exists() && (playerData = class_2507.method_30613((Path)playerDataFile.toPath(), (class_2505)class_2505.method_53898())) != null && (cardinalComponents = playerData.method_10562("cardinal_components")).method_10545("blockpops:player_discovery") && (discoveryTag = cardinalComponents.method_10562("blockpops:player_discovery")).method_10573("FavoriteColor", 8)) {
                                    try {
                                        favoriteColor = PopBlockColor.valueOf(discoveryTag.method_10558("FavoriteColor").toUpperCase());
                                    }
                                    catch (IllegalArgumentException e) {
                                        BlockPopsMod.LOGGER.warn("Invalid favorite color found for player {}, defaulting to ORIGINAL", (Object)playerUUID);
                                    }
                                }
                                BlockPopsMod.LOGGER.debug("Loaded favorite color from disk for offline player {}: {}", playerName, (Object)favoriteColor.method_15434());
                            }
                            catch (Exception e) {
                                BlockPopsMod.LOGGER.warn("Failed to load favorite color for player {}, defaulting to ORIGINAL: {}", (Object)playerUUID, (Object)e.getMessage());
                            }
                        }
                        FigureDefinition playerFigure = new FigureDefinition(uuidString, (String)playerName, defaultModel, defaultAnimation, playerUUID, favoriteColor);
                        playerFigures.add(playerFigure);
                        processedPlayers.add(playerUUID);
                        BlockPopsMod.LOGGER.debug("Added player figure from .dat file: {} ({})", playerName, (Object)playerUUID);
                    }
                    catch (IllegalArgumentException e) {
                        BlockPopsMod.LOGGER.warn("Failed to parse player UUID from file: {}", (Object)playerFile.getName());
                    }
                }
            }
            List onlinePlayers = server.method_3760().method_14571();
            for (class_3222 onlinePlayer : onlinePlayers) {
                PopBlockColor defaultColorOnline;
                UUID playerUUID = onlinePlayer.method_5667();
                if (processedPlayers.contains(playerUUID)) continue;
                String playerName = onlinePlayer.method_5477().getString();
                String uuidString = playerUUID.toString();
                PopBlockColor favoriteColor = defaultColorOnline = ServerConfig.getInstance().getDefaultPlayerColor();
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)onlinePlayer);
                if (discovery.hasChosenFavoriteColor() && discovery.getFavoriteColor() != null) {
                    favoriteColor = discovery.getFavoriteColor();
                }
                FigureDefinition playerFigure = new FigureDefinition(uuidString, playerName, defaultModel, defaultAnimation, playerUUID, favoriteColor);
                playerFigures.add(playerFigure);
                processedPlayers.add(playerUUID);
                BlockPopsMod.LOGGER.debug("Added online player figure (no .dat file yet): {} ({})", (Object)playerName, (Object)playerUUID);
            }
            BlockPopsMod.LOGGER.info("Generated World Players collection with {} figures", (Object)playerFigures.size());
            class_2960 boxTexture = class_2960.method_60655((String)"blockpops", (String)"textures/block/box/default.png");
            class_2960 logoTexture = class_2960.method_60655((String)"blockpops", (String)"textures/block/box/logo/logo_worldplayers.png");
            FigureCollection.LogoConfig logoConfig = new FigureCollection.LogoConfig(logoTexture, -0.915f, -0.165f, -0.001f, 4.004f, 4.503f, 1.0f);
            return new FigureCollection(COLLECTION_ID, COLLECTION_NAME, "Minecraft", null, boxTexture, logoConfig, playerFigures, new int[]{152, 48, 167});
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.error("Failed to generate World Players collection", (Throwable)e);
            return PlayerCollectionHelperImpl.createEmptyCollection();
        }
    }

    private static FigureCollection createEmptyCollection() {
        class_2960 boxTexture = class_2960.method_60655((String)"blockpops", (String)"textures/block/box/default.png");
        class_2960 logoTexture = class_2960.method_60655((String)"blockpops", (String)"textures/block/box/logo/logo_worldplayers.png");
        FigureCollection.LogoConfig logoConfig = new FigureCollection.LogoConfig(logoTexture, -0.915f, -0.165f, -0.001f, 4.004f, 4.503f, 1.0f);
        return new FigureCollection(COLLECTION_ID, COLLECTION_NAME, "Minecraft", null, boxTexture, logoConfig, new ArrayList<FigureDefinition>(), new int[]{152, 48, 167});
    }

    public static void regenerateAndSyncPlayerCollection(MinecraftServer server) {
        FigureCollection updatedCollection = PlayerCollectionHelperImpl.generate(server);
        CollectionRegistry.registerDynamicCollection(updatedCollection);
        BlockPopsMod.LOGGER.info("Regenerated World Players collection");
        ArrayList<FigureCollection> dynamicCollections = new ArrayList<FigureCollection>();
        dynamicCollections.add(updatedCollection);
        SyncDynamicCollectionsPacket.sendToAllPlayers(server, dynamicCollections);
    }
}

