/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockCollectionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockCollectionPacket.class);
    public static final class_2960 ID = class_2960.method_60655((String)"blockpops", (String)"unlock_collection");
    private final String collectionId;

    public UnlockCollectionPacket(String collectionId) {
        this.collectionId = collectionId;
    }

    public class_9129 encode() {
        class_9129 buffer = new class_9129(Unpooled.buffer(), (class_5455)class_5455.field_40585);
        buffer.method_10814(this.collectionId);
        return buffer;
    }

    public static UnlockCollectionPacket decode(class_2540 buffer) {
        String collectionId = buffer.method_19772();
        return new UnlockCollectionPacket(collectionId);
    }

    public static void handleServer(class_2540 buf, NetworkManager.PacketContext context) {
        UnlockCollectionPacket packet = UnlockCollectionPacket.decode(buf);
        context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                LOGGER.info("Player {} requested to unlock collection: {}", (Object)player.method_5477().getString(), (Object)packet.collectionId);
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
                UnlockCollectionPacket.unlockEntireCollection(player, packet.collectionId, discovery);
                PlayerDataManager.markDirty((class_1657)player, discovery);
            }
        });
    }

    private static void unlockEntireCollection(class_3222 player, String collectionId, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (figures.isEmpty()) {
                LOGGER.warn("Collection {} has no figures", (Object)collectionId);
                return;
            }
            LOGGER.info("Unlocking {} figures from collection {} for player {}", new Object[]{figures.size(), collectionId, player.method_5477().getString()});
            for (FigureDefinition figure : figures) {
                UnlockCollectionPacket.giveBoxForFigure(player, collectionId, figure, discovery);
            }
            LOGGER.info("Successfully unlocked all figures from collection {} for player {}", (Object)collectionId, (Object)player.method_5477().getString());
        });
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void giveBoxForFigure(class_3222 player, String collectionId, FigureDefinition figure, IPlayerDiscovery discovery) {
        String oldSnapshot;
        class_1799 boxItem = null;
        if (collectionId.equals("world_players")) {
            PopBlockColor color = figure.getFavoriteColor();
            if (color == null) {
                color = PopBlockColor.ORIGINAL;
            }
            boxItem = new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
        } else {
            boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(collectionId) ? new class_1799((class_1935)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
        }
        if (boxItem == null) {
            LOGGER.warn("Could not find box item for collection {}", (Object)collectionId);
            return;
        }
        String uniqueFigureId = collectionId + ":" + figure.getId();
        String skinSnapshot = null;
        String quickSkinSnapshot = null;
        if (figure.getType() == FigureType.PLAYER) {
            String qsId;
            GameProfile freshProfile = UnlockCollectionPacket.getFreshGameProfile(player, figure);
            if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).value();
                discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                LOGGER.debug("Saved skin snapshot for player figure: {}", (Object)uniqueFigureId);
            }
            if (figure.getPlayerUUID() != null && (qsId = UnlockCollectionPacket.getQuickSkinIdFromServer(figure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                quickSkinSnapshot = qsId;
                discovery.saveFigureQuickSkin(uniqueFigureId, quickSkinSnapshot);
                LOGGER.info("Captured & Saved Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
            }
        }
        if (!discovery.isDiscovered(uniqueFigureId)) {
            discovery.discover(uniqueFigureId);
            UnlockFigurePacket.sendToPlayer(player, uniqueFigureId, figure.getName(), skinSnapshot, quickSkinSnapshot);
            LOGGER.debug("Unlocked new figure: {} ({})", (Object)figure.getName(), (Object)uniqueFigureId);
        }
        class_2487 blockEntityTag = new class_2487();
        blockEntityTag.method_10582("FigureId", figure.getId());
        blockEntityTag.method_10582("CollectionId", collectionId);
        if (collectionId.equals("world_players")) {
            PopBlockColor color = figure.getFavoriteColor();
            if (color == null) {
                color = PopBlockColor.ORIGINAL;
            }
            blockEntityTag.method_10582("Color", color.name());
        }
        if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
            blockEntityTag.method_10582("SkinSnapshot", skinSnapshot);
        } else if (figure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
            blockEntityTag.method_10582("SkinSnapshot", oldSnapshot);
        }
        if (quickSkinSnapshot != null) {
            blockEntityTag.method_10582("QuickSkinId", quickSkinSnapshot);
        }
        blockEntityTag.method_10582("id", "blockpops:box_block");
        boxItem.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)blockEntityTag));
        class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318() + 1.0, player.method_23321(), boxItem);
        itemEntity.method_18800(0.0, 0.2, 0.0);
        player.method_37908().method_8649((class_1297)itemEntity);
    }

    @Nullable
    private static GameProfile getFreshGameProfile(class_3222 player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            ProfileResult result = player.method_5682().method_3844().fetchProfile(figure.getPlayerUUID(), true);
            return result != null ? result.profile() : null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    public void sendToServer() {
        NetworkManager.sendToServer((class_2960)ID, (class_9129)this.encode());
    }
}

