/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.blockentity;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BoxBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoxBlockEntity.class);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.box_block.idle");
    private static final RawAnimation OPEN_ANIMATION = RawAnimation.begin().thenPlay("animation.box_block.open");
    private static final RawAnimation OPEN_STATE_ANIMATION = RawAnimation.begin().thenLoop("animation.box_block.open_state");
    private static final RawAnimation CLOSE_ANIMATION = RawAnimation.begin().thenPlay("animation.box_block.close");
    private boolean isOpen = false;
    private String figureId = "";
    private String collectionIdOverride = null;
    private String colorOverride = null;
    private boolean isFigureExtracted = false;
    private int alternativeSkinIndex = 0;
    private String skinSnapshot = null;
    private String quickSkinId = null;
    private int poseIndex = 0;
    private double figureOffsetX = -0.53;
    private double figureOffsetY = 0.01;
    private double figureOffsetZ = -0.55;
    private double figureScale = 1.0;
    private double hitboxOffsetX = 0.0;
    private double hitboxOffsetY = 0.006;
    private double hitboxOffsetZ = 0.0;
    private double hitboxScaleX = 1.1;
    private double hitboxScaleY = 1.0;
    private double hitboxScaleZ = 0.9;
    private Double logoPositionX = null;
    private Double logoPositionY = null;
    private Double logoPositionZ = null;
    private Double logoScaleX = null;
    private Double logoScaleY = null;
    private Double logoScaleZ = null;
    private boolean hideLogo = false;

    public BoxBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BOX_BLOCK.get(), pos, blockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "box_controller", 0, state -> {
            if (this.m_58899_().equals((Object)BlockPos.f_121853_)) {
                return PlayState.STOP;
            }
            if (this.isOpen) {
                return state.setAndContinue(OPEN_STATE_ANIMATION);
            }
            return state.setAndContinue(IDLE_ANIMATION);
        }).triggerableAnim("open", OPEN_ANIMATION).triggerableAnim("close", CLOSE_ANIMATION).setAnimationSpeed(1.2)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "figure_pose_controller", 5, state -> {
            if (this.poseIndex == 1) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("Pose_Sit"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("Pose_Stand"));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public String getCollectionId() {
        if (this.collectionIdOverride != null && !this.collectionIdOverride.isEmpty()) {
            return this.collectionIdOverride;
        }
        return CollectionRegistry.getDefaultCollection().map(collection -> collection.getId()).orElse("");
    }

    @Nullable
    public PopBlockColor getColor() {
        if (this.colorOverride != null && !this.colorOverride.isEmpty()) {
            try {
                return PopBlockColor.valueOf(this.colorOverride.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public String getFigureId() {
        return this.figureId;
    }

    public void setFigureId(String figureId) {
        this.figureId = figureId != null ? figureId : "";
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public FigureDefinition getFigureDefinition() {
        if (this.figureId.isEmpty()) {
            return null;
        }
        return CollectionRegistry.getFigure(this.getCollectionId(), this.figureId).orElse(null);
    }

    public boolean hasFigure() {
        return !this.figureId.isEmpty() && this.getFigureDefinition() != null;
    }

    public boolean isFigureExtracted() {
        return this.isFigureExtracted;
    }

    public void setFigureExtracted(boolean extracted) {
        this.isFigureExtracted = extracted;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public double getFigureOffsetX() {
        return this.figureOffsetX;
    }

    public double getFigureOffsetY() {
        return this.figureOffsetY;
    }

    public double getFigureOffsetZ() {
        return this.figureOffsetZ;
    }

    public double getFigureScale() {
        return this.figureScale;
    }

    public void setFigureOffset(double x, double y, double z) {
        this.figureOffsetX = x;
        this.figureOffsetY = y;
        this.figureOffsetZ = z;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setFigureScale(double scale) {
        this.figureScale = scale;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public double getHitboxOffsetX() {
        return this.hitboxOffsetX;
    }

    public double getHitboxOffsetY() {
        return this.hitboxOffsetY;
    }

    public double getHitboxOffsetZ() {
        return this.hitboxOffsetZ;
    }

    public double getHitboxScaleX() {
        return this.hitboxScaleX;
    }

    public double getHitboxScaleY() {
        return this.hitboxScaleY;
    }

    public double getHitboxScaleZ() {
        return this.hitboxScaleZ;
    }

    public void setHitboxOffset(double x, double y, double z) {
        this.hitboxOffsetX = x;
        this.hitboxOffsetY = y;
        this.hitboxOffsetZ = z;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setHitboxScale(double scaleX, double scaleY, double scaleZ) {
        this.hitboxScaleX = scaleX;
        this.hitboxScaleY = scaleY;
        this.hitboxScaleZ = scaleZ;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public Double getLogoPositionX() {
        return this.logoPositionX;
    }

    public Double getLogoPositionY() {
        return this.logoPositionY;
    }

    public Double getLogoPositionZ() {
        return this.logoPositionZ;
    }

    public Double getLogoScaleX() {
        return this.logoScaleX;
    }

    public Double getLogoScaleY() {
        return this.logoScaleY;
    }

    public Double getLogoScaleZ() {
        return this.logoScaleZ;
    }

    public boolean isHideLogo() {
        return this.hideLogo;
    }

    public void setLogoPosition(Double x, Double y, Double z) {
        this.logoPositionX = x;
        this.logoPositionY = y;
        this.logoPositionZ = z;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setLogoScale(Double scaleX, Double scaleY, Double scaleZ) {
        this.logoScaleX = scaleX;
        this.logoScaleY = scaleY;
        this.logoScaleZ = scaleZ;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setCollectionIdOverride(String collectionId) {
        this.collectionIdOverride = collectionId;
        this.m_6596_();
    }

    public void setColorOverride(String color) {
        this.colorOverride = color;
        this.m_6596_();
    }

    public int getAlternativeSkinIndex() {
        return this.alternativeSkinIndex;
    }

    public String getSkinSnapshot() {
        return this.skinSnapshot;
    }

    public void setSkinSnapshot(String skinSnapshot) {
        this.skinSnapshot = skinSnapshot;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public String getQuickSkinId() {
        return this.quickSkinId;
    }

    public void setQuickSkinId(String quickSkinId) {
        this.quickSkinId = quickSkinId;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void cycleAlternativeSkin() {
        FigureDefinition def = this.getFigureDefinition();
        if (def == null || !def.hasAlternatives()) {
            return;
        }
        int totalSkins = 1 + def.getAlternatives().size();
        this.alternativeSkinIndex = (this.alternativeSkinIndex + 1) % totalSkins;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getPoseIndex() {
        return this.poseIndex;
    }

    public void cyclePose() {
        this.poseIndex = (this.poseIndex + 1) % 2;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void toggleOpen() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean bl = this.isOpen = !this.isOpen;
            if (this.isOpen) {
                this.triggerAnim("box_controller", "open");
            } else {
                this.triggerAnim("box_controller", "close");
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Deprecated
    public void triggerOpenAnimation() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.isOpen) {
            this.toggleOpen();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("IsOpen", this.isOpen);
        tag.m_128359_("FigureId", this.figureId);
        tag.m_128379_("IsFigureExtracted", this.isFigureExtracted);
        tag.m_128405_("AlternativeSkinIndex", this.alternativeSkinIndex);
        tag.m_128405_("PoseIndex", this.poseIndex);
        if (this.skinSnapshot != null) {
            tag.m_128359_("SkinSnapshot", this.skinSnapshot);
        }
        if (this.quickSkinId != null) {
            tag.m_128359_("QuickSkinId", this.quickSkinId);
        }
        if (this.collectionIdOverride != null) {
            tag.m_128359_("CollectionId", this.collectionIdOverride);
        }
        if (this.colorOverride != null) {
            tag.m_128359_("Color", this.colorOverride);
        }
        tag.m_128347_("FigureOffsetX", this.figureOffsetX);
        tag.m_128347_("FigureOffsetY", this.figureOffsetY);
        tag.m_128347_("FigureOffsetZ", this.figureOffsetZ);
        tag.m_128347_("FigureScale", this.figureScale);
        tag.m_128347_("HitboxOffsetX", this.hitboxOffsetX);
        tag.m_128347_("HitboxOffsetY", this.hitboxOffsetY);
        tag.m_128347_("HitboxOffsetZ", this.hitboxOffsetZ);
        tag.m_128347_("HitboxScaleX", this.hitboxScaleX);
        tag.m_128347_("HitboxScaleY", this.hitboxScaleY);
        tag.m_128347_("HitboxScaleZ", this.hitboxScaleZ);
        if (this.logoPositionX != null) {
            tag.m_128347_("LogoPositionX", this.logoPositionX.doubleValue());
        }
        if (this.logoPositionY != null) {
            tag.m_128347_("LogoPositionY", this.logoPositionY.doubleValue());
        }
        if (this.logoPositionZ != null) {
            tag.m_128347_("LogoPositionZ", this.logoPositionZ.doubleValue());
        }
        if (this.logoScaleX != null) {
            tag.m_128347_("LogoScaleX", this.logoScaleX.doubleValue());
        }
        if (this.logoScaleY != null) {
            tag.m_128347_("LogoScaleY", this.logoScaleY.doubleValue());
        }
        tag.m_128379_("HideLogo", this.hideLogo);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        boolean bl = this.isOpen = tag.m_128441_("IsOpen") ? tag.m_128471_("IsOpen") : false;
        if (tag.m_128441_("FigureId")) {
            this.figureId = tag.m_128461_("FigureId");
        }
        if (tag.m_128441_("IsFigureExtracted")) {
            this.isFigureExtracted = tag.m_128471_("IsFigureExtracted");
        }
        if (tag.m_128441_("AlternativeSkinIndex")) {
            this.alternativeSkinIndex = tag.m_128451_("AlternativeSkinIndex");
        }
        if (tag.m_128441_("PoseIndex")) {
            this.poseIndex = tag.m_128451_("PoseIndex");
        }
        this.skinSnapshot = tag.m_128425_("SkinSnapshot", 8) ? tag.m_128461_("SkinSnapshot") : null;
        String string = this.quickSkinId = tag.m_128425_("QuickSkinId", 8) ? tag.m_128461_("QuickSkinId") : null;
        if (tag.m_128441_("CollectionId")) {
            this.collectionIdOverride = tag.m_128461_("CollectionId");
        }
        if (tag.m_128441_("Color")) {
            this.colorOverride = tag.m_128461_("Color");
        }
        if (tag.m_128441_("FigureOffsetX")) {
            this.figureOffsetX = tag.m_128459_("FigureOffsetX");
        }
        if (tag.m_128441_("FigureOffsetY")) {
            this.figureOffsetY = tag.m_128459_("FigureOffsetY");
        }
        if (tag.m_128441_("FigureOffsetZ")) {
            this.figureOffsetZ = tag.m_128459_("FigureOffsetZ");
        }
        if (tag.m_128441_("FigureScale")) {
            this.figureScale = tag.m_128459_("FigureScale");
        }
        if (tag.m_128441_("HitboxOffsetX")) {
            this.hitboxOffsetX = tag.m_128459_("HitboxOffsetX");
        }
        if (tag.m_128441_("HitboxOffsetY")) {
            this.hitboxOffsetY = tag.m_128459_("HitboxOffsetY");
        }
        if (tag.m_128441_("HitboxOffsetZ")) {
            this.hitboxOffsetZ = tag.m_128459_("HitboxOffsetZ");
        }
        if (tag.m_128441_("HitboxScaleX")) {
            this.hitboxScaleX = tag.m_128459_("HitboxScaleX");
        }
        if (tag.m_128441_("HitboxScaleY")) {
            this.hitboxScaleY = tag.m_128459_("HitboxScaleY");
        }
        if (tag.m_128441_("HitboxScaleZ")) {
            this.hitboxScaleZ = tag.m_128459_("HitboxScaleZ");
        }
        this.logoPositionX = tag.m_128441_("LogoPositionX") ? Double.valueOf(tag.m_128459_("LogoPositionX")) : null;
        this.logoPositionY = tag.m_128441_("LogoPositionY") ? Double.valueOf(tag.m_128459_("LogoPositionY")) : null;
        this.logoPositionZ = tag.m_128441_("LogoPositionZ") ? Double.valueOf(tag.m_128459_("LogoPositionZ")) : null;
        this.logoScaleX = tag.m_128441_("LogoScaleX") ? Double.valueOf(tag.m_128459_("LogoScaleX")) : null;
        Double d = this.logoScaleY = tag.m_128441_("LogoScaleY") ? Double.valueOf(tag.m_128459_("LogoScaleY")) : null;
        if (tag.m_128441_("HideLogo")) {
            this.hideLogo = tag.m_128471_("HideLogo");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        tag.m_128379_("IsOpen", false);
        stack.m_41700_("BlockEntityTag", (Tag)tag);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level.f_46443_ && blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
        }
    }
}

