/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.capability;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.capability.IPlayerDiscovery;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerDiscovery
implements IPlayerDiscovery,
INBTSerializable<CompoundTag> {
    private final Set<String> discoveredFigures = new HashSet<String>();
    private static final String NBT_KEY = "DiscoveredFigures";
    private int regularTokens = 0;
    private long nextRegularTokenTime = 0L;
    private long lastSpecialTokenResetTimestamp = 0L;
    private boolean usedTodaySpecialToken = false;
    private boolean hasChosenFavoriteColor = false;
    private String favoriteColor = null;
    private final Map<String, String> figureSkins = new HashMap<String, String>();
    private static final String NBT_FIGURE_SKINS_KEY = "FigureSkins";
    private final Map<String, String> figureQuickSkins = new HashMap<String, String>();
    private static final String NBT_FIGURE_QUICK_SKINS_KEY = "FigureQuickSkins";

    @Override
    public boolean isDiscovered(String figureId) {
        return this.discoveredFigures.contains(figureId);
    }

    @Override
    public void discover(String figureId) {
        this.discoveredFigures.add(figureId);
    }

    @Override
    public Set<String> getDiscoveredSet() {
        return Collections.unmodifiableSet(this.discoveredFigures);
    }

    @Override
    public void syncFrom(Set<String> discovered) {
        this.discoveredFigures.clear();
        this.discoveredFigures.addAll(discovered);
    }

    @Override
    public int getRegularTokens() {
        return this.regularTokens;
    }

    @Override
    public void setRegularTokens(int count) {
        this.regularTokens = count;
    }

    @Override
    public long getNextRegularTokenTime() {
        return this.nextRegularTokenTime;
    }

    @Override
    public void setNextRegularTokenTime(long worldTimeTicks) {
        this.nextRegularTokenTime = worldTimeTicks;
    }

    @Override
    public long getLastSpecialTokenResetTimestamp() {
        return this.lastSpecialTokenResetTimestamp;
    }

    @Override
    public void setLastSpecialTokenResetTimestamp(long timestamp) {
        this.lastSpecialTokenResetTimestamp = timestamp;
    }

    @Override
    public boolean hasUsedTodaySpecialToken() {
        return this.usedTodaySpecialToken;
    }

    @Override
    public void setUsedTodaySpecialToken(boolean used) {
        this.usedTodaySpecialToken = used;
    }

    @Override
    public boolean hasChosenFavoriteColor() {
        return this.hasChosenFavoriteColor;
    }

    @Override
    public void setHasChosenFavoriteColor(boolean hasChosen) {
        this.hasChosenFavoriteColor = hasChosen;
    }

    @Override
    @Nullable
    public PopBlockColor getFavoriteColor() {
        if (this.favoriteColor == null) {
            return null;
        }
        try {
            return PopBlockColor.valueOf(this.favoriteColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void setFavoriteColor(@Nullable PopBlockColor color) {
        this.favoriteColor = color != null ? color.name() : null;
    }

    @Override
    public void saveFigureSkin(String figureId, String skinUrl) {
        this.figureSkins.put(figureId, skinUrl);
    }

    @Override
    @Nullable
    public String getFigureSkin(String figureId) {
        return this.figureSkins.get(figureId);
    }

    @Override
    public Map<String, String> getAllFigureSkins() {
        return Collections.unmodifiableMap(this.figureSkins);
    }

    @Override
    public void saveFigureQuickSkin(String figureId, String quickSkinId) {
        this.figureQuickSkins.put(figureId, quickSkinId);
    }

    @Override
    @Nullable
    public String getFigureQuickSkin(String figureId) {
        return this.figureQuickSkins.get(figureId);
    }

    @Override
    public Map<String, String> getAllFigureQuickSkins() {
        return Collections.unmodifiableMap(this.figureQuickSkins);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (String figureId : this.discoveredFigures) {
            listTag.add((Object)StringTag.m_129297_((String)figureId));
        }
        tag.m_128365_(NBT_KEY, (Tag)listTag);
        tag.m_128405_("RegularTokens", this.regularTokens);
        tag.m_128356_("NextRegularTokenTime", this.nextRegularTokenTime);
        tag.m_128356_("LastSpecialTokenResetTimestamp", this.lastSpecialTokenResetTimestamp);
        tag.m_128379_("UsedTodaySpecialToken", this.usedTodaySpecialToken);
        tag.m_128379_("HasChosenFavoriteColor", this.hasChosenFavoriteColor);
        if (this.favoriteColor != null) {
            tag.m_128359_("FavoriteColor", this.favoriteColor);
        }
        if (!this.figureSkins.isEmpty()) {
            CompoundTag skinsTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.figureSkins.entrySet()) {
                skinsTag.m_128359_(entry.getKey(), entry.getValue());
            }
            tag.m_128365_(NBT_FIGURE_SKINS_KEY, (Tag)skinsTag);
        }
        if (!this.figureQuickSkins.isEmpty()) {
            CompoundTag qsTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.figureQuickSkins.entrySet()) {
                qsTag.m_128359_(entry.getKey(), entry.getValue());
            }
            tag.m_128365_(NBT_FIGURE_QUICK_SKINS_KEY, (Tag)qsTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.discoveredFigures.clear();
        if (tag.m_128425_(NBT_KEY, 9)) {
            ListTag listTag = tag.m_128437_(NBT_KEY, 8);
            for (int i = 0; i < listTag.size(); ++i) {
                this.discoveredFigures.add(listTag.m_128778_(i));
            }
        }
        if (tag.m_128441_("RegularTokens")) {
            this.regularTokens = tag.m_128451_("RegularTokens");
        }
        if (tag.m_128441_("NextRegularTokenTime")) {
            this.nextRegularTokenTime = tag.m_128454_("NextRegularTokenTime");
        }
        if (tag.m_128441_("LastSpecialTokenResetTimestamp")) {
            this.lastSpecialTokenResetTimestamp = tag.m_128454_("LastSpecialTokenResetTimestamp");
        }
        if (tag.m_128441_("UsedTodaySpecialToken")) {
            this.usedTodaySpecialToken = tag.m_128471_("UsedTodaySpecialToken");
        }
        this.hasChosenFavoriteColor = tag.m_128471_("HasChosenFavoriteColor");
        this.favoriteColor = tag.m_128425_("FavoriteColor", 8) ? tag.m_128461_("FavoriteColor") : null;
        this.figureSkins.clear();
        if (tag.m_128425_(NBT_FIGURE_SKINS_KEY, 10)) {
            CompoundTag skinsTag = tag.m_128469_(NBT_FIGURE_SKINS_KEY);
            for (String key : skinsTag.m_128431_()) {
                this.figureSkins.put(key, skinsTag.m_128461_(key));
            }
        }
        this.figureQuickSkins.clear();
        if (tag.m_128425_(NBT_FIGURE_QUICK_SKINS_KEY, 10)) {
            CompoundTag qsTag = tag.m_128469_(NBT_FIGURE_QUICK_SKINS_KEY);
            for (String key : qsTag.m_128431_()) {
                this.figureQuickSkins.put(key, qsTag.m_128461_(key));
            }
        }
    }
}

