/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.data;

import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDiscovery;
import com.theplumteam.data.forge.PlayerDataManagerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class PlayerDataManager {
    public static final String DATA_KEY = "blockpops_discovery";
    private static final WeakHashMap<Player, PlayerDiscovery> cache = new WeakHashMap();

    public static IPlayerDiscovery getDiscovery(Player player) {
        PlayerDiscovery cached = cache.get(player);
        if (cached != null) {
            return cached;
        }
        PlayerDiscovery discovery = new PlayerDiscovery();
        CompoundTag persistentData = PlayerDataManager.getPersistentData(player);
        if (persistentData.m_128425_(DATA_KEY, 10)) {
            discovery.deserializeNBT(persistentData.m_128469_(DATA_KEY));
        }
        cache.put(player, discovery);
        return discovery;
    }

    public static void saveDiscovery(Player player) {
        PlayerDiscovery discovery = cache.get(player);
        if (discovery != null) {
            PlayerDataManager.getPersistentData(player).m_128365_(DATA_KEY, (Tag)discovery.serializeNBT());
        }
    }

    public static void markDirty(Player player, IPlayerDiscovery discovery) {
        if (discovery instanceof PlayerDiscovery) {
            PlayerDiscovery pd = (PlayerDiscovery)discovery;
            cache.put(player, pd);
            PlayerDataManager.getPersistentData(player).m_128365_(DATA_KEY, (Tag)pd.serializeNBT());
        }
    }

    public static void copyData(Player from, Player to) {
        CompoundTag fromData = PlayerDataManager.getPersistentData(from);
        if (fromData.m_128425_(DATA_KEY, 10)) {
            PlayerDataManager.getPersistentData(to).m_128365_(DATA_KEY, (Tag)fromData.m_128469_(DATA_KEY).m_6426_());
            cache.remove(to);
        }
    }

    public static void clearCache(Player player) {
        cache.remove(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CompoundTag getPersistentData(Player player) {
        return PlayerDataManagerImpl.getPersistentData(player);
    }
}

