/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadTokensPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadTokensPacket.class);
    public static final ResourceLocation ID = new ResourceLocation("blockpops", "reload_tokens");
    private final boolean reloadRegular;
    private final boolean reloadGuaranteed;

    public ReloadTokensPacket(boolean reloadRegular, boolean reloadGuaranteed) {
        this.reloadRegular = reloadRegular;
        this.reloadGuaranteed = reloadGuaranteed;
    }

    public FriendlyByteBuf encode() {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeBoolean(this.reloadRegular);
        buffer.writeBoolean(this.reloadGuaranteed);
        return buffer;
    }

    public static ReloadTokensPacket decode(FriendlyByteBuf buffer) {
        boolean reloadRegular = buffer.readBoolean();
        boolean reloadGuaranteed = buffer.readBoolean();
        return new ReloadTokensPacket(reloadRegular, reloadGuaranteed);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ReloadTokensPacket packet = ReloadTokensPacket.decode(buf);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (!player.m_20310_(2)) {
                    LOGGER.warn("Player {} tried to reload tokens without permission", (Object)player.m_7755_().getString());
                    return;
                }
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
                if (packet.reloadRegular) {
                    discovery.setRegularTokens(3);
                    discovery.setNextRegularTokenTime(0L);
                    LOGGER.info("Reloaded regular tokens for player {}", (Object)player.m_7755_().getString());
                }
                if (packet.reloadGuaranteed) {
                    discovery.setUsedTodaySpecialToken(false);
                    LOGGER.info("Reloaded guaranteed token for player {}", (Object)player.m_7755_().getString());
                }
                PlayerDataManager.markDirty((Player)player, discovery);
                long gameTime = player.m_284548_().m_46467_();
                long nextRegularTime = discovery.getNextRegularTokenTime();
                long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
                SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
            }
        });
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)this.encode());
    }
}

