/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.PlayerCollectionHelper;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetFavoriteColorPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetFavoriteColorPacket.class);
    public static final ResourceLocation ID = new ResourceLocation("blockpops", "set_favorite_color");
    private final String colorName;

    public SetFavoriteColorPacket(String colorName) {
        this.colorName = colorName;
    }

    public FriendlyByteBuf encode() {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(this.colorName);
        return buffer;
    }

    public static SetFavoriteColorPacket decode(FriendlyByteBuf buffer) {
        String colorName = buffer.m_130277_();
        return new SetFavoriteColorPacket(colorName);
    }

    public static void handleServer(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        SetFavoriteColorPacket packet = SetFavoriteColorPacket.decode(buf);
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
                try {
                    PopBlockColor color = PopBlockColor.valueOf(packet.colorName.toUpperCase());
                    discovery.setFavoriteColor(color);
                    discovery.setHasChosenFavoriteColor(true);
                    PlayerDataManager.markDirty((Player)player, discovery);
                    LOGGER.info("Player {} chose favorite color: {}", (Object)player.m_7755_().getString(), (Object)color.m_7912_());
                    if (player.m_20194_() != null) {
                        PlayerCollectionHelper.regenerateAndSyncPlayerCollection(player.m_20194_());
                        LOGGER.info("Regenerated World Players collection after {} changed their favorite color", (Object)player.m_7755_().getString());
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Player {} sent invalid color name: {}", (Object)player.m_7755_().getString(), (Object)packet.colorName);
                }
            }
        });
    }

    public void sendToServer() {
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)this.encode());
    }
}

