/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.client.discovery.ClientDiscoveryManager;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDiscoveryDataPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDiscoveryDataPacket.class);
    public static final ResourceLocation ID = new ResourceLocation("blockpops", "sync_discovery_data");
    private final Set<String> discoveredFigures;
    private final Map<String, String> figureSkins;
    private final Map<String, String> figureQuickSkins;

    public SyncDiscoveryDataPacket(Set<String> discoveredFigures, Map<String, String> figureSkins, Map<String, String> figureQuickSkins) {
        this.discoveredFigures = new HashSet<String>(discoveredFigures);
        this.figureSkins = new HashMap<String, String>(figureSkins);
        this.figureQuickSkins = new HashMap<String, String>(figureQuickSkins);
    }

    public FriendlyByteBuf encode() {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(this.discoveredFigures.size());
        for (String string : this.discoveredFigures) {
            buffer.m_130070_(string);
        }
        buffer.writeInt(this.figureSkins.size());
        for (Map.Entry entry : this.figureSkins.entrySet()) {
            buffer.m_130070_((String)entry.getKey());
            buffer.m_130070_((String)entry.getValue());
        }
        buffer.writeInt(this.figureQuickSkins.size());
        for (Map.Entry entry : this.figureQuickSkins.entrySet()) {
            buffer.m_130070_((String)entry.getKey());
            buffer.m_130070_((String)entry.getValue());
        }
        return buffer;
    }

    public static SyncDiscoveryDataPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashSet<String> discoveredFigures = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            discoveredFigures.add(buffer.m_130277_());
        }
        int skinsSize = buffer.readInt();
        HashMap<String, String> figureSkins = new HashMap<String, String>();
        for (int i = 0; i < skinsSize; ++i) {
            String figureId = buffer.m_130277_();
            String skinUrl = buffer.m_130277_();
            figureSkins.put(figureId, skinUrl);
        }
        int qsSize = buffer.readInt();
        HashMap<String, String> figureQuickSkins = new HashMap<String, String>();
        for (int i = 0; i < qsSize; ++i) {
            String figureId = buffer.m_130277_();
            String quickSkinId = buffer.m_130277_();
            figureQuickSkins.put(figureId, quickSkinId);
        }
        return new SyncDiscoveryDataPacket(discoveredFigures, figureSkins, figureQuickSkins);
    }

    public static void handleClient(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        SyncDiscoveryDataPacket packet = SyncDiscoveryDataPacket.decode(buf);
        context.queue(() -> {
            LOGGER.info("Received discovery data sync: {} figures discovered, {} skins, {} quick skins", new Object[]{packet.discoveredFigures.size(), packet.figureSkins.size(), packet.figureQuickSkins.size()});
            ClientDiscoveryManager.setData(packet.discoveredFigures, packet.figureSkins, packet.figureQuickSkins);
        });
    }

    public static void sendToPlayer(ServerPlayer player, Set<String> discoveredFigures, Map<String, String> figureSkins) {
        SyncDiscoveryDataPacket.sendToPlayer(player, discoveredFigures, figureSkins, new HashMap<String, String>());
    }

    public static void sendToPlayer(ServerPlayer player, Set<String> discoveredFigures, Map<String, String> figureSkins, Map<String, String> figureQuickSkins) {
        SyncDiscoveryDataPacket packet = new SyncDiscoveryDataPacket(discoveredFigures, figureSkins, figureQuickSkins);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ID, (FriendlyByteBuf)packet.encode());
    }

    public Set<String> getDiscoveredFigures() {
        return this.discoveredFigures;
    }

    public Map<String, String> getFigureSkins() {
        return this.figureSkins;
    }

    public Map<String, String> getFigureQuickSkins() {
        return this.figureQuickSkins;
    }
}

