/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinModelDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkinModelDetector.class);
    private static final ConcurrentHashMap<ResourceLocation, SkinModel> DETECTION_CACHE = new ConcurrentHashMap();

    public static void clearCache() {
        DETECTION_CACHE.clear();
        LOGGER.info("Skin model detection cache cleared");
    }

    public static SkinModel detectSkinModel(ResourceLocation textureLocation) {
        SkinModel cached = DETECTION_CACHE.get(textureLocation);
        if (cached != null) {
            return cached;
        }
        LOGGER.debug("Attempting to detect skin model for texture: {}", (Object)textureLocation);
        try {
            TextureManager textureManager;
            AbstractTexture abstractTexture;
            if (Minecraft.m_91087_().m_91403_() != null) {
                Collection playerListEntries = Minecraft.m_91087_().m_91403_().m_105142_();
                for (PlayerInfo playerInfo : playerListEntries) {
                    if (!playerInfo.m_105337_().equals((Object)textureLocation)) continue;
                    String modelName = playerInfo.m_105336_();
                    SkinModel model = "slim".equals(modelName) ? SkinModel.SLIM : SkinModel.CLASSIC;
                    LOGGER.info("Detected {} skin from PlayerInfo for texture: {}", (Object)model, (Object)textureLocation);
                    DETECTION_CACHE.put(textureLocation, model);
                    return model;
                }
            }
            if ((abstractTexture = (textureManager = Minecraft.m_91087_().m_91097_()).m_118506_(textureLocation)) instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)abstractTexture;
                NativeImage image = dynamicTexture.m_117991_();
                if (image != null) {
                    SkinModel model = SkinModelDetector.detectSkinModel(image);
                    LOGGER.info("Detected {} skin from DynamicTexture for texture: {}", (Object)model, (Object)textureLocation);
                    DETECTION_CACHE.put(textureLocation, model);
                    return model;
                }
            } else if (abstractTexture instanceof HttpTexture) {
                HttpTexture httpTexture = (HttpTexture)abstractTexture;
                try {
                    Field textureImageField = HttpTexture.class.getDeclaredField("textureImage");
                    textureImageField.setAccessible(true);
                    NativeImage image = (NativeImage)textureImageField.get(httpTexture);
                    if (image != null) {
                        SkinModel model = SkinModelDetector.detectSkinModel(image);
                        LOGGER.info("Detected {} skin from HttpTexture for texture: {}", (Object)model, (Object)textureLocation);
                        DETECTION_CACHE.put(textureLocation, model);
                        return model;
                    }
                }
                catch (Exception reflectionEx) {
                    LOGGER.debug("Could not access HttpTexture image via reflection: {}", (Object)reflectionEx.getMessage());
                }
            }
            try {
                InputStream inputStream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(textureLocation).orElseThrow()).m_215507_();
                NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
                SkinModel model = SkinModelDetector.detectSkinModel(image);
                image.close();
                inputStream.close();
                LOGGER.info("Detected {} skin for texture: {}", (Object)model, (Object)textureLocation);
                DETECTION_CACHE.put(textureLocation, model);
                return model;
            }
            catch (Exception resourceException) {
                LOGGER.warn("Could not load texture from resource manager: {}", (Object)resourceException.getMessage());
                LOGGER.warn("Could not detect skin model, defaulting to CLASSIC");
                DETECTION_CACHE.put(textureLocation, SkinModel.CLASSIC);
                return SkinModel.CLASSIC;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to detect skin model from texture: {}", (Object)textureLocation, (Object)e);
            DETECTION_CACHE.put(textureLocation, SkinModel.CLASSIC);
            return SkinModel.CLASSIC;
        }
    }

    public static SkinModel detectSkinModel(NativeImage image) {
        int red;
        int green;
        int blue;
        int alpha;
        int rgba;
        int x;
        int y;
        int scale;
        int height;
        if (image == null) {
            return SkinModel.CLASSIC;
        }
        int width = image.m_84982_();
        SkinResolution resolution = SkinResolution.fromDimensions(width, height = image.m_85084_());
        int n = scale = resolution != null ? resolution.getScale() : 1;
        if (resolution == SkinResolution.LEGACY) {
            return SkinModel.CLASSIC;
        }
        int rightArmX = 54 * scale;
        int rightArmEndX = 56 * scale;
        int rightArmStartY = 20 * scale;
        int rightArmEndY = 32 * scale;
        int leftArmX = 46 * scale;
        int leftArmEndX = 48 * scale;
        int leftArmStartY = 52 * scale;
        int leftArmEndY = 64 * scale;
        int totalPixels = 0;
        int transparentPixels = 0;
        for (y = rightArmStartY; y < rightArmEndY && y < height; ++y) {
            for (x = rightArmX; x < rightArmEndX && x < width; ++x) {
                ++totalPixels;
                rgba = image.m_84985_(x, y);
                alpha = rgba >> 24 & 0xFF;
                blue = rgba >> 16 & 0xFF;
                green = rgba >> 8 & 0xFF;
                red = rgba & 0xFF;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        for (y = leftArmStartY; y < leftArmEndY && y < height; ++y) {
            for (x = leftArmX; x < leftArmEndX && x < width; ++x) {
                ++totalPixels;
                rgba = image.m_84985_(x, y);
                alpha = rgba >> 24 & 0xFF;
                blue = rgba >> 16 & 0xFF;
                green = rgba >> 8 & 0xFF;
                red = rgba & 0xFF;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        if (totalPixels > 0) {
            float transparentRatio = (float)transparentPixels / (float)totalPixels;
            boolean isSlim = transparentRatio > 0.5f;
            LOGGER.debug("Skin model detection: {}% transparent pixels -> {}", (Object)((int)(transparentRatio * 100.0f)), (Object)(isSlim ? "slim" : "classic"));
            return isSlim ? SkinModel.SLIM : SkinModel.CLASSIC;
        }
        return SkinModel.CLASSIC;
    }

    public static enum SkinModel {
        CLASSIC,
        SLIM;

    }

    public static enum SkinResolution {
        LEGACY(64, 32, 1),
        STANDARD(64, 64, 1),
        HD_128(128, 64, 2),
        HD_256(256, 128, 4),
        HD_512(512, 256, 8),
        HD_1024(1024, 512, 16),
        HD_2048(2048, 1024, 32);

        private final int width;
        private final int height;
        private final int scale;

        private SkinResolution(int width, int height, int scale) {
            this.width = width;
            this.height = height;
            this.scale = scale;
        }

        public int getScale() {
            return this.scale;
        }

        public static SkinResolution fromDimensions(int width, int height) {
            for (SkinResolution res : SkinResolution.values()) {
                if (res.width != width || res.height != height) continue;
                return res;
            }
            return null;
        }
    }
}

