/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.block;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.platform.PlatformHelper;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModItems;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class BoxBlock
extends class_2237 {
    public static final class_2753 FACING = class_2383.field_11177;
    private static final class_265 SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    public BoxBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_265 baseShape = SHAPE;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)class_25862;
            double localOffsetX = boxBlockEntity.getHitboxOffsetX();
            double localOffsetY = boxBlockEntity.getHitboxOffsetY();
            double localOffsetZ = boxBlockEntity.getHitboxOffsetZ();
            double hitboxScaleX = boxBlockEntity.getHitboxScaleX();
            double hitboxScaleY = boxBlockEntity.getHitboxScaleY();
            double hitboxScaleZ = boxBlockEntity.getHitboxScaleZ();
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            class_265 scaledShape = baseShape;
            if (hitboxScaleX != 1.0 || hitboxScaleY != 1.0 || hitboxScaleZ != 1.0) {
                double centerX = 8.0;
                double centerY = 7.0;
                double centerZ = 8.0;
                double effectiveScaleX = hitboxScaleX;
                double effectiveScaleZ = hitboxScaleZ;
                if (facing == class_2350.field_11034 || facing == class_2350.field_11039) {
                    effectiveScaleX = hitboxScaleZ;
                    effectiveScaleZ = hitboxScaleX;
                }
                double minX = centerX + (3.0 - centerX) * effectiveScaleX;
                double minY = 0.0;
                double minZ = centerZ + (3.0 - centerZ) * effectiveScaleZ;
                double maxX = centerX + (13.0 - centerX) * effectiveScaleX;
                double maxY = 14.0 * hitboxScaleY;
                double maxZ = centerZ + (13.0 - centerZ) * effectiveScaleZ;
                scaledShape = class_2248.method_9541((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            }
            if (localOffsetX != 0.0 || localOffsetY != 0.0 || localOffsetZ != 0.0) {
                double worldOffsetX = 0.0;
                double worldOffsetZ = 0.0;
                switch (facing) {
                    case field_11043: {
                        worldOffsetX = localOffsetX;
                        worldOffsetZ = -localOffsetZ;
                        break;
                    }
                    case field_11035: {
                        worldOffsetX = -localOffsetX;
                        worldOffsetZ = localOffsetZ;
                        break;
                    }
                    case field_11034: {
                        worldOffsetX = localOffsetZ;
                        worldOffsetZ = localOffsetX;
                        break;
                    }
                    case field_11039: {
                        worldOffsetX = -localOffsetZ;
                        worldOffsetZ = -localOffsetX;
                    }
                }
                return scaledShape.method_1096(worldOffsetX, localOffsetY, worldOffsetZ);
            }
            return scaledShape;
        }
        return baseShape;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BoxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 ? BoxBlock.method_31618(blockEntityType, (class_2591)((class_2591)ModBlockEntities.BOX_BLOCK.get()), BoxBlockEntity::tick) : null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldItem = player.method_5998(hand);
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof BoxBlockEntity)) {
            return class_1269.field_5811;
        }
        BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
        if (player.method_5715()) {
            if (boxBlockEntity.isOpen() && !level.field_9236) {
                boxBlockEntity.toggleOpen();
                return class_1269.field_5812;
            }
            if (!boxBlockEntity.isOpen() && level.field_9236 && PlatformHelper.isDevelopmentEnvironment()) {
                PlatformHelper.openBoxFigureScreen(pos, boxBlockEntity);
                return class_1269.field_5812;
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (!level.field_9236) {
            if (boxBlockEntity.isOpen()) {
                if (heldItem.method_7909() == ModItems.FIGURE_BLOCK_ITEM.get() && boxBlockEntity.isFigureExtracted()) {
                    class_2487 blockEntityTag = heldItem.method_7941("BlockEntityTag");
                    if (blockEntityTag != null) {
                        String heldFigureId = blockEntityTag.method_10558("FigureId");
                        String heldCollectionId = blockEntityTag.method_10558("CollectionId");
                        if (heldFigureId.equals(boxBlockEntity.getFigureId()) && heldCollectionId.equals(boxBlockEntity.getCollectionId())) {
                            if (blockEntityTag.method_10545("QuickSkinId")) {
                                boxBlockEntity.setQuickSkinId(blockEntityTag.method_10558("QuickSkinId"));
                            }
                            if (blockEntityTag.method_10545("SkinSnapshot")) {
                                boxBlockEntity.setSkinSnapshot(blockEntityTag.method_10558("SkinSnapshot"));
                            }
                            boxBlockEntity.setFigureExtracted(false);
                            boxBlockEntity.toggleOpen();
                            heldItem.method_7934(1);
                            level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
                            return class_1269.field_5812;
                        }
                    }
                } else if (boxBlockEntity.hasFigure() && !boxBlockEntity.isFigureExtracted()) {
                    class_1799 figureBlockItem = new class_1799((class_1935)ModItems.FIGURE_BLOCK_ITEM.get());
                    class_2487 blockEntityTag = new class_2487();
                    blockEntityTag.method_10582("FigureId", boxBlockEntity.getFigureId());
                    blockEntityTag.method_10582("CollectionId", boxBlockEntity.getCollectionId());
                    blockEntityTag.method_10569("AlternativeSkinIndex", boxBlockEntity.getAlternativeSkinIndex());
                    blockEntityTag.method_10569("PoseIndex", boxBlockEntity.getPoseIndex());
                    blockEntityTag.method_10549("FigureOffsetX", boxBlockEntity.getFigureOffsetX());
                    blockEntityTag.method_10549("FigureOffsetY", boxBlockEntity.getFigureOffsetY());
                    blockEntityTag.method_10549("FigureOffsetZ", boxBlockEntity.getFigureOffsetZ());
                    blockEntityTag.method_10549("FigureScale", boxBlockEntity.getFigureScale());
                    FigureDefinition figureDef = boxBlockEntity.getFigureDefinition();
                    if (figureDef != null && figureDef.getType() == FigureType.PLAYER) {
                        String quickSkinId;
                        String snapshot = boxBlockEntity.getSkinSnapshot();
                        if (snapshot != null && !snapshot.isEmpty()) {
                            blockEntityTag.method_10582("SkinSnapshot", snapshot);
                        }
                        if ((quickSkinId = boxBlockEntity.getQuickSkinId()) != null && !quickSkinId.isEmpty()) {
                            blockEntityTag.method_10582("QuickSkinId", quickSkinId);
                        }
                    }
                    figureBlockItem.method_7959("BlockEntityTag", (class_2520)blockEntityTag);
                    if (!player.method_31548().method_7394(figureBlockItem)) {
                        player.method_7328(figureBlockItem, false);
                    }
                    boxBlockEntity.setFigureExtracted(true);
                    level.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
            } else {
                if (heldItem.method_7909() == class_1802.field_8868) {
                    boxBlockEntity.toggleOpen();
                    level.method_8396(null, pos, class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"Use Shears to open").method_27692(class_124.field_1080), true);
                return class_1269.field_5812;
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 playerFacing = context.method_8042();
        class_2350 blockFacing = playerFacing.method_10153();
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)blockFacing);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 blockEntity;
        super.method_9567(level, pos, state, placer, stack);
        if (!level.field_9236 && (blockEntity = level.method_8321(pos)) instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            class_2487 tag = stack.method_7941("BlockEntityTag");
            if (tag != null) {
                if (tag.method_10545("QuickSkinId")) {
                    boxBlockEntity.setQuickSkinId(tag.method_10558("QuickSkinId"));
                }
                if (tag.method_10545("SkinSnapshot")) {
                    boxBlockEntity.setSkinSnapshot(tag.method_10558("SkinSnapshot"));
                }
            }
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity;
        if (!level.field_9236 && (blockEntity = level.method_8321(pos)) instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            String collectionId = boxBlockEntity.getCollectionId();
            PopBlockColor color = boxBlockEntity.getColor();
            class_1799 dropStack = color != null ? new class_1799((class_1935)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get()) : (collectionId != null && !collectionId.isEmpty() ? new class_1799((class_1935)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new class_1799((class_1935)this.method_8389()));
            boxBlockEntity.method_38240(dropStack);
            BoxBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)dropStack);
        }
        super.method_9576(level, pos, state, player);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(level, pos, state);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)class_25862;
            boxBlockEntity.method_38240(stack);
        }
        return stack;
    }
}

