/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.client.config.ClientConfig;
import com.theplumteam.client.gui.util.ButtonFactory;
import com.theplumteam.client.gui.widget.TabButton;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.network.ReloadTokensPacket;
import com.theplumteam.network.UnlockCollectionPacket;
import com.theplumteam.network.UpdateGuaranteedResetHourPacket;
import com.theplumteam.server.config.ServerConfig;
import dev.architectury.platform.Platform;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class SettingsScreen
extends class_437 {
    private final class_437 parent;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_WIDTH = 100;
    private static final int TAB_SPACING = 2;
    private int panelWidth = 650;
    private int panelHeight = 350;
    private int panelX;
    private int panelY;
    private Tab activeTab = Tab.SERVER;
    private TabButton serverTabButton;
    private TabButton developTabButton;
    private TabButton cheatsTabButton;
    private final List<class_339> serverSettingWidgets = new ArrayList<class_339>();
    private final List<class_339> developSettingWidgets = new ArrayList<class_339>();
    private final List<class_339> cheatsSettingWidgets = new ArrayList<class_339>();
    private class_4185 closeButton;
    private class_4185 actionButton;
    private class_4185 colorTransitionToggle;
    private HourSlider resetHourSlider;
    private int loadedServerHourLocal;
    private int pendingServerHourLocal;
    private ColorSlider starRedSlider;
    private ColorSlider starGreenSlider;
    private ColorSlider starBlueSlider;
    private OpacitySlider starOpacitySlider;
    private ColorSlider bgRedSlider;
    private ColorSlider bgGreenSlider;
    private ColorSlider bgBlueSlider;
    private OpacitySlider panelOpacitySlider;

    public SettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Settings"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.serverSettingWidgets.clear();
        this.developSettingWidgets.clear();
        this.cheatsSettingWidgets.clear();
        this.panelX = (this.field_22789 - this.panelWidth) / 2;
        int tabY = this.panelY = (this.field_22790 - this.panelHeight) / 2;
        int tabStartX = this.panelX;
        this.serverTabButton = (TabButton)ButtonFactory.createTab(tabStartX, tabY, 100, 30, (class_2561)class_2561.method_43470((String)Tab.SERVER.getDisplayName()), this.activeTab == Tab.SERVER, btn -> this.switchTab(Tab.SERVER));
        this.method_37063((class_364)this.serverTabButton);
        int nextTabX = tabStartX + 100 + 2;
        if (SettingsScreen.isDevelopmentMode()) {
            this.developTabButton = (TabButton)ButtonFactory.createTab(nextTabX, tabY, 100, 30, (class_2561)class_2561.method_43470((String)Tab.DEVELOP.getDisplayName()), this.activeTab == Tab.DEVELOP, btn -> this.switchTab(Tab.DEVELOP));
            this.method_37063((class_364)this.developTabButton);
            nextTabX += 102;
        }
        if (this.canAccessCheats()) {
            this.cheatsTabButton = (TabButton)ButtonFactory.createTab(nextTabX, tabY, 100, 30, (class_2561)class_2561.method_43470((String)Tab.CHEATS.getDisplayName()), this.activeTab == Tab.CHEATS, btn -> this.switchTab(Tab.CHEATS));
            this.method_37063((class_364)this.cheatsTabButton);
        }
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonsStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(buttonsStartX, buttonY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.actionButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Action"), button -> this.handleActionClick()).method_46434(buttonsStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.actionButton);
        this.createServerSettings();
        if (SettingsScreen.isDevelopmentMode()) {
            this.createDevelopSettings();
        }
        if (this.canAccessCheats()) {
            this.createCheatsSettings();
        }
        this.switchTab(this.activeTab);
    }

    private void handleActionClick() {
        if (this.activeTab == Tab.SERVER) {
            int utcValue = SettingsScreen.convertLocalToUtc(this.pendingServerHourLocal);
            ServerConfig.getInstance().setGuaranteedTokenResetHour(utcValue);
            new UpdateGuaranteedResetHourPacket(utcValue).sendToServer();
            this.loadedServerHourLocal = this.pendingServerHourLocal;
            this.updateActionButtonState();
        } else if (this.activeTab == Tab.DEVELOP) {
            ClientConfig.getInstance().resetColors();
            this.starRedSlider.setValue(1.0);
            this.starGreenSlider.setValue(1.0);
            this.starBlueSlider.setValue(1.0);
            this.starOpacitySlider.setValue(0.2);
            this.bgRedSlider.setValue(0.0);
            this.bgGreenSlider.setValue(0.0);
            this.bgBlueSlider.setValue(0.0);
            this.panelOpacitySlider.setValue(0.9);
            this.colorTransitionToggle.method_25355((class_2561)class_2561.method_43470((String)"Transition: ON"));
        }
    }

    private void updateActionButtonState() {
        if (this.activeTab == Tab.SERVER) {
            this.actionButton.method_25355((class_2561)class_2561.method_43470((String)"Change time"));
            this.actionButton.field_22763 = this.pendingServerHourLocal != this.loadedServerHourLocal;
            this.actionButton.field_22764 = true;
        } else if (this.activeTab == Tab.DEVELOP) {
            this.actionButton.method_25355((class_2561)class_2561.method_43470((String)"Reset Colors"));
            this.actionButton.field_22763 = true;
            this.actionButton.field_22764 = true;
        } else {
            this.actionButton.field_22764 = false;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int lineWidth;
        int i;
        int explanationY;
        int headerY;
        if (this.parent != null) {
            this.parent.method_25394(graphics, -1, -1, partialTicks);
        }
        graphics.method_51452();
        RenderSystem.disableScissor();
        RenderSystem.enableDepthTest();
        RenderSystem.clear((int)256, (boolean)false);
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, 0x70000000);
        int contentPanelY = this.panelY + 30;
        int contentPanelHeight = this.panelHeight - 30;
        ClientConfig config = ClientConfig.getInstance();
        int alpha = (int)(config.panelOpacity * 255.0f);
        int panelBgColor = alpha << 24 | 0;
        graphics.method_25294(this.panelX, contentPanelY, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, panelBgColor);
        graphics.method_25294(this.panelX, contentPanelY, this.panelX + this.panelWidth, contentPanelY + 1, 0x60FFFFFF);
        graphics.method_25294(this.panelX, contentPanelY + contentPanelHeight - 1, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        graphics.method_25294(this.panelX, contentPanelY, this.panelX + 1, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        graphics.method_25294(this.panelX + this.panelWidth - 1, contentPanelY, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        if (SettingsScreen.isDevelopmentMode() && this.activeTab == Tab.DEVELOP) {
            int padding = 20;
            int columnSpacing = 15;
            int availableWidth = this.panelWidth - padding * 2 - columnSpacing * 2;
            int columnWidth = availableWidth / 3;
            int col1X = this.panelX + padding;
            int col2X = col1X + columnWidth + columnSpacing;
            int col3X = col2X + columnWidth + columnSpacing;
            int headerY2 = this.panelY + 30 + 5;
            graphics.method_25303(this.field_22793, "Star Color", col1X, headerY2, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "Background Color", col2X, headerY2, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "Panel & Animation", col3X, headerY2, 0xFFFFFF);
        }
        if (this.activeTab == Tab.SERVER) {
            headerY = this.panelY + 30 + 10;
            graphics.method_25300(this.field_22793, "Token Reset Settings", this.panelX + this.panelWidth / 2, headerY, 0xFFFFFF);
            explanationY = this.panelY + 30 + 80;
            String[] explanationLines = new String[]{"The guaranteed token grants an undiscovered figure from the collection.", "This token resets daily at the hour specified above (in your local time).", "Set this to a time that works best for your server's player base."};
            for (i = 0; i < explanationLines.length; ++i) {
                lineWidth = this.field_22793.method_1727(explanationLines[i]);
                graphics.method_25303(this.field_22793, explanationLines[i], this.panelX + (this.panelWidth - lineWidth) / 2, explanationY + i * 12, 0xAAAAAA);
            }
        }
        if (this.activeTab == Tab.CHEATS) {
            headerY = this.panelY + 30 + 10;
            graphics.method_25300(this.field_22793, "Collection Cheats", this.panelX + this.panelWidth / 2, headerY, 0xFFFFFF);
            explanationY = this.panelY + 30 + 30;
            String[] explanationLines = new String[]{"Use the token reload buttons to restore your tokens.", "Click a collection button to unlock all figures and receive all boxes."};
            for (i = 0; i < explanationLines.length; ++i) {
                lineWidth = this.field_22793.method_1727(explanationLines[i]);
                graphics.method_25303(this.field_22793, explanationLines[i], this.panelX + (this.panelWidth - lineWidth) / 2, explanationY + i * 12, 0xAAAAAA);
            }
        }
        if (SettingsScreen.isDevelopmentMode() && this.activeTab == Tab.DEVELOP) {
            int previewSize = 35;
            int previewSpacing = 50;
            int previewStartX = this.panelX + (this.panelWidth - (previewSize * 2 + previewSpacing)) / 2;
            int previewY = this.panelY + 210;
            int starRed = (int)(config.starColorR * 255.0f);
            int starGreen = (int)(config.starColorG * 255.0f);
            int starBlue = (int)(config.starColorB * 255.0f);
            int starColor = 0xFF000000 | starRed << 16 | starGreen << 8 | starBlue;
            graphics.method_25294(previewStartX - 1, previewY - 1, previewStartX + previewSize + 1, previewY + previewSize + 1, -1);
            graphics.method_25294(previewStartX, previewY, previewStartX + previewSize, previewY + previewSize, starColor);
            graphics.method_25300(this.field_22793, "Stars", previewStartX + previewSize / 2, previewY + previewSize + 5, 0xAAAAAA);
            int bgPreviewX = previewStartX + previewSize + previewSpacing;
            int bgRed = (int)(config.backgroundColorR * 255.0f);
            int bgGreen = (int)(config.backgroundColorG * 255.0f);
            int bgBlue = (int)(config.backgroundColorB * 255.0f);
            int bgColor = 0xFF000000 | bgRed << 16 | bgGreen << 8 | bgBlue;
            graphics.method_25294(bgPreviewX - 1, previewY - 1, bgPreviewX + previewSize + 1, previewY + previewSize + 1, -1);
            graphics.method_25294(bgPreviewX, previewY, bgPreviewX + previewSize, previewY + previewSize, bgColor);
            graphics.method_25300(this.field_22793, "Background", bgPreviewX + previewSize / 2, previewY + previewSize + 5, 0xAAAAAA);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.method_25419();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private static boolean isDevelopmentMode() {
        return Platform.isDevelopmentEnvironment();
    }

    private boolean canAccessCheats() {
        if (SettingsScreen.isDevelopmentMode()) {
            return true;
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            return this.field_22787.field_1724.method_5687(2);
        }
        return false;
    }

    private void createServerSettings() {
        int localHour;
        ServerConfig config = ServerConfig.getInstance();
        int sliderHeight = 20;
        int sliderWidth = 400;
        int sliderX = this.panelX + (this.panelWidth - sliderWidth) / 2;
        int startY = this.panelY + 30 + 50;
        ZoneId localZone = ZoneId.systemDefault();
        String timezoneName = localZone.getDisplayName(TextStyle.SHORT, Locale.getDefault());
        int utcHour = config.getGuaranteedTokenResetHour();
        this.loadedServerHourLocal = localHour = SettingsScreen.convertUtcToLocal(utcHour);
        this.pendingServerHourLocal = localHour;
        this.resetHourSlider = new HourSlider(sliderX, startY, sliderWidth, sliderHeight, (class_2561)class_2561.method_43470((String)("Guaranteed Token Reset Hour (" + timezoneName + "): ")), localHour, localValue -> {
            this.pendingServerHourLocal = localValue;
            this.updateActionButtonState();
        });
        this.serverSettingWidgets.add((class_339)this.resetHourSlider);
    }

    private static int convertUtcToLocal(int utcHour) {
        ZonedDateTime utcTime = ZonedDateTime.now(ZoneId.of("UTC")).withHour(utcHour).withMinute(0).withSecond(0).withNano(0);
        ZonedDateTime localTime = utcTime.withZoneSameInstant(ZoneId.systemDefault());
        return localTime.getHour();
    }

    private static int convertLocalToUtc(int localHour) {
        ZonedDateTime localTime = ZonedDateTime.now(ZoneId.systemDefault()).withHour(localHour).withMinute(0).withSecond(0).withNano(0);
        ZonedDateTime utcTime = localTime.withZoneSameInstant(ZoneId.of("UTC"));
        return utcTime.getHour();
    }

    private void createDevelopSettings() {
        int startY;
        ClientConfig config = ClientConfig.getInstance();
        config.backgroundColorR = 0.0f;
        config.backgroundColorG = 0.0f;
        config.backgroundColorB = 0.0f;
        int padding = 20;
        int columnSpacing = 15;
        int sliderHeight = 20;
        int verticalSpacing = 28;
        int availableWidth = this.panelWidth - padding * 2 - columnSpacing * 2;
        int columnWidth = availableWidth / 3;
        int col1X = this.panelX + padding;
        int col2X = col1X + columnWidth + columnSpacing;
        int col3X = col2X + columnWidth + columnSpacing;
        int col1Y = startY = this.panelY + (SettingsScreen.isDevelopmentMode() ? 50 : 50);
        this.starRedSlider = new ColorSlider(col1X, col1Y, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Red: "), config.starColorR, value -> {
            config.starColorR = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.starRedSlider);
        this.starGreenSlider = new ColorSlider(col1X, col1Y += verticalSpacing, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Green: "), config.starColorG, value -> {
            config.starColorG = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.starGreenSlider);
        this.starBlueSlider = new ColorSlider(col1X, col1Y += verticalSpacing, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Blue: "), config.starColorB, value -> {
            config.starColorB = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.starBlueSlider);
        this.starOpacitySlider = new OpacitySlider(col1X, col1Y += verticalSpacing, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Opacity: "), config.starOpacity, value -> {
            config.starOpacity = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.starOpacitySlider);
        int col2Y = startY;
        this.bgRedSlider = new ColorSlider(col2X, col2Y, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Red: "), config.backgroundColorR, value -> {
            config.backgroundColorR = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.bgRedSlider);
        this.bgGreenSlider = new ColorSlider(col2X, col2Y += verticalSpacing, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Green: "), config.backgroundColorG, value -> {
            config.backgroundColorG = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.bgGreenSlider);
        this.bgBlueSlider = new ColorSlider(col2X, col2Y += verticalSpacing, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Blue: "), config.backgroundColorB, value -> {
            config.backgroundColorB = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.bgBlueSlider);
        int col3Y = startY;
        this.panelOpacitySlider = new OpacitySlider(col3X, col3Y, columnWidth, sliderHeight, (class_2561)class_2561.method_43470((String)"Panel Opacity: "), config.panelOpacity, value -> {
            config.panelOpacity = value.floatValue();
        });
        this.developSettingWidgets.add((class_339)this.panelOpacitySlider);
        this.colorTransitionToggle = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Transition: " + (config.enableColorTransition ? "ON" : "OFF"))), button -> {
            config.enableColorTransition = !config.enableColorTransition;
            button.method_25355((class_2561)class_2561.method_43470((String)("Transition: " + (config.enableColorTransition ? "ON" : "OFF"))));
        }).method_46434(col3X, col3Y += verticalSpacing, columnWidth, sliderHeight).method_46431();
        this.developSettingWidgets.add((class_339)this.colorTransitionToggle);
    }

    private void createCheatsSettings() {
        int padding = 20;
        int buttonWidth = 180;
        int buttonHeight = 24;
        int verticalSpacing = 30;
        int horizontalSpacing = 15;
        int buttonsPerRow = 3;
        int startY = this.panelY + 30 + 50;
        int startX = this.panelX + padding;
        int tokenButtonWidth = 200;
        int tokenButtonSpacing = 15;
        int tokenButtonsStartX = this.panelX + (this.panelWidth - (tokenButtonWidth * 2 + tokenButtonSpacing)) / 2;
        int tokenButtonY = startY;
        class_4185 reloadRegularButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reload Regular Tokens"), button -> {
            ReloadTokensPacket packet = new ReloadTokensPacket(true, false);
            packet.sendToServer();
            button.method_25355((class_2561)class_2561.method_43470((String)"Reloading..."));
            button.field_22763 = false;
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.field_22787.execute(() -> {
                        button.method_25355((class_2561)class_2561.method_43470((String)"Reload Regular Tokens"));
                        button.field_22763 = true;
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }).method_46434(tokenButtonsStartX, tokenButtonY, tokenButtonWidth, buttonHeight).method_46431();
        this.cheatsSettingWidgets.add((class_339)reloadRegularButton);
        class_4185 reloadGuaranteedButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reload Guaranteed Token"), button -> {
            ReloadTokensPacket packet = new ReloadTokensPacket(false, true);
            packet.sendToServer();
            button.method_25355((class_2561)class_2561.method_43470((String)"Reloading..."));
            button.field_22763 = false;
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.field_22787.execute(() -> {
                        button.method_25355((class_2561)class_2561.method_43470((String)"Reload Guaranteed Token"));
                        button.field_22763 = true;
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }).method_46434(tokenButtonsStartX + tokenButtonWidth + tokenButtonSpacing, tokenButtonY, tokenButtonWidth, buttonHeight).method_46431();
        this.cheatsSettingWidgets.add((class_339)reloadGuaranteedButton);
        startY += verticalSpacing + 20;
        Collection<FigureCollection> collections = CollectionRegistry.getAllCollections();
        List filteredCollections = collections.stream().filter(collection -> !collection.getId().equals("default")).collect(Collectors.toList());
        int row = 0;
        int col = 0;
        for (FigureCollection collection2 : filteredCollections) {
            int buttonX = startX + col * (buttonWidth + horizontalSpacing);
            int buttonY = startY + row * verticalSpacing;
            class_4185 unlockButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Unlock " + collection2.getName())), button -> {
                UnlockCollectionPacket packet = new UnlockCollectionPacket(collection2.getId());
                packet.sendToServer();
                button.method_25355((class_2561)class_2561.method_43470((String)"Unlocking..."));
                button.field_22763 = false;
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        this.field_22787.execute(() -> {
                            button.method_25355((class_2561)class_2561.method_43470((String)("Unlock " + collection2.getName())));
                            button.field_22763 = true;
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }).start();
            }).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
            this.cheatsSettingWidgets.add((class_339)unlockButton);
            if (++col < buttonsPerRow) continue;
            col = 0;
            ++row;
        }
    }

    private void switchTab(Tab tab) {
        this.activeTab = tab;
        for (class_339 widget : this.serverSettingWidgets) {
            this.method_37066((class_364)widget);
        }
        for (class_339 widget : this.developSettingWidgets) {
            this.method_37066((class_364)widget);
        }
        for (class_339 widget : this.cheatsSettingWidgets) {
            this.method_37066((class_364)widget);
        }
        List<class_339> activeWidgets = tab == Tab.SERVER ? this.serverSettingWidgets : (tab == Tab.DEVELOP ? this.developSettingWidgets : (tab == Tab.CHEATS ? this.cheatsSettingWidgets : new ArrayList<class_339>()));
        for (class_339 widget : activeWidgets) {
            this.method_37063((class_364)widget);
        }
        this.serverTabButton.setSelected(tab == Tab.SERVER);
        if (this.developTabButton != null) {
            this.developTabButton.setSelected(tab == Tab.DEVELOP);
        }
        if (this.cheatsTabButton != null) {
            this.cheatsTabButton.setSelected(tab == Tab.CHEATS);
        }
        this.updateActionButtonState();
    }

    private static enum Tab {
        SERVER("Server"),
        DEVELOP("Develop"),
        CHEATS("Cheats");

        private final String displayName;

        private Tab(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class ColorSlider
    extends class_357 {
        private final class_2561 prefix;
        private final Consumer<Double> onValueChange;

        public ColorSlider(int x, int y, int width, int height, class_2561 prefix, double initialValue, Consumer<Double> onValueChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), initialValue);
            this.prefix = prefix;
            this.onValueChange = onValueChange;
            this.method_25346();
        }

        protected void method_25346() {
            int intValue = (int)(this.field_22753 * 255.0);
            this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix.getString() + intValue)));
        }

        protected void method_25344() {
            this.onValueChange.accept(this.field_22753);
        }

        public void setValue(double newValue) {
            this.field_22753 = newValue;
            this.method_25346();
        }
    }

    private static class OpacitySlider
    extends class_357 {
        private final class_2561 prefix;
        private final Consumer<Double> onValueChange;

        public OpacitySlider(int x, int y, int width, int height, class_2561 prefix, double initialValue, Consumer<Double> onValueChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), initialValue);
            this.prefix = prefix;
            this.onValueChange = onValueChange;
            this.method_25346();
        }

        protected void method_25346() {
            int percentage = (int)(this.field_22753 * 100.0);
            this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix.getString() + percentage + "%")));
        }

        protected void method_25344() {
            this.onValueChange.accept(this.field_22753);
        }

        public void setValue(double newValue) {
            this.field_22753 = newValue;
            this.method_25346();
        }
    }

    private static class HourSlider
    extends class_357 {
        private final class_2561 prefix;
        private final Consumer<Integer> onValueChange;

        public HourSlider(int x, int y, int width, int height, class_2561 prefix, int initialValue, Consumer<Integer> onValueChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)initialValue / 23.0);
            this.prefix = prefix;
            this.onValueChange = onValueChange;
            this.method_25346();
        }

        protected void method_25346() {
            int hour = (int)(this.field_22753 * 23.0);
            this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix.getString() + String.format("%02d:00", hour))));
        }

        protected void method_25344() {
            int hour = (int)(this.field_22753 * 23.0);
            this.onValueChange.accept(hour);
        }

        public void setValue(int newValue) {
            this.field_22753 = (double)newValue / 23.0;
            this.method_25346();
        }
    }
}

