/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.client.renderer.FigureWidgetRenderer;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class FigureEntry
extends class_4280.class_4281<FigureEntry> {
    private final class_310 mc = class_310.method_1551();
    private final List<FigureDefinition> figures;
    private final String collectionId;
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 70.0f;
    private float zRotation = 0.0f;
    private float xOffset = -60.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;
    private static final int FIGURE_SIZE = 80;
    private static final int GRID_SPACING = 4;

    public FigureEntry(List<FigureDefinition> figures, String collectionId) {
        this.figures = new ArrayList<FigureDefinition>(figures);
        this.collectionId = collectionId;
    }

    public void setConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        int effectiveFigureSize = 80;
        int effectiveSpacing = 4;
        if (GuiScaleManager.isUsingInverseScale()) {
            float scale = GuiScaleManager.getRenderScaleFactor();
            effectiveFigureSize = (int)(80.0f * scale);
            effectiveSpacing = (int)(4.0f * scale);
        }
        int totalFiguresWidth = this.figures.size() * effectiveFigureSize + (this.figures.size() - 1) * effectiveSpacing;
        int startX = x + (entryWidth - totalFiguresWidth) / 2;
        for (int i = 0; i < this.figures.size(); ++i) {
            boolean isFigureHovered;
            FigureDefinition figure = this.figures.get(i);
            int figureX = startX + i * (effectiveFigureSize + effectiveSpacing);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            if (isDiscovered) {
                graphics.method_25294(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x30FFFFFF);
            } else {
                graphics.method_25294(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x50000000);
            }
            boolean bl = isFigureHovered = mouseX >= figureX && mouseX < figureX + effectiveFigureSize && mouseY >= y && mouseY < y + effectiveFigureSize;
            if (isFigureHovered) {
                if (isDiscovered) {
                    graphics.method_25294(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x40FFFFFF);
                } else {
                    graphics.method_25294(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x60000000);
                }
            }
            int borderColor = isDiscovered ? -2130706433 : 0x60808080;
            graphics.method_25294(figureX, y, figureX + effectiveFigureSize, y + 1, borderColor);
            graphics.method_25294(figureX, y + effectiveFigureSize - 1, figureX + effectiveFigureSize, y + effectiveFigureSize, borderColor);
            graphics.method_25294(figureX, y, figureX + 1, y + effectiveFigureSize, borderColor);
            graphics.method_25294(figureX + effectiveFigureSize - 1, y, figureX + effectiveFigureSize, y + effectiveFigureSize, borderColor);
            if (isDiscovered) {
                this.render3DFigure(graphics, figure, figureX, y, effectiveFigureSize, partialTick);
                int guiScale = (Integer)this.mc.field_1690.method_42474().method_41753();
                if (guiScale >= 3) continue;
                class_5250 figureName = class_2561.method_43470((String)figure.getName());
                int nameWidth = this.mc.field_1772.method_27525((class_5348)figureName);
                if (nameWidth > effectiveFigureSize - 4) {
                    String truncated = figure.getName();
                    while (this.mc.field_1772.method_1727(truncated + "...") > effectiveFigureSize - 4 && truncated.length() > 0) {
                        truncated = truncated.substring(0, truncated.length() - 1);
                    }
                    figureName = class_2561.method_43470((String)(truncated + "..."));
                }
                int nameX = figureX + (effectiveFigureSize - this.mc.field_1772.method_27525((class_5348)figureName)) / 2;
                Objects.requireNonNull(this.mc.field_1772);
                int nameY = y + effectiveFigureSize - 9 - 2;
                graphics.method_51439(this.mc.field_1772, (class_2561)figureName, nameX, nameY, 0xFFFFFF, true);
                continue;
            }
            class_5250 questionMark = class_2561.method_43470((String)"?");
            int qmWidth = this.mc.field_1772.method_27525((class_5348)questionMark);
            int qmX = figureX + (effectiveFigureSize - qmWidth) / 2;
            Objects.requireNonNull(this.mc.field_1772);
            int qmY = y + (effectiveFigureSize - 9) / 2;
            graphics.method_51439(this.mc.field_1772, (class_2561)questionMark, qmX, qmY, 0x808080, false);
        }
    }

    private void render3DFigure(class_332 graphics, FigureDefinition figure, int x, int y, int size, float partialTick) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        BoxBlockEntity renderEntity = FigureWidgetRenderer.getOrCreateRenderEntity(figure, this.collectionId);
        if (renderEntity == null) {
            poseStack.method_22909();
            return;
        }
        graphics.method_44379(x, y, x + size, y + size);
        RenderSystem.disableDepthTest();
        float centerX = (float)x + (float)size / 2.0f + this.xOffset;
        float centerY = (float)y + (float)size * 0.6f + this.yOffset;
        float baseZ = 100.0f + this.zOffset;
        float centerZ = baseZ * ((float)size / 80.0f);
        class_308.method_24210();
        poseStack.method_46416(centerX, centerY, centerZ);
        float scale = (float)size * this.modelScale;
        poseStack.method_22905(scale, -scale, scale);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(this.yRotation));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(this.xRotation));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(this.zRotation));
        class_4597.class_4598 bufferSource = this.mc.method_22940().method_23000();
        FigureModel figureModel = FigureWidgetRenderer.getModel();
        GeoBlockRenderer<BoxBlockEntity> figureRenderer = FigureWidgetRenderer.getRenderer();
        try {
            class_2960 modelResource = figureModel.getModelResource(renderEntity);
            if (modelResource == null) {
                RenderSystem.enableDepthTest();
                graphics.method_44380();
                poseStack.method_22909();
                return;
            }
            BakedGeoModel bakedModel = figureModel.getBakedModel(modelResource);
            class_2960 textureResource = figureModel.getTextureResource(renderEntity);
            if (textureResource == null) {
                RenderSystem.enableDepthTest();
                graphics.method_44380();
                poseStack.method_22909();
                return;
            }
            class_1921 renderType = figureModel.getRenderType(renderEntity, textureResource);
            class_4588 buffer = bufferSource.getBuffer(renderType);
            figureRenderer.actuallyRender(poseStack, (class_2586)renderEntity, bakedModel, renderType, (class_4597)bufferSource, buffer, false, partialTick, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            bufferSource.method_22993();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.enableDepthTest();
        graphics.method_44380();
        class_308.method_24211();
        poseStack.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    public class_2561 method_37006() {
        if (this.figures.isEmpty()) {
            return class_2561.method_43470((String)"Empty row");
        }
        if (this.figures.size() == 1) {
            FigureDefinition figure = this.figures.get(0);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            return class_2561.method_43470((String)(isDiscovered ? figure.getName() : "Undiscovered Figure"));
        }
        int discoveredCount = 0;
        for (FigureDefinition figure : this.figures) {
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(uniqueFigureId)) continue;
            ++discoveredCount;
        }
        return class_2561.method_43470((String)(discoveredCount + " of " + this.figures.size() + " figures discovered"));
    }

    public List<FigureDefinition> getFigures() {
        return this.figures;
    }
}

