/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.model;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import software.bernie.geckolib.model.GeoModel;

public class FigureModel
extends GeoModel<BoxBlockEntity> {
    private static final class_2960 FALLBACK_TEXTURE = new class_2960("minecraft", "textures/entity/steve.png");
    private static final class_2960 POSE_ANIMATION = new class_2960("blockpops", "animations/figure/figure_poses.animation.json");
    private static final Map<String, GameProfile> snapshotProfileCache = new ConcurrentHashMap<String, GameProfile>();
    private static final Map<String, Boolean> snapshotRegistrationCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<UUID, GameProfile> liveProfileCache = new ConcurrentHashMap<UUID, GameProfile>();
    private static final Map<UUID, Boolean> liveRegistrationCache = new ConcurrentHashMap<UUID, Boolean>();
    private static boolean checkedQuickSkin = false;
    private static boolean quickSkinAvailable = false;
    private static Method getSkinLocationMethod;
    private static Object skinServiceInstance;

    private static class_2960 resolveQuickSkinId(String skinId) {
        if (!checkedQuickSkin) {
            try {
                Class<?> serviceClass = Class.forName("com.quickskin.mod.client.services.SkinService");
                Method getInstanceMethod = serviceClass.getMethod("getInstance", new Class[0]);
                skinServiceInstance = getInstanceMethod.invoke(null, new Object[0]);
                getSkinLocationMethod = serviceClass.getMethod("getSkinLocation", UUID.class, String.class);
                quickSkinAvailable = true;
            }
            catch (Exception e) {
                quickSkinAvailable = false;
            }
            checkedQuickSkin = true;
        }
        if (quickSkinAvailable && skinServiceInstance != null && skinId != null) {
            try {
                return (class_2960)getSkinLocationMethod.invoke(skinServiceInstance, null, skinId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static class_2960 getLiveQuickSkin(UUID uuid) {
        try {
            Class<?> serviceClass = Class.forName("com.quickskin.mod.client.services.PlayerAppearanceService");
            Method getInstanceMethod = serviceClass.getMethod("getInstance", new Class[0]);
            Object instance = getInstanceMethod.invoke(null, new Object[0]);
            Method getLocMethod = serviceClass.getMethod("getSkinLocation", UUID.class);
            return (class_2960)getLocMethod.invoke(instance, uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public class_2960 getModelResource(BoxBlockEntity animatable) {
        FigureDefinition figure = animatable.getFigureDefinition();
        return figure != null ? figure.getModelPath() : null;
    }

    public class_2960 getTextureResource(BoxBlockEntity animatable) {
        int altListIndex;
        FigureDefinition figure = animatable.getFigureDefinition();
        if (figure == null) {
            return FALLBACK_TEXTURE;
        }
        int skinIndex = animatable.getAlternativeSkinIndex();
        if (skinIndex > 0 && figure.hasAlternatives() && (altListIndex = skinIndex - 1) < figure.getAlternatives().size()) {
            return figure.getAlternatives().get(altListIndex).texture();
        }
        if (figure.getType() == FigureType.PLAYER && figure.getPlayerUUID() != null) {
            class_2960 loc;
            class_640 info;
            class_2960 liveQS;
            class_2960 loc2;
            String qsId = animatable.getQuickSkinId();
            if (qsId != null && !qsId.isEmpty() && (loc2 = FigureModel.resolveQuickSkinId(qsId)) != null) {
                return loc2;
            }
            String nbtSnapshot = animatable.getSkinSnapshot();
            if (nbtSnapshot != null && !nbtSnapshot.isEmpty()) {
                return this.getSkinLocationFromSnapshot(figure, nbtSnapshot);
            }
            if (quickSkinAvailable && (liveQS = FigureModel.getLiveQuickSkin(figure.getPlayerUUID())) != null) {
                return liveQS;
            }
            if (class_310.method_1551().method_1562() != null && (info = class_310.method_1551().method_1562().method_2871(figure.getPlayerUUID())) != null) {
                return info.method_2968();
            }
            String uniqueFigureId = animatable.getCollectionId() + ":" + animatable.getFigureId();
            String discoveryQuickSkin = ClientDiscoveryManager.getFigureQuickSkin(uniqueFigureId);
            if (discoveryQuickSkin != null && !discoveryQuickSkin.isEmpty() && (loc = FigureModel.resolveQuickSkinId(discoveryQuickSkin)) != null) {
                return loc;
            }
            String discoverySnapshot = ClientDiscoveryManager.getFigureSkin(uniqueFigureId);
            if (discoverySnapshot != null && !discoverySnapshot.isEmpty()) {
                return this.getSkinLocationFromSnapshot(figure, discoverySnapshot);
            }
            GameProfile profile = liveProfileCache.computeIfAbsent(figure.getPlayerUUID(), uuid -> new GameProfile(uuid, figure.getName()));
            liveRegistrationCache.computeIfAbsent(figure.getPlayerUUID(), uuid -> {
                class_310.method_1551().method_1582().method_4652(profile, (type, location, p) -> {}, false);
                return true;
            });
            return class_310.method_1551().method_1582().method_44705(profile);
        }
        return figure.getTexturePath() != null ? figure.getTexturePath() : FALLBACK_TEXTURE;
    }

    private class_2960 getSkinLocationFromSnapshot(FigureDefinition figure, String snapshot) {
        UUID snapshotUUID = UUID.nameUUIDFromBytes((figure.getPlayerUUID().toString() + snapshot).getBytes());
        String uniqueCacheKey = snapshotUUID.toString();
        GameProfile profile = snapshotProfileCache.computeIfAbsent(uniqueCacheKey, id -> {
            GameProfile newProfile = new GameProfile(snapshotUUID, figure.getName());
            newProfile.getProperties().put((Object)"textures", (Object)new Property("textures", snapshot));
            return newProfile;
        });
        snapshotRegistrationCache.computeIfAbsent(uniqueCacheKey, id -> {
            class_310.method_1551().method_1582().method_4652(profile, (type, location, texture) -> {}, false);
            return true;
        });
        return class_310.method_1551().method_1582().method_44705(profile);
    }

    public class_2960 getAnimationResource(BoxBlockEntity animatable) {
        return POSE_ANIMATION;
    }

    public class_1921 getRenderType(BoxBlockEntity animatable, class_2960 texture) {
        class_2960 textureToUse = this.getTextureResource(animatable);
        if (textureToUse == null) {
            textureToUse = FALLBACK_TEXTURE;
        }
        return class_1921.method_23578((class_2960)textureToUse);
    }
}

