/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public final class FigureWidgetRenderer {
    private static FigureModel figureModel;
    private static GeoBlockRenderer<BoxBlockEntity> figureRenderer;
    private static final Map<String, BoxBlockEntity> renderEntityCache;
    private static volatile boolean initialized;

    private FigureWidgetRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureInitialized() {
        if (initialized) return;
        Class<FigureWidgetRenderer> clazz = FigureWidgetRenderer.class;
        synchronized (FigureWidgetRenderer.class) {
            if (initialized) return;
            figureModel = new FigureModel();
            figureRenderer = new GeoBlockRenderer((GeoModel)figureModel);
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static FigureModel getModel() {
        FigureWidgetRenderer.ensureInitialized();
        return figureModel;
    }

    public static GeoBlockRenderer<BoxBlockEntity> getRenderer() {
        FigureWidgetRenderer.ensureInitialized();
        return figureRenderer;
    }

    public static BoxBlockEntity getOrCreateRenderEntity(FigureDefinition figure, String collectionId) {
        if (figure == null || collectionId == null) {
            return null;
        }
        String cacheKey = collectionId + ":" + figure.getId();
        return renderEntityCache.computeIfAbsent(cacheKey, key -> {
            try {
                PopBlockColor favoriteColor;
                BoxBlockEntity entity = new BoxBlockEntity(class_2338.field_10980, class_2246.field_10124.method_9564());
                entity.method_31662((class_1937)class_310.method_1551().field_1687);
                entity.setFigureId(figure.getId());
                entity.setCollectionIdOverride(collectionId);
                if (figure.getType() == FigureType.PLAYER && (favoriteColor = figure.getFavoriteColor()) != null) {
                    entity.setColorOverride(favoriteColor.name());
                }
                return entity;
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public static void clearCache() {
        renderEntityCache.clear();
    }

    public static int getCacheSize() {
        return renderEntityCache.size();
    }

    static {
        renderEntityCache = new ConcurrentHashMap<String, BoxBlockEntity>();
        initialized = false;
    }
}

