/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFavoriteColorCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFavoriteColorCommand.class);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"blockpops").then(class_2170.method_9247((String)"getfavoritecolor").executes(GetFavoriteColorCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            class_3222 player = source.method_9207();
            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
            if (!discovery.hasChosenFavoriteColor()) {
                source.method_9226(() -> class_2561.method_43470((String)"You have not chosen a favorite color yet. Use /blockpops changefavoritecolor to choose one."), false);
                LOGGER.info("Player {} checked their favorite color but hasn't chosen one yet", (Object)player.method_5477().getString());
            } else {
                PopBlockColor favoriteColor = discovery.getFavoriteColor();
                if (favoriteColor != null) {
                    String colorName = GetFavoriteColorCommand.formatColorName(favoriteColor.method_15434());
                    source.method_9226(() -> class_2561.method_43470((String)("Your favorite color is: " + colorName)), false);
                    LOGGER.info("Player {} checked their favorite color: {}", (Object)player.method_5477().getString(), (Object)favoriteColor.method_15434());
                } else {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Error: Favorite color data is corrupted. Please choose a new color with /blockpops changefavoritecolor"));
                    LOGGER.warn("Player {} has chosen a favorite color but the data is null", (Object)player.method_5477().getString());
                }
            }
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing getfavoritecolor command", (Throwable)e);
            return 0;
        }
    }

    private static String formatColorName(String colorName) {
        String[] words = colorName.split("_");
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                formatted.append(" ");
            }
            formatted.append(words[i].substring(0, 1).toUpperCase());
            formatted.append(words[i].substring(1));
        }
        return formatted.toString();
    }
}

