/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadRegularTokensCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadRegularTokensCommand.class);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"blockpops").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadregular").requires(source -> source.method_9259(2))).executes(ReloadRegularTokensCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            class_3222 player = source.method_9207();
            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
            discovery.setRegularTokens(3);
            discovery.setNextRegularTokenTime(0L);
            PlayerDataManager.markDirty((class_1657)player, discovery);
            LOGGER.info("Reloaded regular tokens for player {}", (Object)player.method_5477().getString());
            long gameTime = player.method_51469().method_8510();
            long nextRegularTime = discovery.getNextRegularTokenTime();
            long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
            long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
            SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
            source.method_9226(() -> class_2561.method_43470((String)"Reloaded regular tokens to 3"), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing reloadregular command", (Throwable)e);
            return 0;
        }
    }
}

