/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.data;

import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDiscovery;
import com.theplumteam.data.fabric.PlayerDataManagerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.WeakHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class PlayerDataManager {
    public static final String DATA_KEY = "blockpops_discovery";
    private static final WeakHashMap<class_1657, PlayerDiscovery> cache = new WeakHashMap();

    public static IPlayerDiscovery getDiscovery(class_1657 player) {
        PlayerDiscovery cached = cache.get(player);
        if (cached != null) {
            return cached;
        }
        PlayerDiscovery discovery = new PlayerDiscovery();
        class_2487 persistentData = PlayerDataManager.getPersistentData(player);
        if (persistentData.method_10573(DATA_KEY, 10)) {
            discovery.deserializeNBT(persistentData.method_10562(DATA_KEY));
        }
        cache.put(player, discovery);
        return discovery;
    }

    public static void saveDiscovery(class_1657 player) {
        PlayerDiscovery discovery = cache.get(player);
        if (discovery != null) {
            PlayerDataManager.getPersistentData(player).method_10566(DATA_KEY, (class_2520)discovery.serializeNBT());
        }
    }

    public static void markDirty(class_1657 player, IPlayerDiscovery discovery) {
        if (discovery instanceof PlayerDiscovery) {
            PlayerDiscovery pd = (PlayerDiscovery)discovery;
            cache.put(player, pd);
            PlayerDataManager.getPersistentData(player).method_10566(DATA_KEY, (class_2520)pd.serializeNBT());
        }
    }

    public static void copyData(class_1657 from, class_1657 to) {
        class_2487 fromData = PlayerDataManager.getPersistentData(from);
        if (fromData.method_10573(DATA_KEY, 10)) {
            PlayerDataManager.getPersistentData(to).method_10566(DATA_KEY, (class_2520)fromData.method_10562(DATA_KEY).method_10553());
            cache.remove(to);
        }
    }

    public static void clearCache(class_1657 player) {
        cache.remove(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2487 getPersistentData(class_1657 player) {
        return PlayerDataManagerImpl.getPersistentData(player);
    }
}

