/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.fabric;

import com.theplumteam.BlockPopsMod;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.blockentity.FigureBlockEntity;
import com.theplumteam.command.ModCommands;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.PlayerCollectionHelper;
import com.theplumteam.network.OpenFavoriteColorScreenPacket;
import com.theplumteam.network.SyncDiscoveryDataPacket;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModBlocks;
import com.theplumteam.registry.ModCreativeTabs;
import com.theplumteam.registry.ModItems;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class BlockPopsFabric
implements ModInitializer {
    public void onInitialize() {
        BlockPopsMod.LOGGER.info("BlockPops loading on Fabric platform");
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeTabs.register();
        BlockPopsMod.init();
        CommandRegistrationEvent.EVENT.register(ModCommands::register);
        this.registerServerEvents();
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            BoxBlockEntity boxBlockEntity;
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            if (!player.method_5715()) {
                return class_1269.field_5811;
            }
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            class_2586 blockEntity = world.method_8321(hitResult.method_17777());
            if (blockEntity instanceof FigureBlockEntity) {
                FigureBlockEntity figureBlockEntity = (FigureBlockEntity)blockEntity;
                if (figureBlockEntity.hasFigure()) {
                    figureBlockEntity.cyclePose();
                    player.method_7353((class_2561)class_2561.method_43470((String)("Pose changed to: " + figureBlockEntity.getPoseIndex())), true);
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            if (blockEntity instanceof BoxBlockEntity && (boxBlockEntity = (BoxBlockEntity)blockEntity).hasFigure() && boxBlockEntity.isFigureExtracted()) {
                boxBlockEntity.cyclePose();
                player.method_7353((class_2561)class_2561.method_43470((String)("Pose changed to: " + boxBlockEntity.getPoseIndex())), true);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        BlockPopsMod.LOGGER.info("BlockPops Fabric initialization complete");
    }

    private void registerServerEvents() {
        LifecycleEvent.SERVER_STARTING.register(server -> {
            BlockPopsMod.LOGGER.info("Loading static collections on server...");
            CollectionRegistry.loadCollections(server.method_34864());
            BlockPopsMod.LOGGER.info("Generating World Players collection...");
            FigureCollection playerCollection = PlayerCollectionHelper.generate(server);
            CollectionRegistry.registerDynamicCollection(playerCollection);
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (player.method_5682() != null) {
                FigureCollection updatedPlayerCollection = PlayerCollectionHelper.generate(player.method_5682());
                CollectionRegistry.registerDynamicCollection(updatedPlayerCollection);
                BlockPopsMod.LOGGER.debug("Updated World Players collection after player join: {}", (Object)player.method_5477().getString());
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = player;
                    ArrayList<FigureCollection> allCollections = new ArrayList<FigureCollection>(CollectionRegistry.getAllCollections());
                    SyncDynamicCollectionsPacket.sendToPlayer(serverPlayer, allCollections);
                    BlockPopsMod.LOGGER.info("Synced {} collections to joining player {}", (Object)allCollections.size(), (Object)player.method_5477().getString());
                }
                ArrayList<FigureCollection> dynamicUpdate = new ArrayList<FigureCollection>();
                dynamicUpdate.add(updatedPlayerCollection);
                for (class_3222 p : player.method_5682().method_3760().method_14571()) {
                    if (p == player) continue;
                    SyncDynamicCollectionsPacket.sendToPlayer(p, dynamicUpdate);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = player;
                    IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)serverPlayer);
                    SyncDiscoveryDataPacket.sendToPlayer(serverPlayer, discovery.getDiscoveredSet(), discovery.getAllFigureSkins(), discovery.getAllFigureQuickSkins());
                    BlockPopsMod.LOGGER.info("Synced {} discovered figures, {} skins, and {} quick skins to {}", new Object[]{discovery.getDiscoveredSet().size(), discovery.getAllFigureSkins().size(), discovery.getAllFigureQuickSkins().size(), serverPlayer.method_5477().getString()});
                    long gameTime = serverPlayer.method_51469().method_8510();
                    long nextRegularTime = discovery.getNextRegularTokenTime();
                    long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                    long millisUntilReset = BlockPopsFabric.calculateMillisUntilNextReset();
                    SyncTokenDataPacket.sendToPlayer(serverPlayer, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
                    BlockPopsMod.LOGGER.info("Synced token data to {}: {} regular tokens, special: {}", new Object[]{serverPlayer.method_5477().getString(), discovery.getRegularTokens(), !discovery.hasUsedTodaySpecialToken() ? "available" : "used"});
                    if (!discovery.hasChosenFavoriteColor()) {
                        BlockPopsMod.LOGGER.info("Player {} has not chosen a favorite color. Sending packet to open selection screen.", (Object)serverPlayer.method_5477().getString());
                        OpenFavoriteColorScreenPacket.sendToPlayer(serverPlayer);
                    }
                }
            }
        });
    }

    private static long calculateMillisUntilNextReset() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime nextReset = now.withHour(18).withMinute(0).withSecond(0).withNano(0);
        if (now.getHour() >= 18) {
            nextReset = nextReset.plusDays(1L);
        }
        return nextReset.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
    }
}

